/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.inline.literal;

import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.IMathOpHandler;
import com.bigdata.rdf.internal.constraints.MathBOp;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.XMLSchema;
import org.wikidata.query.rdf.blazegraph.inline.literal.AbstractMultiTypeExtension;
import org.wikidata.query.rdf.common.WikibaseDate;

public class WikibaseDateExtension<V extends BigdataValue>
extends AbstractMultiTypeExtension<V>
implements IMathOpHandler {
    private static final List<URI> SUPPORTED_DATA_TYPES = Collections.unmodifiableList(Arrays.asList(XMLSchema.DATETIME, XMLSchema.DATE));
    protected static final DatatypeFactory DATATYPE_FACTORY;

    public WikibaseDateExtension(IDatatypeURIResolver resolver) {
        super(resolver, SUPPORTED_DATA_TYPES);
    }

    @Override
    protected AbstractLiteralIV createDelegateIV(Literal literal, BigdataURI dt) {
        WikibaseDate date = WikibaseDate.fromString((String)literal.stringValue()).cleanWeirdStuff();
        return new XSDNumericIV(date.secondsSinceEpoch());
    }

    @Override
    protected BigdataLiteral safeAsValue(LiteralExtensionIV iv, BigdataValueFactory vf, BigdataURI dt) {
        WikibaseDate date = WikibaseDate.fromSecondsSinceEpoch((long)iv.getDelegate().longValue());
        if (dt.equals(XMLSchema.DATE)) {
            return vf.createLiteral(date.toString(WikibaseDate.ToStringFormat.DATE), (URI)dt);
        }
        return vf.createLiteral(date.toString(WikibaseDate.ToStringFormat.DATE_TIME), (URI)dt);
    }

    private boolean isWikibaseDateURI(URI lit) {
        if (lit == null) {
            return false;
        }
        return SUPPORTED_DATA_TYPES.contains(lit);
    }

    public boolean canInvokeMathOp(Literal ... args) {
        if (args.length != 2) {
            return false;
        }
        URI dt1 = args[0].getDatatype();
        URI dt2 = args[1].getDatatype();
        if (dt1 == null || dt2 == null) {
            return false;
        }
        boolean d1 = this.isWikibaseDateURI(dt1);
        boolean d2 = this.isWikibaseDateURI(dt2);
        if (d1 && d2) {
            return true;
        }
        if (d1 && dt2.equals((Object)XMLSchema.DURATION)) {
            return true;
        }
        return d2 && dt1.equals((Object)XMLSchema.DURATION);
    }

    private LiteralExtensionIV normalizeIV(Literal l, IV iv) {
        if (iv instanceof LiteralExtensionIV) {
            return (LiteralExtensionIV)iv;
        }
        return this.createIV((Value)l);
    }

    public IV doMathOp(Literal l1, IV iv1, Literal l2, IV iv2, MathBOp.MathOp op, BigdataValueFactory vf) {
        LiteralExtensionIV liv2;
        URI dt1 = l1.getDatatype();
        URI dt2 = l2.getDatatype();
        boolean d1 = this.isWikibaseDateURI(dt1);
        boolean d2 = this.isWikibaseDateURI(dt2);
        if (!d1 && !d2) {
            throw new SparqlTypeErrorException();
        }
        LiteralExtensionIV liv1 = d1 ? this.normalizeIV(l1, iv1) : null;
        LiteralExtensionIV literalExtensionIV = liv2 = d2 ? this.normalizeIV(l2, iv2) : null;
        if (d1 && d2) {
            return this.handleTwoDates(liv1, liv2, op, vf);
        }
        if (op == MathBOp.MathOp.PLUS) {
            LiteralExtensionIV iv = d1 ? liv1 : liv2;
            Literal lduration = d1 ? l2 : l1;
            return this.datePlusDuration(iv, DATATYPE_FACTORY.newDuration(lduration.getLabel()), vf);
        }
        if (op == MathBOp.MathOp.MINUS) {
            return this.datePlusDuration(liv1, DATATYPE_FACTORY.newDuration(l2.getLabel()).negate(), vf);
        }
        throw new SparqlTypeErrorException();
    }

    private IV handleTwoDates(LiteralExtensionIV iv1, LiteralExtensionIV iv2, MathBOp.MathOp op, BigdataValueFactory vf) {
        long ts1 = iv1.getDelegate().longValue();
        long ts2 = iv2.getDelegate().longValue();
        switch (op) {
            case MIN: {
                return ts1 < ts2 ? iv1 : iv2;
            }
            case MAX: {
                return ts1 > ts2 ? iv1 : iv2;
            }
            case MINUS: {
                double days = (double)(ts1 - ts2) / 86400.0;
                return new XSDNumericIV(days);
            }
        }
        throw new SparqlTypeErrorException();
    }

    private BigdataURI getDataType(LiteralExtensionIV iv) {
        if (iv.hasValue() && iv.getValue() instanceof BigdataLiteral) {
            return ((BigdataLiteral)iv.getValue()).getDatatype();
        }
        if (iv.getExtensionIV().hasValue()) {
            return (BigdataURI)iv.getExtensionIV().getValue();
        }
        throw new SparqlTypeErrorException();
    }

    private IV datePlusDuration(LiteralExtensionIV iv, Duration d, BigdataValueFactory vf) {
        long ts = iv.getDelegate().longValue();
        WikibaseDate newdate = WikibaseDate.fromSecondsSinceEpoch((long)ts).addDuration(d);
        LiteralExtensionIV result = new LiteralExtensionIV((AbstractLiteralIV)new XSDNumericIV(newdate.secondsSinceEpoch()), iv.getExtensionIV());
        result.setValue((BigdataValue)this.safeAsValue(result, vf, this.getDataType(iv)));
        return result;
    }

    static {
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

