/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.label;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BD;
import com.bigdata.striterator.IChunkedOrderedIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDFS;
import org.wikidata.query.rdf.common.uri.WikibaseUris;

public class LabelService
extends AbstractServiceFactory {
    private static final BigdataNativeServiceOptions SERVICE_OPTIONS = new BigdataNativeServiceOptions();
    public static final URI SERVICE_KEY = new URIImpl("http://wikiba.se/ontology#label");
    private static final URIImpl LANGUAGE_PARAM = new URIImpl("http://wikiba.se/ontology#language");

    public static void register() {
        ServiceRegistry reg = ServiceRegistry.getInstance();
        reg.add(SERVICE_KEY, (ServiceFactory)new LabelService());
        reg.addWhitelistURL(SERVICE_KEY.toString());
    }

    public IServiceOptions getServiceOptions() {
        return SERVICE_OPTIONS;
    }

    public BigdataServiceCall create(ServiceCallCreateParams params, ServiceParams serviceParams) {
        return new LabelServiceCall(new ResolutionContext(params.getTripleStore(), this.findLanguageFallbacks(serviceParams)), this.findResolutions(params));
    }

    private Map<String, Integer> findLanguageFallbacks(ServiceParams params) {
        List paramNodes = params.get((URI)LANGUAGE_PARAM);
        if (paramNodes.size() < 1) {
            throw new IllegalArgumentException("You must provide the label service a list of languages.");
        }
        HashMap<String, Integer> fallbacksMap = new HashMap<String, Integer>();
        int cnt = 0;
        for (TermNode term : paramNodes) {
            if (term.isVariable()) {
                throw new IllegalArgumentException("not a constant");
            }
            BigdataValue v = term.getValue();
            if (!(v instanceof Literal)) {
                throw new IllegalArgumentException("not a literal");
            }
            String s = v.stringValue().trim();
            if (s.contains(",")) {
                for (String ls : s.split(",")) {
                    String key = ls.trim();
                    if (!fallbacksMap.containsKey(key)) {
                        fallbacksMap.put(key, cnt);
                    }
                    ++cnt;
                }
            } else if (!fallbacksMap.containsKey(s)) {
                fallbacksMap.put(s, cnt);
            }
            ++cnt;
        }
        return fallbacksMap;
    }

    @SuppressFBWarnings(value={"EC_UNRELATED_CLASS_AND_INTERFACE"}, justification="equals() is actually correct for some subtypes of BigdataValue")
    private List<Resolution> findResolutions(ServiceCallCreateParams params) {
        JoinGroupNode g = (JoinGroupNode)params.getServiceNode().getGraphPattern();
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>(g.args().size());
        for (BOp st : g.args()) {
            StatementPatternNode sn = (StatementPatternNode)st;
            if (sn.s().isConstant() && BD.SERVICE_PARAM.equals((Object)sn.s().getValue())) continue;
            resolutions.add(new Resolution(sn));
        }
        return resolutions;
    }

    private static class ResolutionContext {
        private final AbstractTripleStore tripleStore;
        private final LexiconRelation lexiconRelation;
        private final Map<String, Integer> languageFallbacks;
        private final List<IV> bestLabels = new ArrayList<IV>();
        private IBindingSet binding;
        private IV resolvedSubject;
        private IV resolvedLabelType;
        private IV rdfsLabelIv;

        ResolutionContext(AbstractTripleStore tripleStore, Map<String, Integer> languageFallbacks) {
            this.tripleStore = tripleStore;
            this.languageFallbacks = languageFallbacks;
            this.lexiconRelation = tripleStore.getLexiconRelation();
        }

        public void binding(IBindingSet binding) {
            this.binding = binding;
        }

        public void resolve(Resolution resolution) {
            this.resolvedSubject = this.resolveToIvOrError(resolution.subject(), "subject");
            this.resolvedLabelType = this.resolveToIvOrError(resolution.labelType(), "label type");
            if (this.resolvedSubject == null || this.resolvedLabelType == null) {
                return;
            }
            this.fillBestLabels();
            IV label = this.pickOrBuildBestLabel();
            if (label != null) {
                this.binding.set(resolution.target(), (IConstant)new Constant((Object)label));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillBestLabels() {
            try (IChunkedOrderedIterator lookup = this.tripleStore.getAccessPath(this.resolvedSubject, this.resolvedLabelType, null).iterator();){
                this.bestLabels.clear();
                int bestLabelRank = Integer.MAX_VALUE;
                while (lookup.hasNext()) {
                    Integer languageOrdinal;
                    Literal literal;
                    String language;
                    ISPO spo = (ISPO)lookup.next();
                    IV o = spo.o();
                    if (!o.isLiteral() || (language = (literal = (Literal)this.lexiconRelation.getTerm(o)).getLanguage()) == null || (languageOrdinal = this.languageFallbacks.get(language)) == null) continue;
                    if (languageOrdinal == bestLabelRank) {
                        this.bestLabels.add(o);
                    }
                    if (languageOrdinal >= bestLabelRank) continue;
                    bestLabelRank = languageOrdinal;
                    this.bestLabels.clear();
                    this.bestLabels.add(o);
                }
            }
        }

        private IV pickOrBuildBestLabel() {
            switch (this.bestLabels.size()) {
                case 1: {
                    return this.bestLabels.get(0);
                }
                case 0: {
                    return this.bestEffortLabel();
                }
            }
            return this.joinLabels();
        }

        private IV mock(Literal literal) {
            TermId mock = TermId.mockIV((VTE)VTE.LITERAL);
            mock.setValue((BigdataValue)this.lexiconRelation.getValueFactory().asValue(literal));
            return mock;
        }

        private IV resolveToIvOrError(IValueExpression expression, String nameOfExpression) {
            Object resolved = expression.get(this.binding);
            if (resolved == null) {
                return null;
            }
            try {
                return (IV)resolved;
            }
            catch (ClassCastException e) {
                throw new RuntimeException(String.format(Locale.ROOT, "Expected %s (%s) to be bound to an IV but it wasn't.", nameOfExpression, expression));
            }
        }

        public IV rdfsLabelIv() {
            if (this.rdfsLabelIv == null) {
                this.rdfsLabelIv = this.tripleStore.getVocabulary().get((Value)RDFS.LABEL);
            }
            return this.rdfsLabelIv;
        }

        private WikibaseUris uris() {
            return WikibaseUris.getURISystem();
        }

        private IV bestEffortLabel() {
            if (!this.rdfsLabelIv().equals(this.resolvedLabelType)) {
                return null;
            }
            BigdataValue value = this.lexiconRelation.getTerm(this.resolvedSubject);
            String bestEffortLabel = value.stringValue();
            if (bestEffortLabel.startsWith(this.uris().entity())) {
                bestEffortLabel = bestEffortLabel.substring(this.uris().entity().length());
            }
            return this.mock((Literal)new LiteralImpl(bestEffortLabel));
        }

        private IV joinLabels() {
            StringBuilder b = new StringBuilder();
            String language = null;
            boolean first = true;
            for (IV label : this.bestLabels) {
                Literal literal = (Literal)this.lexiconRelation.getTerm(label);
                if (!first) {
                    b.append(", ");
                } else {
                    first = false;
                }
                b.append(literal.stringValue());
                if (language != null) continue;
                language = literal.getLanguage();
            }
            return this.mock((Literal)new LiteralImpl(b.toString(), language));
        }
    }

    private static final class Resolution {
        private final IValueExpression subject;
        private final IValueExpression label;
        private final IVariable target;

        private Resolution(StatementPatternNode st) {
            this.subject = st.s().getValueExpression();
            this.label = st.p().getValueExpression();
            this.target = this.getVariableToBind(st);
        }

        public IValueExpression subject() {
            return this.subject;
        }

        public IValueExpression labelType() {
            return this.label;
        }

        public IVariable target() {
            return this.target;
        }

        private IVariable<IV> getVariableToBind(StatementPatternNode st) {
            try {
                return ((VarNode)st.o()).getValueExpression();
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Expected a variable in the object position to which to bind the language.");
            }
        }
    }

    private static class LabelServiceCall
    implements BigdataServiceCall {
        final ResolutionContext context;
        final List<Resolution> resolutions;

        LabelServiceCall(ResolutionContext context, List<Resolution> resolutions) {
            this.context = context;
            this.resolutions = resolutions;
        }

        public IServiceOptions getServiceOptions() {
            return SERVICE_OPTIONS;
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] bindingSets) throws Exception {
            return new Chunk(bindingSets);
        }

        private class Chunk
        implements ICloseableIterator<IBindingSet> {
            private final IBindingSet[] bindingSets;
            private boolean closed;
            private int i;

            Chunk(IBindingSet[] bindingSets) {
                this.bindingSets = bindingSets;
            }

            public boolean hasNext() {
                return !this.closed && this.i < this.bindingSets.length;
            }

            public IBindingSet next() {
                IBindingSet binding = this.bindingSets[this.i++];
                LabelServiceCall.this.context.binding(binding);
                for (Resolution resolution : LabelServiceCall.this.resolutions) {
                    LabelServiceCall.this.context.resolve(resolution);
                }
                return binding;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void close() {
                this.closed = true;
            }
        }
    }
}

