/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.ldf;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOFilter;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IElementFilter;
import java.util.HashSet;
import org.linkeddatafragments.datasource.AbstractRequestProcessorForTriplePatterns;
import org.linkeddatafragments.fragments.ILinkedDataFragment;
import org.linkeddatafragments.fragments.tpf.ITriplePatternElement;
import org.linkeddatafragments.fragments.tpf.ITriplePatternFragment;
import org.linkeddatafragments.fragments.tpf.ITriplePatternFragmentRequest;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.wikidata.query.rdf.blazegraph.ldf.BlazegraphBasedTPF;

public class BlazegraphBasedTPFRequestProcessor
extends AbstractRequestProcessorForTriplePatterns<BigdataValue, String, String> {
    private final AbstractTripleStore store;

    public BlazegraphBasedTPFRequestProcessor(AbstractTripleStore store) {
        this.store = store;
    }

    protected Worker getTPFSpecificWorker(ITriplePatternFragmentRequest<BigdataValue, String, String> req) throws IllegalArgumentException {
        return new Worker(req);
    }

    public static IV asIVorNull(ITriplePatternElement<BigdataValue, String, String> tpe) {
        return tpe.isVariable() ? null : ((BigdataValue)tpe.asConstantTerm()).getIV();
    }

    public static class VariablesBasedFilter
    extends SPOFilter<ISPO> {
        private static final long serialVersionUID = 6979067019748992496L;
        private final boolean checkS;
        private final boolean checkP;
        private final boolean checkO;

        public VariablesBasedFilter(ITriplePatternElement<BigdataValue, String, String> s, ITriplePatternElement<BigdataValue, String, String> p, ITriplePatternElement<BigdataValue, String, String> o) {
            String sVarName;
            boolean _checkS = false;
            boolean _checkP = false;
            boolean _checkO = false;
            if (s.isNamedVariable()) {
                sVarName = (String)s.asNamedVariable();
                if (p.isNamedVariable() && ((String)p.asNamedVariable()).equals(sVarName)) {
                    _checkS = true;
                    _checkP = true;
                }
                if (o.isNamedVariable() && ((String)o.asNamedVariable()).equals(sVarName)) {
                    _checkS = true;
                    _checkO = true;
                }
            }
            if (s.isAnonymousVariable()) {
                sVarName = (String)s.asAnonymousVariable();
                if (p.isAnonymousVariable() && ((String)p.asAnonymousVariable()).equals(sVarName)) {
                    _checkS = true;
                    _checkP = true;
                }
                if (o.isAnonymousVariable() && ((String)o.asAnonymousVariable()).equals(sVarName)) {
                    _checkS = true;
                    _checkO = true;
                }
            }
            if (p.isNamedVariable() && o.isNamedVariable() && ((String)p.asNamedVariable()).equals(o.asNamedVariable())) {
                _checkP = true;
                _checkO = true;
            }
            if (p.isAnonymousVariable() && o.isAnonymousVariable() && ((String)p.asAnonymousVariable()).equals(o.asAnonymousVariable())) {
                _checkP = true;
                _checkO = true;
            }
            this.checkS = _checkS;
            this.checkP = _checkP;
            this.checkO = _checkO;
        }

        public boolean isValid(Object obj) {
            if (!this.canAccept(obj)) {
                return true;
            }
            ISPO spo = (ISPO)obj;
            Resource s = spo.getSubject();
            URI p = spo.getPredicate();
            Value o = spo.getObject();
            if (this.checkS && this.checkP && !s.equals(p)) {
                return false;
            }
            if (this.checkS && this.checkO && !s.equals(o)) {
                return false;
            }
            return !this.checkP || !this.checkO || p.equals(o);
        }
    }

    protected class Worker
    extends AbstractRequestProcessorForTriplePatterns.Worker<BigdataValue, String, String> {
        public Worker(ITriplePatternFragmentRequest<BigdataValue, String, String> req) {
            super(req);
        }

        protected ILinkedDataFragment createFragment(ITriplePatternElement<BigdataValue, String, String> s, ITriplePatternElement<BigdataValue, String, String> p, ITriplePatternElement<BigdataValue, String, String> o, long offset, long limit) {
            int numOfValues = 0;
            if (!s.isVariable()) {
                ++numOfValues;
            }
            if (!p.isVariable()) {
                ++numOfValues;
            }
            if (!o.isVariable()) {
                ++numOfValues;
            }
            if (numOfValues > 0) {
                BigdataValue[] values = new BigdataValue[numOfValues];
                int i = 0;
                if (!s.isVariable()) {
                    values[i++] = (BigdataValue)s.asConstantTerm();
                }
                if (!p.isVariable()) {
                    values[i++] = (BigdataValue)p.asConstantTerm();
                }
                if (!o.isVariable()) {
                    values[i++] = (BigdataValue)o.asConstantTerm();
                }
                BlazegraphBasedTPFRequestProcessor.this.store.getLexiconRelation().addTerms(values, numOfValues, true);
                for (int j = 0; j < numOfValues; ++j) {
                    IV iv = values[j].getIV();
                    if (iv != null && (!(iv instanceof TermId) || ((TermId)iv).getTermId() != 0L)) continue;
                    return this.createEmptyTriplePatternFragment();
                }
            }
            VariablesBasedFilter filter = this.createFilterIfNeeded(s, p, o);
            IAccessPath ap = BlazegraphBasedTPFRequestProcessor.this.store.getSPORelation().getAccessPath(BlazegraphBasedTPFRequestProcessor.asIVorNull(s), BlazegraphBasedTPFRequestProcessor.asIVorNull(p), BlazegraphBasedTPFRequestProcessor.asIVorNull(o), null, (IElementFilter)filter);
            return this.createTriplePatternFragment((IAccessPath<ISPO>)ap, offset, limit);
        }

        public VariablesBasedFilter createFilterIfNeeded(ITriplePatternElement<BigdataValue, String, String> s, ITriplePatternElement<BigdataValue, String, String> p, ITriplePatternElement<BigdataValue, String, String> o) {
            if (!(s.isSpecificVariable() || p.isSpecificVariable() || o.isSpecificVariable())) {
                return null;
            }
            HashSet<Object> varNames = new HashSet<Object>();
            if (s.isNamedVariable()) {
                varNames.add(s.asNamedVariable());
            }
            if (p.isNamedVariable()) {
                if (varNames.contains(p.asNamedVariable())) {
                    return new VariablesBasedFilter(s, p, o);
                }
                varNames.add(p.asNamedVariable());
            }
            if (o.isNamedVariable() && varNames.contains(o.asNamedVariable())) {
                return new VariablesBasedFilter(s, p, o);
            }
            varNames.clear();
            if (s.isAnonymousVariable()) {
                varNames.add(s.asAnonymousVariable());
            }
            if (p.isAnonymousVariable()) {
                if (varNames.contains(p.asAnonymousVariable())) {
                    return new VariablesBasedFilter(s, p, o);
                }
                varNames.add(p.asAnonymousVariable());
            }
            if (o.isAnonymousVariable() && varNames.contains(o.asAnonymousVariable())) {
                return new VariablesBasedFilter(s, p, o);
            }
            return null;
        }

        protected ITriplePatternFragment createTriplePatternFragment(IAccessPath<ISPO> ap, long offset, long limit) {
            long count = ap.rangeCount(false);
            if (count == 0L) {
                return this.createEmptyTriplePatternFragment();
            }
            return new BlazegraphBasedTPF(ap, BlazegraphBasedTPFRequestProcessor.this.store, count, offset, limit, this.request.getFragmentURL(), this.request.getDatasetURL(), this.request.getPageNumber());
        }
    }
}

