/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public final class BigdataValuesHelper {
    private BigdataValuesHelper() {
    }

    public static IV makeIV(BigdataValueFactory vf, String value, URI type) {
        return BigdataValuesHelper.makeIV(vf, (Literal)vf.createLiteral(value, type));
    }

    public static IV makeIV(BigdataValueFactory vf, Literal literal) {
        return BigdataValuesHelper.makeIV(vf, (Value)literal, VTE.LITERAL);
    }

    public static IV makeIV(BigdataValueFactory vf, URI uriString) {
        return BigdataValuesHelper.makeIV(vf, (Value)vf.createURI(uriString.stringValue()), VTE.URI);
    }

    public static IV makeIV(BigdataValueFactory vf, Value value, VTE type) {
        BigdataValue l = vf.asValue(value);
        TermId mock = TermId.mockIV((VTE)type);
        mock.setValue(l);
        l.setIV((IV)mock);
        return mock;
    }

    public static IV makeIV(BigdataValueFactory vf, String value) {
        return BigdataValuesHelper.makeIV(vf, (Literal)vf.createLiteral(value));
    }

    public static IConstant makeConstant(BigdataValueFactory vf, String value) {
        return new Constant((Object)BigdataValuesHelper.makeIV(vf, value));
    }

    public static IConstant makeConstant(BigdataValueFactory vf, URI value) {
        return new Constant((Object)BigdataValuesHelper.makeIV(vf, value));
    }

    public static IConstant makeConstant(BigdataValueFactory vf, String value, URI type) {
        return new Constant((Object)BigdataValuesHelper.makeIV(vf, value, type));
    }

    @SuppressFBWarnings(value={"UP_UNUSED_PARAMETER"}, justification="Don't need BigdataValueFactory, but leave it to have uniform API")
    public static IConstant makeConstant(BigdataValueFactory vf, int value) {
        return new Constant((Object)new XSDNumericIV(value));
    }

    @SuppressFBWarnings(value={"UP_UNUSED_PARAMETER"}, justification="Don't need BigdataValueFactory, but leave it to have uniform API")
    public static IConstant makeConstant(BigdataValueFactory vf, double value) {
        return new Constant((Object)new XSDNumericIV(value));
    }

    public static IVariable makeVariable(String varName) {
        return Var.var((String)varName);
    }
}

