/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph;

import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.graph.impl.bd.GASService;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.DateBOp;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sail.webapp.BigdataRDFServletContextListener;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactoryBase;
import com.bigdata.rdf.sparql.ast.eval.SampleServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.SliceServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.ValuesServiceFactory;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceFactoryImpl;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceOptions;
import com.bigdata.rdf.sparql.ast.service.SPARQLVersion;
import com.bigdata.rdf.sparql.ast.service.ServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.store.BDS;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.blazegraph.categories.CategoriesStoredQuery;
import org.wikidata.query.rdf.blazegraph.constraints.CoordinatePartBOp;
import org.wikidata.query.rdf.blazegraph.constraints.DecodeUriBOp;
import org.wikidata.query.rdf.blazegraph.constraints.WikibaseCornerBOp;
import org.wikidata.query.rdf.blazegraph.constraints.WikibaseDateBOp;
import org.wikidata.query.rdf.blazegraph.constraints.WikibaseDistanceBOp;
import org.wikidata.query.rdf.blazegraph.constraints.WikibaseNowBOp;
import org.wikidata.query.rdf.blazegraph.geo.GeoService;
import org.wikidata.query.rdf.blazegraph.label.LabelService;
import org.wikidata.query.rdf.blazegraph.mwapi.MWApiServiceFactory;
import org.wikidata.query.rdf.common.uri.WikibaseUris;

public class WikibaseContextListener
extends BigdataRDFServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(WikibaseContextListener.class);
    public static final String WHITELIST_DEFAULT = "whitelist.txt";
    public static final String WHITELIST = System.getProperty("wikibaseServiceWhitelist", "whitelist.txt");

    public static void initializeServices() {
        ServiceRegistry reg = ServiceRegistry.getInstance();
        reg.setWhitelistEnabled(true);
        LabelService.register();
        GeoService.register();
        MWApiServiceFactory.register();
        CategoriesStoredQuery.register();
        reg.addWhitelistURL(GASService.Options.SERVICE_KEY.toString());
        reg.addWhitelistURL(ValuesServiceFactory.SERVICE_KEY.toString());
        reg.addWhitelistURL(BDS.SEARCH_IN_SEARCH.toString());
        reg.addWhitelistURL(SliceServiceFactory.SERVICE_KEY.toString());
        reg.addWhitelistURL(SampleServiceFactory.SERVICE_KEY.toString());
        WikibaseContextListener.loadWhitelist(reg);
        reg.setDefaultServiceFactory(WikibaseContextListener.getDefaultServiceFactory());
        FunctionRegistry.remove((URI)FunctionRegistry.YEAR);
        FunctionRegistry.add((URI)FunctionRegistry.YEAR, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.YEAR));
        FunctionRegistry.remove((URI)FunctionRegistry.MONTH);
        FunctionRegistry.add((URI)FunctionRegistry.MONTH, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.MONTH));
        FunctionRegistry.remove((URI)FunctionRegistry.DAY);
        FunctionRegistry.add((URI)FunctionRegistry.DAY, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.DAY));
        FunctionRegistry.remove((URI)FunctionRegistry.HOURS);
        FunctionRegistry.add((URI)FunctionRegistry.HOURS, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.HOURS));
        FunctionRegistry.remove((URI)FunctionRegistry.MINUTES);
        FunctionRegistry.add((URI)FunctionRegistry.MINUTES, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.MINUTES));
        FunctionRegistry.remove((URI)FunctionRegistry.SECONDS);
        FunctionRegistry.add((URI)FunctionRegistry.SECONDS, (FunctionRegistry.Factory)WikibaseContextListener.getWikibaseDateBOpFactory(DateBOp.DateOp.SECONDS));
        FunctionRegistry.remove((URI)FunctionRegistry.NOW);
        FunctionRegistry.add((URI)FunctionRegistry.NOW, (FunctionRegistry.Factory)new FunctionRegistry.Factory(){

            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                if (args != null && args.length > 0) {
                    throw new IllegalArgumentException("no args for NOW()");
                }
                return new WikibaseNowBOp(globals);
            }
        });
        FunctionRegistry.add((URI)new URIImpl("http://www.opengis.net/def/geosparql/function/distance"), (FunctionRegistry.Factory)WikibaseContextListener.getDistanceBOPFactory());
        FunctionRegistry.add((URI)new URIImpl("http://www.opengis.net/def/geosparql/function/northEast"), (FunctionRegistry.Factory)WikibaseContextListener.getCornersBOPFactory(WikibaseCornerBOp.Corners.NE));
        FunctionRegistry.add((URI)new URIImpl("http://www.opengis.net/def/geosparql/function/southWest"), (FunctionRegistry.Factory)WikibaseContextListener.getCornersBOPFactory(WikibaseCornerBOp.Corners.SW));
        FunctionRegistry.add((URI)new URIImpl("http://www.opengis.net/def/geosparql/function/globe"), (FunctionRegistry.Factory)WikibaseContextListener.getCoordinatePartBOpFactory(CoordinatePartBOp.Parts.GLOBE));
        FunctionRegistry.add((URI)new URIImpl("http://www.opengis.net/def/geosparql/function/longitude"), (FunctionRegistry.Factory)WikibaseContextListener.getCoordinatePartBOpFactory(CoordinatePartBOp.Parts.LON));
        FunctionRegistry.add((URI)new URIImpl("http://www.opengis.net/def/geosparql/function/latitude"), (FunctionRegistry.Factory)WikibaseContextListener.getCoordinatePartBOpFactory(CoordinatePartBOp.Parts.LAT));
        FunctionRegistry.add((URI)new URIImpl("http://wikiba.se/ontology#decodeUri"), (FunctionRegistry.Factory)WikibaseContextListener.getDecodeUriBOpFactory());
        WikibaseContextListener.addPrefixes(WikibaseUris.getURISystem());
        log.info("Wikibase services initialized.");
    }

    private static ServiceFactory getDefaultServiceFactory() {
        RemoteServiceOptions options = new RemoteServiceOptions();
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11);
        options.setGET(true);
        options.setAcceptHeader(TupleQueryResultFormat.SPARQL.getDefaultMIMEType());
        return new RemoteServiceFactoryImpl(options);
    }

    private static void loadWhitelist(ServiceRegistry reg) {
        try {
            List<String> lines = Files.readAllLines(Paths.get(WHITELIST, new String[0]), StandardCharsets.UTF_8);
            for (String line : lines) {
                reg.addWhitelistURL(line);
            }
        }
        catch (FileNotFoundException e) {
            log.info("Whitelist file {} not found, ignoring.", (Object)WHITELIST);
        }
        catch (IOException e) {
            log.warn("Failed reading from whitelist file");
        }
    }

    private static void addPrefixes(WikibaseUris uris) {
        Map defaultDecls = PrefixDeclProcessor.defaultDecls;
        for (WikibaseUris.PropertyType p : WikibaseUris.PropertyType.values()) {
            defaultDecls.put(p.prefix(), uris.property(p));
        }
        defaultDecls.put("wikibase", "http://wikiba.se/ontology#");
        defaultDecls.put("wd", uris.entity());
        defaultDecls.put("wds", uris.statement());
        defaultDecls.put("wdv", uris.value());
        defaultDecls.put("wdref", uris.reference());
        defaultDecls.put("wdata", uris.entityData());
        defaultDecls.put("schema", "http://schema.org/");
        defaultDecls.put("prov", "http://www.w3.org/ns/prov#");
        defaultDecls.put("skos", "http://www.w3.org/2004/02/skos/core#");
        defaultDecls.put("owl", "http://www.w3.org/2002/07/owl#");
        defaultDecls.put("geo", "http://www.opengis.net/ont/geosparql#");
        defaultDecls.put("geof", "http://www.opengis.net/def/geosparql/function/");
        defaultDecls.put("mediawiki", "https://www.mediawiki.org/ontology#");
        defaultDecls.put("mwapi", "https://www.mediawiki.org/ontology#API/");
        defaultDecls.put("gas", "http://www.bigdata.com/rdf/gas#");
    }

    public void contextInitialized(ServletContextEvent e) {
        super.contextInitialized(e);
        WikibaseContextListener.initializeServices();
    }

    private static FunctionRegistry.Factory getWikibaseDateBOpFactory(final DateBOp.DateOp dateop) {
        return new FunctionRegistry.Factory(){

            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs((ValueExpressionNode[])args, (Class[])new Class[]{ValueExpressionNode.class});
                IValueExpression left = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[0]);
                return new WikibaseDateBOp((IValueExpression<? extends IV>)left, dateop, globals);
            }
        };
    }

    private static FunctionRegistry.Factory getDistanceBOPFactory() {
        return new FunctionRegistry.Factory(){

            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs((ValueExpressionNode[])args, (Class[])new Class[]{ValueExpressionNode.class, ValueExpressionNode.class});
                IValueExpression left = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[0]);
                IValueExpression right = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[1]);
                return new WikibaseDistanceBOp((IValueExpression<? extends IV>)left, (IValueExpression<? extends IV>)right, globals);
            }
        };
    }

    private static FunctionRegistry.Factory getCornersBOPFactory(WikibaseCornerBOp.Corners corner) {
        return (context, globals, scalarValues, args) -> {
            FunctionRegistry.checkArgs((ValueExpressionNode[])args, (Class[])new Class[]{ValueExpressionNode.class, ValueExpressionNode.class});
            IValueExpression left = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[0]);
            IValueExpression right = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[1]);
            return new WikibaseCornerBOp((IValueExpression<? extends IV>)left, (IValueExpression<? extends IV>)right, corner, globals);
        };
    }

    private static FunctionRegistry.Factory getDecodeUriBOpFactory() {
        return (context, globals, scalarValues, args) -> {
            FunctionRegistry.checkArgs((ValueExpressionNode[])args, (Class[])new Class[]{ValueExpressionNode.class});
            IValueExpression ve = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[0]);
            return new DecodeUriBOp((IValueExpression<? extends IV>)ve, globals);
        };
    }

    private static FunctionRegistry.Factory getCoordinatePartBOpFactory(CoordinatePartBOp.Parts part) {
        return (context, globals, scalarValues, args) -> {
            FunctionRegistry.checkArgs((ValueExpressionNode[])args, (Class[])new Class[]{ValueExpressionNode.class});
            IValueExpression ve = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[0]);
            return new CoordinatePartBOp((IValueExpression<? extends IV>)ve, part, globals);
        };
    }

    private static final class DisableRemotesServiceFactory
    extends AbstractServiceFactoryBase {
        private static final IServiceOptions OPTIONS = new RemoteServiceOptions();

        private DisableRemotesServiceFactory() {
        }

        public IServiceOptions getServiceOptions() {
            return OPTIONS;
        }

        public ServiceCall<?> create(ServiceCallCreateParams params) {
            throw new IllegalArgumentException("Service call not allowed: " + params.getServiceURI());
        }
    }
}

