/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.gis.CoordinateDD;
import com.bigdata.rdf.internal.gis.ICoordinate;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import org.wikidata.query.rdf.common.WikibasePoint;

public class WikibaseDistanceBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 2909300288279424402L;
    public static final double SMALL_DISTANCE = 1.0E-5;

    public WikibaseDistanceBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length < 2 || args[0] == null || args[1] == null) {
            throw new IllegalArgumentException();
        }
    }

    public WikibaseDistanceBOp(IValueExpression<? extends IV> left, IValueExpression<? extends IV> right, GlobalAnnotations globals) {
        this(new BOp[]{left, right}, WikibaseDistanceBOp.anns((GlobalAnnotations)globals, (NV[])new NV[0]));
    }

    public WikibaseDistanceBOp(WikibaseDistanceBOp op) {
        super((IVValueExpression)op);
    }

    public IV get(IBindingSet bindingSet) {
        CoordinateDD rightPoint;
        IV left = this.getAndCheckLiteral(0, bindingSet);
        IV right = this.getAndCheckLiteral(1, bindingSet);
        CoordinateDD leftPoint = this.getCoordinateFromIV(left);
        double distance = leftPoint.equals(rightPoint = this.getCoordinateFromIV(right)) || this.veryClose(leftPoint, rightPoint) ? 0.0 : leftPoint.distance((ICoordinate)rightPoint, ICoordinate.UNITS.Kilometers);
        BigdataLiteral dist = this.getValueFactory().createLiteral(distance);
        return super.asIV((BigdataValue)dist, bindingSet);
    }

    protected boolean veryClose(CoordinateDD p1, CoordinateDD p2) {
        double dLon = p1.eastWest - p2.eastWest;
        double dLat = p1.northSouth - p2.northSouth;
        return Math.abs(dLon) < 1.0E-5 && Math.abs(dLat) < 1.0E-5;
    }

    @SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"}, justification="Converting to SPARQL exception")
    protected CoordinateDD getCoordinateFromIV(IV iv) {
        WikibasePoint point = new WikibasePoint(WikibaseDistanceBOp.asLiteral((IV)iv).stringValue());
        try {
            return new CoordinateDD(Double.parseDouble(point.getLatitude()), Double.parseDouble(point.getLongitude()));
        }
        catch (IllegalArgumentException e) {
            throw new SparqlTypeErrorException();
        }
    }

    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.ALWAYS;
    }
}

