/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.geo;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.service.geospatial.GeoSpatial;
import cutthecrap.utils.striterators.ICloseableIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.wikidata.query.rdf.blazegraph.BigdataValuesHelper;
import org.wikidata.query.rdf.blazegraph.geo.GeoService;
import org.wikidata.query.rdf.blazegraph.geo.GeoUtils;
import org.wikidata.query.rdf.common.WikibasePoint;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"}, justification="This should probably be fixed at some point")
public class GeoBoxService
extends GeoService {
    public static final URI SERVICE_KEY = new URIImpl("http://wikiba.se/ontology#box");
    public static final URI NE_PARAM = new URIImpl("http://wikiba.se/ontology#cornerNorthEast");
    public static final URI SW_PARAM = new URIImpl("http://wikiba.se/ontology#cornerSouthWest");
    public static final URI EAST_PARAM = new URIImpl("http://wikiba.se/ontology#cornerEast");
    public static final URI WEST_PARAM = new URIImpl("http://wikiba.se/ontology#cornerWest");
    public static final String VAR_ANNOTATION = GeoBoxService.class.getName() + ".var";
    public static final URI WRAP_PARAM = new URIImpl("http://wikiba.se/ontology#cornerWrap");
    public static final URI WKT_TYPE_URI = new URIImpl("http://www.opengis.net/ont/geosparql#wktLiteral");

    @Override
    protected JoinGroupNode buildServiceNode(ServiceCallCreateParams params, ServiceParams serviceParams) {
        AbstractTripleStore store = params.getTripleStore();
        Vocabulary voc = store.getVocabulary();
        BigdataValueFactory vf = store.getValueFactory();
        StatementPatternNode pattern = this.getPatternNode(params);
        TermNode searchVar = pattern.s();
        TermNode predicate = pattern.p();
        TermNode locationVar = pattern.o();
        JoinGroupNode newGroup = new JoinGroupNode();
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SEARCH)), (TermNode)new DummyConstantNode((BigdataValue)vf.createLiteral(GeoSpatial.GeoFunction.IN_RECTANGLE.toString()))));
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.PREDICATE)), predicate));
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SEARCH_DATATYPE)), (TermNode)new ConstantNode(voc.getConstant((Value)new URIImpl("http://www.opengis.net/ont/geosparql#wktLiteral")))));
        if (serviceParams.contains(NE_PARAM)) {
            newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST)), this.getParam(serviceParams, NE_PARAM)));
            newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST)), this.getParam(serviceParams, SW_PARAM)));
        } else if (serviceParams.contains(EAST_PARAM)) {
            TermNode east = this.getParam(serviceParams, EAST_PARAM);
            TermNode west = this.getParam(serviceParams, WEST_PARAM);
            if (east instanceof ConstantNode && west instanceof ConstantNode) {
                TermNode sw;
                TermNode ne;
                WikibasePoint westWP;
                WikibasePoint eastWP = GeoUtils.pointFromIV(((ConstantNode)east).getValue().getIV());
                GeoUtils.Box box = new GeoUtils.Box(eastWP, westWP = GeoUtils.pointFromIV(((ConstantNode)west).getValue().getIV()));
                if (box.switched()) {
                    ne = new DummyConstantNode((BigdataValue)vf.asValue((Literal)vf.createLiteral(box.northEast().toString(), (URI)new URIImpl("http://www.opengis.net/ont/geosparql#wktLiteral"))));
                    sw = new DummyConstantNode((BigdataValue)vf.asValue((Literal)vf.createLiteral(box.southWest().toString(), (URI)new URIImpl("http://www.opengis.net/ont/geosparql#wktLiteral"))));
                } else {
                    ne = east;
                    sw = west;
                }
                newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST)), ne));
                newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST)), sw));
            } else {
                serviceParams.add(WRAP_PARAM, (TermNode)VarNode.freshVarNode());
                newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST)), this.getSubstituteVar(east)));
                newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST)), this.getSubstituteVar(west)));
            }
        } else {
            throw new IllegalArgumentException("Box corner parameters are required");
        }
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.LOCATION_VALUE)), locationVar));
        newGroup.addArg((BOp)new StatementPatternNode(searchVar, (TermNode)new DummyConstantNode((BigdataValue)vf.asValue(GeoSpatial.COORD_SYSTEM)), this.getGlobeNode(vf, serviceParams)));
        return newGroup;
    }

    private TermNode getSubstituteVar(TermNode term) {
        if (term.isVariable() && ((IVariable)term.getValueExpression()).isAnonymous()) {
            throw new IllegalArgumentException("Anonymous vars not supported as box corners");
        }
        VarNode newnode = VarNode.freshVarNode();
        term.setProperty(VAR_ANNOTATION, (Object)newnode);
        return newnode;
    }

    @Override
    public BigdataServiceCall create(ServiceCallCreateParams params, ServiceParams serviceParams) {
        BigdataServiceCall parentCall = super.create(params, serviceParams);
        if (serviceParams.contains(WRAP_PARAM)) {
            return new GeoBoxServiceCall(parentCall, this.getParam(serviceParams, EAST_PARAM), this.getParam(serviceParams, WEST_PARAM), params.getTripleStore());
        }
        return parentCall;
    }

    private static class GeoBoxServiceCall
    implements BigdataServiceCall {
        private final BigdataServiceCall wrappedCall;
        private final TermNode east;
        private final TermNode west;
        private final BigdataValueFactory vf;

        GeoBoxServiceCall(BigdataServiceCall wrappedCall, TermNode east, TermNode west, AbstractTripleStore kb) {
            this.wrappedCall = wrappedCall;
            this.east = east;
            this.west = west;
            this.vf = kb.getValueFactory();
        }

        public IServiceOptions getServiceOptions() {
            return this.wrappedCall.getServiceOptions();
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] bindingSets) throws Exception {
            for (IBindingSet bs : bindingSets) {
                this.updateBindingSet(bs);
            }
            return this.wrappedCall.call((Object[])bindingSets);
        }

        private IVariable<IV> getAssociatedVariable(TermNode term) {
            VarNode node = (VarNode)term.getProperty(VAR_ANNOTATION);
            return node.getValueExpression();
        }

        private void updateBindingSet(IBindingSet bs) {
            IV eastIV = (IV)this.east.getValueExpression().get(bs);
            IV westIV = (IV)this.west.getValueExpression().get(bs);
            GeoUtils.Box box = new GeoUtils.Box(GeoUtils.pointFromIV(eastIV), GeoUtils.pointFromIV(westIV));
            bs.set(this.getAssociatedVariable(this.east), this.createConstant(box.northEast()));
            bs.set(this.getAssociatedVariable(this.west), this.createConstant(box.southWest()));
        }

        private IConstant createConstant(WikibasePoint wp) {
            return BigdataValuesHelper.makeConstant(this.vf, wp.toString(), WKT_TYPE_URI);
        }
    }
}

