/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.ldf;

import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.relation.accesspath.IAccessPath;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import java.io.Closeable;
import java.util.Iterator;
import org.linkeddatafragments.fragments.tpf.TriplePatternFragmentBase;
import org.wikidata.query.rdf.blazegraph.ldf.BigdataStatementToJenaStatementMapper;

public class BlazegraphBasedTPF
extends TriplePatternFragmentBase {
    private final MyStmtIterator myStmtIt;

    public BlazegraphBasedTPF(IAccessPath<ISPO> ap, AbstractTripleStore store, long count, long offset, long limit, String fragmentURL, String datasetURL, long pageNumber) {
        this(ap == null ? null : store.asStatementIterator(ap.iterator(offset, limit, 0)), count, fragmentURL, datasetURL, pageNumber, count < offset + limit);
    }

    protected BlazegraphBasedTPF(BigdataStatementIterator blzgStmtIt, long totalSize, String fragmentURL, String datasetURL, long pageNumber, boolean isLastPage) {
        super(totalSize, fragmentURL, datasetURL, pageNumber, isLastPage);
        this.myStmtIt = blzgStmtIt != null ? new MyStmtIterator(blzgStmtIt) : null;
    }

    protected StmtIterator getNonEmptyStmtIterator() {
        if (this.myStmtIt == null) {
            throw new IllegalStateException();
        }
        if (!this.myStmtIt.hasNext()) {
            throw new IllegalStateException();
        }
        return this.myStmtIt;
    }

    public void close() {
        this.myStmtIt.close();
    }

    public static class MyStmtIterator
    extends Map1Iterator<BigdataStatement, Statement>
    implements StmtIterator,
    Closeable {
        private final BigdataStatementIterator blzgStmtIt;
        private boolean closed;

        public MyStmtIterator(BigdataStatementIterator blzgStmtIt) {
            super((Map1)BigdataStatementToJenaStatementMapper.getInstance(), (Iterator)blzgStmtIt);
            this.blzgStmtIt = blzgStmtIt;
        }

        public Statement nextStatement() {
            return (Statement)this.next();
        }

        public boolean hasNext() {
            if (this.closed) {
                return false;
            }
            if (!this.blzgStmtIt.hasNext()) {
                this.close();
                return false;
            }
            return true;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.blzgStmtIt.close();
            super.close();
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

