/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.mwapi;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.MockIVReturningServiceCall;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wikidata.query.rdf.blazegraph.BigdataValuesHelper;
import org.wikidata.query.rdf.blazegraph.mwapi.ApiTemplate;
import org.wikidata.query.rdf.blazegraph.mwapi.MWApiServiceFactory;
import org.xml.sax.SAXException;

@SuppressFBWarnings(value={"DMC_DUBIOUS_MAP_COLLECTION"}, justification="while inputVars could be implemented as a list, the maps makes semantic sense.")
public class MWApiServiceCall
implements MockIVReturningServiceCall,
BigdataServiceCall {
    private static final Logger log = LoggerFactory.getLogger(MWApiServiceCall.class);
    private static final String TIMEOUT_PROPERTY = MWApiServiceCall.class.getName() + ".timeout";
    private static final String TIMEOUT_MILLIS = "5000";
    private final ApiTemplate template;
    private final Map<String, IVariableOrConstant> inputVars;
    private final List<ApiTemplate.OutputVariable> outputVars;
    private final HttpClient client;
    private final LexiconRelation lexiconRelation;
    private final String endpoint;
    private final int requestTimeout;
    private final String MAX_CONTINUE_CONFIG = MWApiServiceCall.class.getName() + ".maxContinue";
    private final int maxContinue;
    private final ThreadLocal<DocumentBuilder> docBuilder;
    private final ThreadLocal<XPath> xpath;

    MWApiServiceCall(ApiTemplate template, String endpoint, Map<String, IVariableOrConstant> inputVars, List<ApiTemplate.OutputVariable> outputVars, HttpClient client, LexiconRelation lexiconRelation) throws MalformedURLException {
        this.template = template;
        this.endpoint = new URL("https", endpoint, "/w/api.php").toExternalForm();
        this.inputVars = inputVars;
        this.outputVars = outputVars;
        this.client = client;
        this.lexiconRelation = lexiconRelation;
        this.requestTimeout = Integer.parseInt(System.getProperty(TIMEOUT_PROPERTY, TIMEOUT_MILLIS));
        this.maxContinue = Integer.parseInt(System.getProperty(this.MAX_CONTINUE_CONFIG, "10000"));
        this.docBuilder = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                try {
                    dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    return dbf.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    log.error("Could not configure parser: {}", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
        };
        this.xpath = new ThreadLocal<XPath>(){

            @Override
            protected XPath initialValue() {
                return XPathFactory.newInstance().newXPath();
            }
        };
    }

    public IServiceOptions getServiceOptions() {
        return MWApiServiceFactory.SERVICE_OPTIONS;
    }

    public ICloseableIterator<IBindingSet> call(IBindingSet[] bindingSets) throws Exception {
        return new MultiSearchIterator(bindingSets);
    }

    public Map<String, String> getRequestParams(IBindingSet binding) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(this.template.getFixedParams());
        for (Map.Entry<String, IVariableOrConstant> term : this.inputVars.entrySet()) {
            String value = null;
            IV boundValue = null;
            if (term.getValue() != null) {
                boundValue = (IV)term.getValue().get(binding);
            }
            if (boundValue == null) {
                value = this.template.getInputDefault(term.getKey());
                if (value != null && value.isEmpty()) {
                    continue;
                }
            } else {
                value = boundValue.stringValue();
            }
            if (value == null) {
                if (!this.template.isRequiredParameter(term.getKey())) continue;
                throw new IllegalArgumentException("Could not find binding for parameter " + term.getKey());
            }
            params.put(term.getKey(), value);
        }
        return params;
    }

    private Request getHttpRequest(IBindingSet binding) {
        Request request = this.client.newRequest(this.endpoint);
        request.method(HttpMethod.GET);
        request.param("format", "xml");
        this.getRequestParams(binding).forEach((key, value) -> request.param(key, value));
        return request;
    }

    public List<IVariable<IV>> getMockVariables() {
        LinkedList<IVariable<IV>> externalVars = new LinkedList<IVariable<IV>>();
        for (ApiTemplate.OutputVariable v : this.outputVars) {
            externalVars.add((IVariable<IV>)v.getVar());
        }
        return externalVars;
    }

    @Nullable
    public ImmutableMap<String, String> parseContinue(Document doc, XPath xpath) {
        try {
            XPathExpression itemsXPath = xpath.compile("//api/continue");
            Node continueNode = (Node)itemsXPath.evaluate(doc, XPathConstants.NODE);
            if (continueNode == null) {
                return null;
            }
            NamedNodeMap continueAttrs = continueNode.getAttributes();
            if (continueAttrs.getLength() == 0) {
                return null;
            }
            ImmutableMap.Builder continueVars = new ImmutableMap.Builder();
            for (int i = 0; i < continueAttrs.getLength(); ++i) {
                Node node = continueAttrs.item(i);
                continueVars = continueVars.put((Object)node.getNodeName(), (Object)node.getNodeValue());
            }
            return continueVars.build();
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    public ResultWithContinue parseResponse(InputStream responseStream, IBindingSet binding) throws SAXException, IOException, XPathExpressionException {
        if (this.outputVars.isEmpty()) {
            return null;
        }
        Document doc = this.docBuilder.get().parse(responseStream);
        XPath path = this.xpath.get();
        ImmutableMap<String, String> searchContinue = this.parseContinue(doc, path);
        XPathExpression itemsXPath = path.compile(this.template.getItemsPath());
        NodeList nodes = (NodeList)itemsXPath.evaluate(doc, XPathConstants.NODESET);
        if (nodes.getLength() == 0) {
            return null;
        }
        IBindingSet[] results = new IBindingSet[nodes.getLength()];
        HashMap<ApiTemplate.OutputVariable, XPathExpression> compiledVars = new HashMap<ApiTemplate.OutputVariable, XPathExpression>();
        for (ApiTemplate.OutputVariable var : this.outputVars) {
            compiledVars.put(var, this.xpath.get().compile(var.getPath()));
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            results[i] = binding.copy(null);
            for (Map.Entry var : compiledVars.entrySet()) {
                IConstant constant;
                if (((ApiTemplate.OutputVariable)var.getKey()).isOrdinal()) {
                    constant = BigdataValuesHelper.makeConstant(this.lexiconRelation.getValueFactory(), i);
                    results[i].set(((ApiTemplate.OutputVariable)var.getKey()).getVar(), constant);
                    continue;
                }
                Node value = (Node)((XPathExpression)var.getValue()).evaluate(node, XPathConstants.NODE);
                if (value == null || value.getNodeValue() == null) continue;
                constant = ((ApiTemplate.OutputVariable)var.getKey()).isURI() ? BigdataValuesHelper.makeConstant(this.lexiconRelation.getValueFactory(), ((ApiTemplate.OutputVariable)var.getKey()).getURI(value.getNodeValue())) : BigdataValuesHelper.makeConstant(this.lexiconRelation.getValueFactory(), value.getNodeValue());
                results[i].set(((ApiTemplate.OutputVariable)var.getKey()).getVar(), constant);
            }
        }
        return new ResultWithContinue(results, searchContinue);
    }

    public static class ResultWithContinue {
        private final ImmutableMap<String, String> searchContinue;
        private final UnmodifiableIterator<IBindingSet> resultIterator;

        ResultWithContinue(IBindingSet[] searchResult, ImmutableMap<String, String> searchContinue) {
            this.searchContinue = searchContinue;
            this.resultIterator = Iterators.forArray((Object[])searchResult);
        }

        public Iterator<IBindingSet> getResultIterator() {
            return this.resultIterator;
        }

        public Map<String, String> getContinue() {
            return this.searchContinue;
        }
    }

    private class ContinueIterator
    implements ICloseableIterator<IBindingSet> {
        private boolean closed;
        private ResultWithContinue lastResult;
        private IBindingSet bindings;
        private int recordsCount;

        ContinueIterator(IBindingSet binding) {
            this.bindings = binding;
            this.lastResult = this.doSearchRequest();
        }

        private ResultWithContinue doSearchRequest() {
            Response response;
            Request req = MWApiServiceCall.this.getHttpRequest(this.bindings);
            if (this.lastResult != null && this.lastResult.getContinue() != null) {
                this.lastResult.getContinue().forEach((key, value) -> req.param(key, value));
            }
            log.debug("MWAPI REQUEST: {}", (Object)req.getQuery());
            InputStreamResponseListener listener = new InputStreamResponseListener();
            try {
                req.send((Response.CompleteListener)listener);
                response = listener.get((long)MWApiServiceCall.this.requestTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException("MWAPI request failed", e);
            }
            if (response.getStatus() != 200) {
                throw new RuntimeException("Bad response status: " + response.getStatus());
            }
            try {
                return MWApiServiceCall.this.parseResponse(listener.getInputStream(), this.bindings);
            }
            catch (IOException | XPathExpressionException | SAXException e) {
                throw new RuntimeException("Failed to parse response", e);
            }
        }

        public boolean hasNext() {
            if (this.closed || this.lastResult == null) {
                return false;
            }
            return this.lastResult.getResultIterator().hasNext() || this.lastResult.searchContinue != null;
        }

        public IBindingSet next() {
            if (this.recordsCount >= MWApiServiceCall.this.maxContinue) {
                this.close();
            }
            if (this.closed || this.lastResult == null) {
                return null;
            }
            if (this.lastResult.getResultIterator().hasNext()) {
                ++this.recordsCount;
                return this.lastResult.getResultIterator().next();
            }
            if (this.lastResult.getContinue() != null) {
                this.lastResult = this.doSearchRequest();
            }
            if (this.closed || this.lastResult == null) {
                return null;
            }
            if (this.lastResult.getResultIterator().hasNext()) {
                ++this.recordsCount;
                return this.lastResult.getResultIterator().next();
            }
            return null;
        }

        public void close() {
            this.closed = true;
        }
    }

    private class MultiSearchIterator
    implements ICloseableIterator<IBindingSet> {
        private final IBindingSet[] bindingSets;
        private boolean closed;
        private int i;
        private Iterator<IBindingSet> searchResult;

        MultiSearchIterator(IBindingSet[] bindingSets) {
            this.bindingSets = bindingSets;
            this.searchResult = this.doNextSearch();
        }

        public boolean hasNext() {
            if (this.closed) {
                return false;
            }
            if (this.searchResult == null) {
                return false;
            }
            if (this.searchResult.hasNext()) {
                return true;
            }
            this.searchResult = this.doNextSearch();
            if (this.searchResult == null) {
                return false;
            }
            return this.searchResult.hasNext();
        }

        private Iterator<IBindingSet> doNextSearch() {
            IBindingSet binding;
            ContinueIterator result;
            if (this.closed || this.bindingSets == null || this.i >= this.bindingSets.length) {
                this.searchResult = null;
                return null;
            }
            while (!(result = new ContinueIterator(binding = this.bindingSets[this.i++])).hasNext() && this.i < this.bindingSets.length) {
            }
            if (result.hasNext()) {
                return result;
            }
            return null;
        }

        public IBindingSet next() {
            if (this.closed || this.searchResult == null) {
                return null;
            }
            if (this.searchResult.hasNext()) {
                return this.searchResult.next();
            }
            this.searchResult = this.doNextSearch();
            if (this.searchResult == null || !this.searchResult.hasNext()) {
                return null;
            }
            return this.searchResult.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.closed = true;
        }
    }
}

