/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.throttling;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.blazegraph.throttling.Bucketing;
import org.wikidata.query.rdf.blazegraph.throttling.ThrottlingState;

public class Throttler<B> {
    private static final Logger log = LoggerFactory.getLogger(Throttler.class);
    private final Bucketing<B> bucketing;
    private final Cache<B, ThrottlingState> state;
    private final Duration requestTimeThreshold;
    private final Callable<ThrottlingState> createThrottlingState;
    private final String enableThrottlingIfHeader;
    public final String alwaysThrottleParam;

    public Throttler(Duration requestTimeThreshold, Bucketing<B> bucketing, Callable<ThrottlingState> createThrottlingState, Cache<B, ThrottlingState> stateStore, String enableThrottlingIfHeader, String alwaysThrottleParam) {
        this.requestTimeThreshold = requestTimeThreshold;
        this.bucketing = bucketing;
        this.state = stateStore;
        this.createThrottlingState = createThrottlingState;
        this.enableThrottlingIfHeader = Strings.emptyToNull((String)enableThrottlingIfHeader);
        this.alwaysThrottleParam = Strings.emptyToNull((String)alwaysThrottleParam);
    }

    public long getStateSize() {
        return this.state.size();
    }

    public boolean isThrottled(HttpServletRequest request) {
        if (this.alwaysThrottle(request)) {
            return true;
        }
        if (this.shouldBypassThrottling(request)) {
            return false;
        }
        ThrottlingState throttlingState = (ThrottlingState)this.state.getIfPresent(this.bucketing.bucket(request));
        if (throttlingState == null) {
            return false;
        }
        return throttlingState.isThrottled();
    }

    private boolean alwaysThrottle(HttpServletRequest request) {
        if (this.alwaysThrottleParam == null) {
            return false;
        }
        return request.getParameter(this.alwaysThrottleParam) != null;
    }

    private boolean shouldBypassThrottling(HttpServletRequest request) {
        if (this.enableThrottlingIfHeader == null) {
            return false;
        }
        return request.getHeader(this.enableThrottlingIfHeader) == null;
    }

    public void success(HttpServletRequest request, Duration elapsed) {
        if (this.shouldBypassThrottling(request)) {
            return;
        }
        try {
            B bucket = this.bucketing.bucket(request);
            ThrottlingState throttlingState = elapsed.compareTo(this.requestTimeThreshold) > 0 ? (ThrottlingState)this.state.get(bucket, this.createThrottlingState) : (ThrottlingState)this.state.getIfPresent(bucket);
            if (throttlingState != null) {
                throttlingState.consumeTime(elapsed);
            }
        }
        catch (ExecutionException ee) {
            log.warn("Could not create throttling state", (Throwable)ee);
        }
    }

    public void failure(HttpServletRequest request, Duration elapsed) {
        if (this.shouldBypassThrottling(request)) {
            return;
        }
        try {
            ThrottlingState throttlingState = (ThrottlingState)this.state.get(this.bucketing.bucket(request), this.createThrottlingState);
            throttlingState.consumeError();
            throttlingState.consumeTime(elapsed);
        }
        catch (ExecutionException ee) {
            log.warn("Could not create throttling state", (Throwable)ee);
        }
    }

    public Duration getBackoffDelay(HttpServletRequest request) {
        ThrottlingState throttlingState = (ThrottlingState)this.state.getIfPresent(this.bucketing.bucket(request));
        if (throttlingState == null) {
            return Duration.of(0L, ChronoUnit.MILLIS);
        }
        return throttlingState.getBackoffDelay();
    }
}

