/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.throttling;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.isomorphism.util.TokenBuckets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.blazegraph.throttling.Throttler;
import org.wikidata.query.rdf.blazegraph.throttling.ThrottlingMXBean;
import org.wikidata.query.rdf.blazegraph.throttling.ThrottlingState;
import org.wikidata.query.rdf.blazegraph.throttling.UserAgentIpAddressBucketing;

public class ThrottlingFilter
implements Filter,
ThrottlingMXBean {
    private static final Logger log = LoggerFactory.getLogger(ThrottlingFilter.class);
    private boolean enabled;
    private Throttler<UserAgentIpAddressBucketing.Bucket> throttler;
    private final AtomicLong nbThrottledRequests = new AtomicLong();
    @Nullable
    private ObjectName objectName;

    public void init(FilterConfig filterConfig) throws ServletException {
        int requestDurationThresholdInMillis = this.loadIntParam("request-duration-threshold-in-millis", filterConfig, 0);
        int timeBucketCapacityInSeconds = this.loadIntParam("time-bucket-capacity-in-seconds", filterConfig, 120);
        int timeBucketRefillAmountInSeconds = this.loadIntParam("time-bucket-refill-amount-in-seconds", filterConfig, 60);
        int timeBucketRefillPeriodInMinutes = this.loadIntParam("time-bucket-refill-period-in-minutes", filterConfig, 1);
        int errorBucketCapacity = this.loadIntParam("error-bucket-capacity", filterConfig, 60);
        int errorBucketRefillAmount = this.loadIntParam("error-bucket-refill-amount", filterConfig, 30);
        int errorBucketRefillPeriodInMinutes = this.loadIntParam("error-bucket-refill-period-in-minutes", filterConfig, 1);
        int maxStateSize = this.loadIntParam("max-state-size", filterConfig, 10000);
        int stateExpirationInMinutes = this.loadIntParam("state-expiration-in-minutes", filterConfig, 15);
        String enableThrottlingIfHeader = this.loadStringParam("enable-throttling-if-header", filterConfig);
        String alwaysThrottleParam = this.loadStringParam("always-throttle-param", filterConfig, "throttleMe");
        this.enabled = this.loadBooleanParam("enabled", filterConfig, true);
        this.throttler = new Throttler<UserAgentIpAddressBucketing.Bucket>(Duration.of(requestDurationThresholdInMillis, ChronoUnit.MILLIS), new UserAgentIpAddressBucketing(), ThrottlingFilter.createThrottlingState(timeBucketCapacityInSeconds, timeBucketRefillAmountInSeconds, timeBucketRefillPeriodInMinutes, errorBucketCapacity, errorBucketRefillAmount, errorBucketRefillPeriodInMinutes), CacheBuilder.newBuilder().maximumSize((long)maxStateSize).expireAfterAccess((long)stateExpirationInMinutes, TimeUnit.MINUTES).build(), enableThrottlingIfHeader, alwaysThrottleParam);
        this.registerMBean(filterConfig.getFilterName());
    }

    private void registerMBean(String filterName) {
        try {
            ObjectName objectName = new ObjectName(ThrottlingFilter.class.getName(), "filterName", filterName);
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            platformMBeanServer.registerMBean(this, objectName);
            this.objectName = objectName;
            log.info("ThrottlingFilter MBean registered as {}.", (Object)objectName);
        }
        catch (MalformedObjectNameException e) {
            log.error("filter name {} is invalid as an MBean property.", (Object)filterName, (Object)e);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error("MBean for ThrottlingFilter has already been registered.", (Throwable)e);
        }
        catch (MBeanRegistrationException | NotCompliantMBeanException e) {
            log.error("Could not register MBean for ThrottlingFilter.", (Throwable)e);
        }
    }

    private int loadIntParam(String name, FilterConfig filterConfig, int defaultValue) {
        String result = this.loadStringParam(name, filterConfig);
        return result != null ? Integer.parseInt(result) : defaultValue;
    }

    private boolean loadBooleanParam(String name, FilterConfig filterConfig, boolean defaultValue) {
        String result = this.loadStringParam(name, filterConfig);
        return result != null ? Boolean.parseBoolean(result) : defaultValue;
    }

    private String loadStringParam(String name, FilterConfig filterConfig) {
        String sParam;
        String result = null;
        String fParam = filterConfig.getInitParameter(name);
        if (fParam != null) {
            result = fParam;
        }
        if ((sParam = System.getProperty("wdqs." + filterConfig.getFilterName() + "." + name)) != null) {
            result = sParam;
        }
        return result;
    }

    private String loadStringParam(String name, FilterConfig filterConfig, String defaultValue) {
        return (String)MoreObjects.firstNonNull((Object)this.loadStringParam(name, filterConfig), (Object)defaultValue);
    }

    public static Callable<ThrottlingState> createThrottlingState(int timeBucketCapacityInSeconds, int timeBucketRefillAmountInSeconds, int timeBucketRefillPeriodInMinutes, int errorBucketCapacity, int errorBucketRefillAmount, int errorBucketRefillPeriodInMinutes) {
        return () -> new ThrottlingState(TokenBuckets.builder().withCapacity(TimeUnit.MILLISECONDS.convert(timeBucketCapacityInSeconds, TimeUnit.SECONDS)).withFixedIntervalRefillStrategy(TimeUnit.MILLISECONDS.convert(timeBucketRefillAmountInSeconds, TimeUnit.SECONDS), (long)timeBucketRefillPeriodInMinutes, TimeUnit.MINUTES).build(), TokenBuckets.builder().withCapacity((long)errorBucketCapacity).withFixedIntervalRefillStrategy((long)errorBucketRefillAmount, (long)errorBucketRefillPeriodInMinutes, TimeUnit.MINUTES).build());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.throttler.isThrottled(httpRequest)) {
            log.info("A request is being throttled.");
            if (this.enabled) {
                this.nbThrottledRequests.incrementAndGet();
                this.notifyUser(httpResponse, this.throttler.getBackoffDelay(httpRequest));
                return;
            }
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            chain.doFilter(request, response);
            if (httpResponse.getStatus() < 400) {
                this.throttler.success(httpRequest, stopwatch.elapsed());
            } else {
                this.throttler.failure(httpRequest, stopwatch.elapsed());
            }
        }
        catch (IOException | ServletException e) {
            this.throttler.failure(httpRequest, stopwatch.elapsed());
            throw e;
        }
    }

    private void notifyUser(HttpServletResponse response, Duration backoffDelay) throws IOException {
        String retryAfter = Long.toString(backoffDelay.getSeconds());
        response.setHeader("Retry-After", retryAfter);
        response.sendError(429, String.format(Locale.ENGLISH, "Too Many Requests - Please retry in %s seconds.", retryAfter));
    }

    public void destroy() {
        if (this.objectName == null) {
            return;
        }
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            platformMBeanServer.unregisterMBean(this.objectName);
            log.info("ThrottlingFilter MBean {} unregistered.", (Object)this.objectName);
            this.objectName = null;
        }
        catch (InstanceNotFoundException e) {
            log.warn("MBean already unregistered.", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error("Could not unregister MBean.", (Throwable)e);
        }
    }

    @Override
    public long getStateSize() {
        return this.throttler.getStateSize();
    }

    @Override
    public long getNumberOfThrottledRequests() {
        return this.nbThrottledRequests.get();
    }
}

