/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.throttling;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.isomorphism.util.TokenBucket;

public final class ThrottlingState {
    private final TokenBucket timeBucket;
    private final TokenBucket errorsBucket;

    public ThrottlingState(TokenBucket timeBucket, TokenBucket errorsBucket) {
        this.timeBucket = timeBucket;
        this.errorsBucket = errorsBucket;
    }

    public synchronized boolean isThrottled() {
        return this.timeBucket.getNumTokens() == 0L || this.errorsBucket.getNumTokens() == 0L;
    }

    public synchronized Duration getBackoffDelay() {
        return Duration.of(Math.max(ThrottlingState.backoffDelayMillis(this.timeBucket), ThrottlingState.backoffDelayMillis(this.errorsBucket)), ChronoUnit.MILLIS);
    }

    public synchronized void consumeTime(Duration elapsed) {
        long tokenToConsume = Math.min(elapsed.toMillis(), this.timeBucket.getNumTokens());
        if (tokenToConsume > 0L) {
            this.timeBucket.consume(tokenToConsume);
        }
    }

    public synchronized void consumeError() {
        this.errorsBucket.tryConsume();
    }

    private static long backoffDelayMillis(TokenBucket bucket) {
        if (bucket.getNumTokens() > 0L) {
            return 0L;
        }
        return bucket.getDurationUntilNextRefill(TimeUnit.MILLISECONDS);
    }
}

