/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.throttling;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.wikidata.query.rdf.blazegraph.throttling.Bucketing;

public class UserAgentIpAddressBucketing
implements Bucketing<Bucket> {
    @Override
    public Bucket bucket(HttpServletRequest request) {
        return new Bucket(request.getRemoteAddr(), request.getHeader("User-Agent"));
    }

    public static final class Bucket {
        private final String remoteAddr;
        private final String userAgent;

        private Bucket(String remoteAddr, String userAgent) {
            this.remoteAddr = remoteAddr;
            this.userAgent = userAgent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket bucket = (Bucket)o;
            return Objects.equals(this.remoteAddr, bucket.remoteAddr) && Objects.equals(this.userAgent, bucket.userAgent);
        }

        public int hashCode() {
            return Objects.hash(this.remoteAddr, this.userAgent);
        }
    }
}

