/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph;

import com.bigdata.rdf.sail.webapp.client.DefaultHttpClientFactory;
import com.bigdata.rdf.sail.webapp.client.IHttpClientFactory;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;

public class ProxiedHttpConnectionFactory
implements IHttpClientFactory {
    private final DefaultHttpClientFactory defaultFactory = new DefaultHttpClientFactory();
    private static final String HTTP_PROXY = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_USER_AGENT = "http.userAgent";

    public HttpClient newInstance() {
        String userAgent;
        HttpClient client = this.defaultFactory.newInstance();
        if (System.getProperty(HTTP_PROXY) != null && System.getProperty(HTTP_PROXY_PORT) != null) {
            ProxyConfiguration proxyConfig = client.getProxyConfiguration();
            HttpProxy proxy = new HttpProxy(System.getProperty(HTTP_PROXY), Integer.parseInt(System.getProperty(HTTP_PROXY_PORT)));
            proxy.getExcludedAddresses().add("localhost");
            proxy.getExcludedAddresses().add("127.0.0.1");
            proxyConfig.getProxies().add(proxy);
        }
        if ((userAgent = System.getProperty(HTTP_USER_AGENT)) != null) {
            client.setUserAgentField(new HttpField(HttpHeader.USER_AGENT, userAgent));
        }
        return client;
    }
}

