/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.categories;

import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.sparql.ast.service.storedquery.SimpleStoredQueryService;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class CategoriesStoredQuery
extends SimpleStoredQueryService {
    public static final URI SERVICE_KEY = new URIImpl("https://www.mediawiki.org/ontology#categoryTree");
    public static final URI START_PARAM = new URIImpl("https://www.mediawiki.org/ontology#start");
    public static final URI DIRECTION_PARAM = new URIImpl("https://www.mediawiki.org/ontology#direction");
    public static final URI DEPTH_PARAM = new URIImpl("https://www.mediawiki.org/ontology#depth");
    public static final int MAX_DEPTH = 8;

    public static void register() {
        ServiceRegistry reg = ServiceRegistry.getInstance();
        reg.add(SERVICE_KEY, (ServiceFactory)new CategoriesStoredQuery());
        reg.addWhitelistURL(SERVICE_KEY.toString());
    }

    protected String getQuery(ServiceCallCreateParams createParams, ServiceParams serviceParams) {
        URI start = serviceParams.getAsURI(START_PARAM);
        String direction = serviceParams.getAsString(DIRECTION_PARAM, "Reverse");
        int depth = serviceParams.getAsInt(DEPTH_PARAM, Integer.valueOf(8));
        return "SELECT * WHERE {\nSERVICE gas:service {\n     gas:program gas:gasClass \"com.bigdata.rdf.graph.analytics.BFS\" .\n     gas:program gas:linkType mediawiki:isInCategory .\n   gas:program gas:traversalDirection \"" + direction + "\" .\n     gas:program gas:in <" + start.stringValue() + "> .\n     gas:program gas:out ?out .\n     gas:program gas:out1 ?depth .\n     gas:program gas:out2 ?predecessor .\n     gas:program gas:maxIterations " + depth + " .\n  }\n}";
    }
}

