/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.wikidata.query.rdf.blazegraph.geo.GeoUtils;
import org.wikidata.query.rdf.common.WikibasePoint;

public class CoordinatePartBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = -81134263515935773L;
    private static final String OP_ANNOTATION = (CoordinatePartBOp.class.getName() + ".op").intern();

    public CoordinatePartBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length < 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
    }

    public CoordinatePartBOp(IValueExpression<? extends IV> coord, Parts part, GlobalAnnotations globals) {
        this(new BOp[]{coord}, CoordinatePartBOp.anns((GlobalAnnotations)globals, (NV[])new NV[]{new NV(OP_ANNOTATION, (Object)part)}));
    }

    public CoordinatePartBOp(CoordinatePartBOp op) {
        super((IVValueExpression)op);
    }

    private Parts part() {
        return (Parts)((Object)this.getRequiredProperty(OP_ANNOTATION));
    }

    public IV get(IBindingSet bindingSet) {
        BigdataLiteral result;
        IV coord = this.getAndCheckLiteral(0, bindingSet);
        WikibasePoint point = GeoUtils.pointFromIV(coord);
        switch (this.part()) {
            case GLOBE: {
                String globe = point.getGlobe();
                if (globe == null) {
                    result = this.getValueFactory().createLiteral("");
                    break;
                }
                result = this.getValueFactory().createURI(point.getGlobe());
                break;
            }
            case LON: {
                result = this.getValueFactory().createLiteral(Double.parseDouble(point.getLongitude()));
                break;
            }
            case LAT: {
                result = this.getValueFactory().createLiteral(Double.parseDouble(point.getLatitude()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown part specified");
            }
        }
        return super.asIV((BigdataValue)result, bindingSet);
    }

    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.ALWAYS;
    }

    public static enum Parts {
        GLOBE,
        LAT,
        LON;

    }
}

