/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.constraints.DateBOp;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.math.BigInteger;
import java.util.Map;
import org.wikidata.query.rdf.common.WikibaseDate;

public class WikibaseDateBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 9136864442064392445L;
    private final DateBOp originalOp;

    public WikibaseDateBOp(IValueExpression<? extends IV> left, DateBOp.DateOp op, GlobalAnnotations globals) {
        this(new BOp[]{left}, WikibaseDateBOp.anns((GlobalAnnotations)globals, (NV[])new NV[]{new NV(DateBOp.Annotations.OP, (Object)op)}));
    }

    public WikibaseDateBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null || this.getProperty(DateBOp.Annotations.OP) == null) {
            throw new IllegalArgumentException();
        }
        this.originalOp = new DateBOp(args, anns);
    }

    public WikibaseDateBOp(WikibaseDateBOp op) {
        super((IVValueExpression)op);
        this.originalOp = new DateBOp(op.originalOp);
    }

    private WikibaseDate getWikibaseDate(IV iv) {
        if (iv instanceof LiteralExtensionIV) {
            return WikibaseDate.fromSecondsSinceEpoch((long)((LiteralExtensionIV)iv).getDelegate().longValue());
        }
        try {
            return WikibaseDate.fromString((String)iv.getValue().stringValue()).cleanWeirdStuff();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public IV get(IBindingSet bs) {
        IV left = (IV)this.left().get(bs);
        if (left == null) {
            throw new SparqlTypeErrorException.UnboundVarException();
        }
        if (left.isLiteral()) {
            BigdataLiteral bl = (BigdataLiteral)left.getValue();
            if (XSD.DATETIME.equals((Object)bl.getDatatype())) {
                WikibaseDate date = this.getWikibaseDate(left);
                if (date == null) {
                    throw new SparqlTypeErrorException();
                }
                switch (this.op()) {
                    case YEAR: {
                        return new XSDIntegerIV(BigInteger.valueOf(date.year()));
                    }
                    case MONTH: {
                        return new XSDIntegerIV(BigInteger.valueOf(date.month()));
                    }
                    case DAY: {
                        return new XSDIntegerIV(BigInteger.valueOf(date.day()));
                    }
                    case HOURS: {
                        return new XSDIntegerIV(BigInteger.valueOf(date.hour()));
                    }
                    case MINUTES: {
                        return new XSDIntegerIV(BigInteger.valueOf(date.minute()));
                    }
                    case SECONDS: {
                        return new XSDIntegerIV(BigInteger.valueOf(date.second()));
                    }
                }
                throw new UnsupportedOperationException();
            }
            return this.originalOp.get(bs);
        }
        throw new SparqlTypeErrorException();
    }

    public IValueExpression<? extends IV> left() {
        return this.get(0);
    }

    public DateBOp.DateOp op() {
        return (DateBOp.DateOp)this.getRequiredProperty(DateBOp.Annotations.OP);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.op());
        sb.append('(').append(this.left()).append(')');
        return sb.toString();
    }

    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }
}

