/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.label;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BD;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.SKOS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.blazegraph.label.LabelServiceExtractOptimizer;
import org.wikidata.query.rdf.blazegraph.label.LabelServiceUtils;

public class EmptyLabelServiceOptimizer
extends AbstractJoinGroupOptimizer {
    private static final Logger log = LoggerFactory.getLogger(EmptyLabelServiceOptimizer.class);
    private static final URI DESCRIPTION = new URIImpl("http://schema.org/description");

    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode op) {
        QueryRoot root = sa.getQueryRoot();
        if (root.getQueryType() == QueryType.ASK) {
            return;
        }
        LabelServiceUtils.getLabelServiceNodes(op).forEach(service -> {
            JoinGroupNode g = (JoinGroupNode)service.getGraphPattern();
            boolean foundArg = false;
            for (BOp st : g.args()) {
                StatementPatternNode sn = (StatementPatternNode)st;
                if (sn.s().isConstant() && BD.SERVICE_PARAM.equals((Object)sn.s().getValue())) continue;
                foundArg = true;
                break;
            }
            if (this.restoreExtracted((ServiceNode)service)) {
                foundArg = true;
            }
            if (!foundArg) {
                this.addResolutions(ctx, g, root.getProjection());
            }
        });
    }

    private boolean restoreExtracted(ServiceNode service) {
        boolean found = false;
        JoinGroupNode g = (JoinGroupNode)service.getGraphPattern();
        List extractedList = (List)service.annotations().get(LabelServiceExtractOptimizer.EXTRACTOR_ANNOTATION);
        if (extractedList != null && !extractedList.isEmpty()) {
            for (StatementPatternNode st : extractedList) {
                g.addArg((BOp)st);
            }
            found = true;
        }
        service.annotations().remove(LabelServiceExtractOptimizer.EXTRACTOR_ANNOTATION);
        return found;
    }

    private void addResolutions(AST2BOpContext ctx, JoinGroupNode g, ProjectionNode p) {
        if (p == null) {
            return;
        }
        for (AssignmentNode a : p) {
            boolean replaced;
            IVariable var = a.getVar();
            if (a.getValueExpression() != var || !(replaced = this.addResolutionIfSuffix(ctx, g, "AltLabel", SKOS.ALT_LABEL, (IVariable<IV>)var) || this.addResolutionIfSuffix(ctx, g, "Label", RDFS.LABEL, (IVariable<IV>)var) || this.addResolutionIfSuffix(ctx, g, "Description", DESCRIPTION, (IVariable<IV>)var)) || !log.isDebugEnabled()) continue;
            log.debug("Resolving {} using a label lookup.", (Object)var);
        }
    }

    @SuppressFBWarnings(value={"OCP_OVERLY_CONCRETE_PARAMETER"}, justification="Using AST2BOpContext makes sense since it is the only type that will ever be passed")
    private boolean addResolutionIfSuffix(AST2BOpContext ctx, JoinGroupNode g, String suffix, URI labelType, IVariable<IV> var) {
        if (!var.getName().endsWith(suffix)) {
            return false;
        }
        String source = var.getName().substring(0, var.getName().length() - suffix.length());
        IConstant labelTypeAsConstant = ctx.getAbstractTripleStore().getVocabulary().getConstant((Value)labelType);
        g.addArg((BOp)new StatementPatternNode((TermNode)new VarNode(source), (TermNode)new ConstantNode(labelTypeAsConstant), (TermNode)new VarNode(var)));
        return true;
    }
}

