/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.mwapi;

import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.wikidata.query.rdf.blazegraph.mwapi.MWApiServiceFactory;
import org.wikidata.query.rdf.common.uri.WikibaseUris;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"}, justification="low priority to fix")
public class ApiTemplate {
    private final Map<String, String> fixedParams;
    private final Set<String> inputVars;
    private final Map<String, String> defaults;
    private final Map<String, String> outputVars;
    private final String items;

    protected ApiTemplate(Map<String, String> fixedParams, Set<String> inputVars, Map<String, String> defaults, Map<String, String> outputVars, String items) {
        this.fixedParams = fixedParams;
        this.inputVars = inputVars;
        this.defaults = defaults;
        this.outputVars = outputVars;
        this.items = items;
    }

    public static ApiTemplate fromJSON(JsonNode json) {
        HashMap fixedParams = new HashMap();
        HashSet inputVars = new HashSet();
        HashMap defaults = new HashMap();
        HashMap outputVars = new HashMap();
        JsonNode params = json.get("params");
        Objects.requireNonNull(params, "Missing params node");
        params.fieldNames().forEachRemaining(paramName -> {
            if (fixedParams.containsKey(paramName) || inputVars.contains(paramName)) {
                throw new IllegalArgumentException("Repeated input parameter " + paramName);
            }
            JsonNode value = params.get(paramName);
            if (value.isValueNode()) {
                fixedParams.put(paramName, value.asText());
                return;
            }
            inputVars.add(paramName);
            if (value.has("default")) {
                defaults.put(paramName, value.get("default").asText());
            }
        });
        JsonNode output = json.get("output");
        Objects.requireNonNull(params, "Missing output node");
        String items = output.get("items").asText();
        JsonNode vars = output.get("vars");
        Objects.requireNonNull(vars, "Missing vars node");
        vars.fieldNames().forEachRemaining(paramName -> {
            if (inputVars.contains(paramName) || fixedParams.containsKey(paramName)) {
                throw new IllegalArgumentException("Parameter " + paramName + " declared as both input and output");
            }
            outputVars.put(paramName, vars.get(paramName).asText());
        });
        return new ApiTemplate((Map<String, String>)ImmutableMap.copyOf(fixedParams), (Set<String>)ImmutableSet.copyOf(inputVars), (Map<String, String>)ImmutableMap.copyOf(defaults), (Map<String, String>)ImmutableMap.copyOf(outputVars), items);
    }

    public String getItemsPath() {
        return this.items;
    }

    public boolean isRequiredParameter(String name) {
        return this.inputVars.contains(name);
    }

    public Map<String, String> getFixedParams() {
        return this.fixedParams;
    }

    public String getInputDefault(String name) {
        return this.defaults.get(name);
    }

    private void addInputVar(Map<String, IVariableOrConstant> vars, String varName, TermNode var) {
        if (var == null) {
            if (!this.defaults.containsKey(varName)) {
                throw new IllegalArgumentException("Parameter " + varName + " must be bound");
            }
            vars.put(varName, null);
        } else {
            if (!var.isConstant() && !var.isVariable()) {
                throw new IllegalArgumentException("Parameter " + varName + " must be constant or variable");
            }
            vars.put(varName, var.getValueExpression());
        }
    }

    public Map<String, IVariableOrConstant> getInputVars(ServiceParams serviceParams) {
        HashMap<String, IVariableOrConstant> vars = new HashMap<String, IVariableOrConstant>(this.inputVars.size());
        String prefix = MWApiServiceFactory.paramNameToURI("").stringValue();
        for (String entry : this.inputVars) {
            this.addInputVar(vars, entry, serviceParams.get(MWApiServiceFactory.paramNameToURI(entry), null));
        }
        serviceParams.iterator().forEachRemaining(param -> {
            String paramNameFull = ((URI)param.getKey()).stringValue();
            if (!paramNameFull.startsWith(prefix)) {
                return;
            }
            String paramName = paramNameFull.substring(prefix.length());
            if (((List)param.getValue()).size() > 1) {
                throw new IllegalArgumentException("Parameter " + paramName + " is duplicated");
            }
            if (vars.containsKey(paramName)) {
                return;
            }
            this.addInputVar(vars, paramName, (TermNode)((List)param.getValue()).get(0));
        });
        return vars;
    }

    public List<OutputVariable> getOutputVars(ServiceNode serviceNode) {
        ArrayList<OutputVariable> vars = new ArrayList<OutputVariable>(this.outputVars.size());
        GraphPatternGroup group = serviceNode.getGraphPattern();
        Objects.requireNonNull(serviceNode, "Group node is null?");
        String prefix = MWApiServiceFactory.paramNameToURI("").stringValue();
        group.iterator().forEachRemaining(node -> {
            StatementPatternNode sp;
            if (node instanceof StatementPatternNode && (sp = (StatementPatternNode)node).s().isVariable() && sp.o().isConstant() && sp.p().isConstant()) {
                for (OutputVariable.Type varType : OutputVariable.Type.values()) {
                    if (!varType.predicate.equals((Object)sp.p().getValue())) continue;
                    IVariable var = (IVariable)sp.s().getValueExpression();
                    if (varType == OutputVariable.Type.ORDINAL) {
                        vars.add(new OutputVariable(varType, var, "."));
                        break;
                    }
                    IV value = (IV)sp.o().getValueExpression().get();
                    if (value.isURI()) {
                        String paramName = value.stringValue().substring(prefix.length());
                        vars.add(new OutputVariable(varType, var, this.outputVars.get(paramName)));
                        break;
                    }
                    vars.add(new OutputVariable(varType, var, value.stringValue()));
                    break;
                }
            }
        });
        return vars;
    }

    public static class OutputVariable {
        private final IVariable var;
        private final String path;
        private final Type type;

        public OutputVariable(Type type, IVariable var, String xpath) {
            this.var = var;
            this.path = xpath;
            this.type = type;
        }

        public OutputVariable(IVariable var, String xpath) {
            this(Type.STRING, var, xpath);
        }

        public IVariable getVar() {
            return this.var;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.var.getName();
        }

        public String toString() {
            return this.getName() + "(" + this.getPath() + ")";
        }

        public boolean isOrdinal() {
            return this.type == Type.ORDINAL;
        }

        public boolean isURI() {
            return this.type != Type.STRING && this.type != Type.ORDINAL;
        }

        public URI getURI(String value) {
            switch (this.type) {
                case URI: {
                    return new URIImpl(value);
                }
                case ITEM: {
                    return new URIImpl(WikibaseUris.getURISystem().entity() + value.toUpperCase(Locale.ROOT));
                }
            }
            throw new IllegalArgumentException("Can not produce URI for non-URI type " + (Object)((Object)this.type));
        }

        public static enum Type {
            STRING("apiOutput"),
            URI("apiOutputURI"),
            ITEM("apiOutputItem"),
            ORDINAL("apiOrdinal");

            private final URI predicate;

            private Type(String predicate) {
                this.predicate = new URIImpl("http://wikiba.se/ontology#" + predicate);
            }

            URI predicate() {
                return this.predicate;
            }

            public String toString() {
                return this.predicate.stringValue();
            }
        }
    }
}

