/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.throttling;

import com.google.common.cache.Cache;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.blazegraph.throttling.BanState;
import org.wikidata.query.rdf.blazegraph.throttling.Throttler;

public class BanThrottler<S extends BanState>
extends Throttler<S> {
    private static final Logger log = LoggerFactory.getLogger(BanThrottler.class);

    public BanThrottler(Callable<S> createThrottlingState, Cache<Object, S> stateStore, String enableThrottlingIfHeader, String alwaysBanParam, Clock clock) {
        super(createThrottlingState, stateStore, enableThrottlingIfHeader, alwaysBanParam, clock);
    }

    @Override
    protected Instant internalThrottledUntil(Object bucket, HttpServletRequest request) {
        BanState state = (BanState)this.getStateIfPresent(bucket);
        if (state == null) {
            return Instant.MIN;
        }
        return state.bannedUntil();
    }

    public void throttled(Object bucket, HttpServletRequest request) {
        if (this.shouldBypassThrottling(request)) {
            return;
        }
        try {
            ((BanState)this.getState(bucket)).consumeThrottled();
        }
        catch (ExecutionException ee) {
            log.warn("Could not create throttling state", (Throwable)ee);
        }
    }
}

