/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.throttling;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.blazegraph.throttling.Bucketing;

@Immutable
@ThreadSafe
public class RegexpBucketing
implements Bucketing {
    private static final Logger log = LoggerFactory.getLogger(RegexpBucketing.class);
    private final Collection<Pattern> patterns;

    public RegexpBucketing(Collection<Pattern> patterns) {
        this.patterns = ImmutableList.copyOf(patterns);
    }

    @Override
    public Object bucket(HttpServletRequest request) {
        String query = request.getParameter("query");
        if (query == null) {
            return null;
        }
        for (Pattern p : this.patterns) {
            Matcher m = p.matcher(query);
            if (!m.find()) continue;
            log.debug("Matched pattern {} on {}", (Object)p, (Object)query);
            return p;
        }
        return null;
    }
}

