/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.throttling;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpServletRequest;

@ThreadSafe
public abstract class Throttler<S> {
    private final Cache<Object, S> state;
    private final Callable<S> createThrottlingState;
    @Nullable
    private final String enableThrottlingIfHeader;
    @Nullable
    public final String alwaysThrottleParam;
    @Nonnull
    private final Clock clock;

    public Throttler(Callable<S> createThrottlingState, Cache<Object, S> stateStore, String enableThrottlingIfHeader, String alwaysThrottleParam, @Nonnull Clock clock) {
        this.state = stateStore;
        this.createThrottlingState = createThrottlingState;
        this.enableThrottlingIfHeader = Strings.emptyToNull((String)enableThrottlingIfHeader);
        this.alwaysThrottleParam = Strings.emptyToNull((String)alwaysThrottleParam);
        this.clock = clock;
    }

    protected S getState(Object bucket) throws ExecutionException {
        return (S)this.state.get(bucket, this.createThrottlingState);
    }

    protected S getStateIfPresent(Object bucket) {
        return (S)this.state.getIfPresent(bucket);
    }

    private boolean alwaysThrottle(HttpServletRequest request) {
        if (this.alwaysThrottleParam == null) {
            return false;
        }
        return request.getParameter(this.alwaysThrottleParam) != null;
    }

    protected boolean shouldBypassThrottling(HttpServletRequest request) {
        if (this.enableThrottlingIfHeader == null) {
            return false;
        }
        return request.getHeader(this.enableThrottlingIfHeader) == null;
    }

    public Instant throttledUntil(Object bucket, HttpServletRequest request) {
        if (this.alwaysThrottle(request)) {
            return Instant.MAX;
        }
        if (this.shouldBypassThrottling(request)) {
            return Instant.MIN;
        }
        return this.internalThrottledUntil(bucket, request);
    }

    public Duration throttledDuration(Object bucket, HttpServletRequest request) {
        Instant throttledUntil = this.throttledUntil(bucket, request);
        return Duration.between(Instant.now(this.clock), throttledUntil);
    }

    protected abstract Instant internalThrottledUntil(Object var1, HttpServletRequest var2);
}

