/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.throttling;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.FilterConfig;

@ThreadSafe
public class ThrottlingFilterConfig {
    public static final String PATTERNS_DEFAULT = "patterns.txt";
    private final FilterConfig filterConfig;

    public ThrottlingFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    private String loadStringParam(String name, FilterConfig filterConfig) {
        String sParam;
        String result = null;
        String fParam = filterConfig.getInitParameter(name);
        if (fParam != null) {
            result = fParam;
        }
        if ((sParam = System.getProperty("wdqs." + filterConfig.getFilterName() + "." + name)) != null) {
            result = sParam;
        }
        return result;
    }

    private String loadStringParam(String name, FilterConfig filterConfig, String defaultValue) {
        return (String)MoreObjects.firstNonNull((Object)this.loadStringParam(name, filterConfig), (Object)defaultValue);
    }

    private boolean loadBooleanParam(String name, FilterConfig filterConfig, boolean defaultValue) {
        String result = this.loadStringParam(name, filterConfig);
        return result != null ? Boolean.parseBoolean(result) : defaultValue;
    }

    private int loadIntParam(String name, FilterConfig filterConfig, int defaultValue) {
        String result = this.loadStringParam(name, filterConfig);
        return result != null ? Integer.parseInt(result) : defaultValue;
    }

    public Duration getRequestDurationThreshold() {
        return Duration.ofMillis(this.loadIntParam("request-duration-threshold-in-millis", this.filterConfig, 0));
    }

    public Duration getTimeBucketCapacity() {
        return Duration.ofSeconds(this.loadIntParam("time-bucket-capacity-in-seconds", this.filterConfig, 120));
    }

    public Duration getTimeBucketRefillAmount() {
        return Duration.ofSeconds(this.loadIntParam("time-bucket-refill-amount-in-seconds", this.filterConfig, 60));
    }

    public Duration getTimeBucketRefillPeriod() {
        return Duration.ofMinutes(this.loadIntParam("time-bucket-refill-period-in-minutes", this.filterConfig, 1));
    }

    public int getErrorBucketCapacity() {
        return this.loadIntParam("error-bucket-capacity", this.filterConfig, 60);
    }

    public int getErrorBucketRefillAmount() {
        return this.loadIntParam("error-bucket-refill-amount", this.filterConfig, 30);
    }

    public Duration getErrorBucketRefillPeriod() {
        return Duration.ofMinutes(this.loadIntParam("error-bucket-refill-period-in-minutes", this.filterConfig, 1));
    }

    public int getThrottleBucketCapacity() {
        return this.loadIntParam("throttle-bucket-capacity", this.filterConfig, 200);
    }

    public int getThrottleBucketRefillAmount() {
        return this.loadIntParam("throttle-bucket-refill-amount", this.filterConfig, 200);
    }

    public Duration getThrottleBucketRefillPeriod() {
        return Duration.ofMinutes(this.loadIntParam("throttle-bucket-refill-period-in-minutes", this.filterConfig, 20));
    }

    public Duration getBanDuration() {
        return Duration.ofMinutes(this.loadIntParam("ban-duration-in-minutes", this.filterConfig, 1440));
    }

    public int getMaxStateSize() {
        return this.loadIntParam("max-state-size", this.filterConfig, 2000);
    }

    public Duration getStateExpiration() {
        return Duration.ofMinutes(this.loadIntParam("state-expiration-in-minutes", this.filterConfig, 15));
    }

    public String getEnableThrottlingIfHeader() {
        return this.loadStringParam("enable-throttling-if-header", this.filterConfig);
    }

    public String getEnableBanIfHeader() {
        return this.loadStringParam("enable-ban-if-header", this.filterConfig);
    }

    public String getAlwaysThrottleParam() {
        return this.loadStringParam("always-throttle-param", this.filterConfig, "throttleMe");
    }

    public String getAlwaysBanParam() {
        return this.loadStringParam("always-ban-param", this.filterConfig, "banMe");
    }

    public boolean isFilterEnabled() {
        return this.loadBooleanParam("enabled", this.filterConfig, true);
    }

    public String getRegexPatternsFile() {
        return this.loadStringParam("pattern-file", this.filterConfig, PATTERNS_DEFAULT);
    }
}

