/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.throttling;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.isomorphism.util.TokenBucket;
import org.wikidata.query.rdf.blazegraph.throttling.BanState;
import org.wikidata.query.rdf.blazegraph.throttling.TimeAndErrorsState;

@ThreadSafe
public final class ThrottlingState
implements BanState,
TimeAndErrorsState {
    private final Ban ban;
    private final TimeAndErrors timeAndErrors;

    public ThrottlingState(TokenBucket timeBucket, TokenBucket errorsBucket, TokenBucket throttleBucket, Duration banDuration) {
        this(timeBucket, errorsBucket, throttleBucket, banDuration, Clock.systemUTC());
    }

    @VisibleForTesting
    ThrottlingState(TokenBucket timeBucket, TokenBucket errorsBucket, TokenBucket throttleBucket, Duration banDuration, Clock clock) {
        this.ban = new Ban(throttleBucket, banDuration, clock);
        this.timeAndErrors = new TimeAndErrors(timeBucket, errorsBucket, clock);
    }

    @Override
    public void consumeThrottled() {
        this.ban.consumeThrottled();
    }

    @Override
    public Instant bannedUntil() {
        return this.ban.bannedUntil();
    }

    @Override
    public void consumeTime(Duration elapsed) {
        this.timeAndErrors.consumeTime(elapsed);
    }

    @Override
    public void consumeError() {
        this.timeAndErrors.consumeError();
    }

    @Override
    public Instant throttledUntil() {
        return this.timeAndErrors.throttledUntil();
    }

    private static final class TimeAndErrors
    implements TimeAndErrorsState {
        @Nonnull
        private final TokenBucket timeBucket;
        @Nonnull
        private final TokenBucket errorsBucket;
        @Nonnull
        private final Clock clock;

        private TimeAndErrors(@Nonnull TokenBucket timeBucket, @Nonnull TokenBucket errorsBucket, @Nonnull Clock clock) {
            this.timeBucket = timeBucket;
            this.errorsBucket = errorsBucket;
            this.clock = clock;
        }

        @Override
        public synchronized void consumeTime(Duration elapsed) {
            long tokenToConsume = Math.min(elapsed.toMillis(), this.timeBucket.getNumTokens());
            if (tokenToConsume > 0L) {
                this.timeBucket.consume(tokenToConsume);
            }
        }

        @Override
        public synchronized void consumeError() {
            this.errorsBucket.tryConsume();
        }

        private static long backoffDelayMillis(TokenBucket bucket) {
            if (bucket.getNumTokens() > 0L) {
                return 0L;
            }
            return bucket.getDurationUntilNextRefill(TimeUnit.MILLISECONDS);
        }

        @Override
        public synchronized Instant throttledUntil() {
            if (this.timeBucket.getNumTokens() > 0L && this.errorsBucket.getNumTokens() > 0L) {
                return Instant.MIN;
            }
            return Instant.now(this.clock).plus(Duration.of(Math.max(TimeAndErrors.backoffDelayMillis(this.timeBucket), TimeAndErrors.backoffDelayMillis(this.errorsBucket)), ChronoUnit.MILLIS));
        }
    }

    private static final class Ban
    implements BanState {
        @Nonnull
        private final TokenBucket throttleBucket;
        @Nonnull
        private Instant bannedUntil = Instant.MIN;
        @Nonnull
        private final Duration banDuration;
        @Nonnull
        private final Clock clock;

        private Ban(@Nonnull TokenBucket throttleBucket, @Nonnull Duration banDuration, @Nonnull Clock clock) {
            this.throttleBucket = throttleBucket;
            this.banDuration = banDuration;
            this.clock = clock;
        }

        @Override
        public synchronized void consumeThrottled() {
            if (this.isBanned()) {
                return;
            }
            if (!this.throttleBucket.tryConsume()) {
                this.bannedUntil = Instant.now(this.clock).plus(this.banDuration);
            }
        }

        private boolean isBanned() {
            return this.bannedUntil.isAfter(Instant.now(this.clock));
        }

        @Override
        public synchronized Instant bannedUntil() {
            return this.bannedUntil;
        }
    }
}

