/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph;

import com.bigdata.rdf.sparql.ast.service.RemoteServiceCall;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceCallImpl;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceFactoryImpl;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.codahale.metrics.Timer;
import cutthecrap.utils.striterators.ICloseableIterator;
import org.openrdf.query.BindingSet;

public class MeteringRemoteServiceFactory
extends RemoteServiceFactoryImpl {
    private final Timer requestTimer;

    public MeteringRemoteServiceFactory(Timer requestTimer, RemoteServiceOptions serviceOptions) {
        super(serviceOptions);
        this.requestTimer = requestTimer;
    }

    public RemoteServiceCall create(ServiceCallCreateParams params) {
        return new RemoteServiceCallImpl(params){

            public ICloseableIterator<BindingSet> call(BindingSet[] bindingSets) throws Exception {
                try (Timer.Context context = MeteringRemoteServiceFactory.this.requestTimer.time();){
                    ICloseableIterator iCloseableIterator = super.call(bindingSets);
                    return iCloseableIterator;
                }
            }
        };
    }
}

