/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph;

import com.bigdata.rdf.internal.InlineURIFactory;
import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.InlineUnsignedIntegerURIHandler;
import com.bigdata.rdf.internal.NormalizingInlineUriHandler;
import com.bigdata.rdf.internal.TrailingSlashRemovingInlineUriHandler;
import org.wikidata.query.rdf.blazegraph.inline.uri.InlineFixedWidthHexIntegerURIHandler;
import org.wikidata.query.rdf.blazegraph.inline.uri.UndecoratedUuidInlineUriHandler;
import org.wikidata.query.rdf.common.uri.PropertyType;
import org.wikidata.query.rdf.common.uri.UrisScheme;
import org.wikidata.query.rdf.common.uri.UrisSchemeFactory;

public class WikibaseInlineUriFactory
extends InlineURIFactory {
    private static final UrisScheme uris = UrisSchemeFactory.getURISystem();

    public WikibaseInlineUriFactory() {
        for (PropertyType p : PropertyType.values()) {
            this.addHandler((InlineURIHandler)new InlineUnsignedIntegerURIHandler(uris.property(p) + "P"));
        }
        uris.entityInitials().forEach(s -> this.addHandler((InlineURIHandler)new InlineUnsignedIntegerURIHandler(uris.entityIdToURI(s))));
        TrailingSlashRemovingInlineUriHandler viaf = new TrailingSlashRemovingInlineUriHandler((InlineURIHandler)new InlineUnsignedIntegerURIHandler("https://viaf.org/viaf/"));
        this.addHandler(viaf);
        this.addHandler(new NormalizingInlineUriHandler(viaf, "http://viaf.org/viaf/"));
        this.addHandler(new TrailingSlashRemovingInlineUriHandler((InlineURIHandler)new InlineUnsignedIntegerURIHandler("http://sws.geonames.org/")));
        this.addHandler((InlineURIHandler)new InlineUnsignedIntegerURIHandler("http://rdf.ncbi.nlm.nih.gov/pubchem/compound/CID"));
        this.addHandler((InlineURIHandler)new InlineUnsignedIntegerURIHandler("http://rdf.chemspider.com/"));
        this.addHandler(new UndecoratedUuidInlineUriHandler(uris.value()));
    }

    public static class V001
    extends WikibaseInlineUriFactory {
        public V001() {
            this.addHandler((InlineURIHandler)new InlineFixedWidthHexIntegerURIHandler(uris.reference(), 40));
            TrailingSlashRemovingInlineUriHandler viaf = new TrailingSlashRemovingInlineUriHandler((InlineURIHandler)new InlineUnsignedIntegerURIHandler("http://viaf.org/viaf/"));
            this.addHandler(viaf);
            this.addHandler(new NormalizingInlineUriHandler(viaf, "https://viaf.org/viaf/"));
            this.addHandler((InlineURIHandler)new InlineUnsignedIntegerURIHandler("http://purl.uniprot.org/geneid/"));
        }
    }
}

