/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph;

import com.bigdata.rdf.sparql.ast.optimizers.ASTJoinGroupOrderOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTRunFirstRunLastOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.DefaultOptimizerList;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import org.wikidata.query.rdf.blazegraph.label.EmptyLabelServiceOptimizer;
import org.wikidata.query.rdf.blazegraph.label.LabelServiceExtractOptimizer;
import org.wikidata.query.rdf.blazegraph.label.LabelServicePlacementOptimizer;

public class WikibaseOptimizers
extends DefaultOptimizerList {
    private static final long serialVersionUID = 2364845438265527328L;

    public WikibaseOptimizers() {
        this.addAfter(ASTRunFirstRunLastOptimizer.class, (IASTOptimizer)new LabelServicePlacementOptimizer());
        this.addAfter(LabelServicePlacementOptimizer.class, (IASTOptimizer)new EmptyLabelServiceOptimizer());
        this.addAfter(EmptyLabelServiceOptimizer.class, (IASTOptimizer)new LabelServicePlacementOptimizer());
        this.addBefore(ASTJoinGroupOrderOptimizer.class, (IASTOptimizer)new LabelServiceExtractOptimizer());
    }

    private void addAfter(Class<?> type, IASTOptimizer opt) {
        int idx = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!type.isInstance(this.get(i))) continue;
            idx = i + 1;
        }
        if (idx > 0) {
            this.add(idx, opt);
            return;
        }
        throw new IllegalArgumentException("Cannot find placement for " + opt.getClass());
    }

    private void addBefore(Class<?> type, IASTOptimizer opt) {
        for (int i = 0; i < this.size(); ++i) {
            if (!type.isInstance(this.get(i))) continue;
            this.add(i, opt);
            return;
        }
        throw new IllegalArgumentException("Cannot find placement for " + opt.getClass());
    }
}

