/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.openrdf.model.Literal;

public class DecodeUriBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = -8448763718374010166L;

    public DecodeUriBOp(IValueExpression<? extends IV> x, GlobalAnnotations globals) {
        super(x, globals, new NV[0]);
    }

    public DecodeUriBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
    }

    public DecodeUriBOp(DecodeUriBOp op) {
        super((IVValueExpression)op);
    }

    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    @SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"}, justification="SparqlTypeErrorException does not allow setting a cause")
    public IV get(IBindingSet bs) {
        Literal lit = this.getAndCheckLiteralValue(0, bs);
        try {
            BigdataLiteral str = this.getValueFactory().createLiteral(URLDecoder.decode(lit.getLabel(), StandardCharsets.UTF_8.name()));
            return super.asIV((BigdataValue)str, bs);
        }
        catch (UnsupportedEncodingException uee) {
            throw new SparqlTypeErrorException();
        }
    }
}

