/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.filters;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ClientIPFilter
implements Filter {
    private static final String X_CLIENT_IP = "X-Client-IP";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            chain.doFilter((ServletRequest)new RealIPHttpRequestWrapper((HttpServletRequest)request), response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private static final class RealIPHttpRequestWrapper
    extends HttpServletRequestWrapper {
        private RealIPHttpRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getRemoteAddr() {
            String realIP = this.getHeader(ClientIPFilter.X_CLIENT_IP);
            return realIP != null ? realIP : super.getRemoteAddr();
        }

        public String getRemoteHost() {
            try {
                return InetAddress.getByName(this.getRemoteAddr()).getHostName();
            }
            catch (UnknownHostException e) {
                return this.getRemoteAddr();
            }
        }
    }
}

