/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.inline.literal;

import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.util.InnerCause;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public abstract class AbstractMultiTypeExtension<V extends BigdataValue>
implements IExtension<V> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMultiTypeExtension.class);
    private final Map<IV, BigdataURI> dataTypes;
    private final Set<BigdataURI> dataTypesSet;

    public AbstractMultiTypeExtension(IDatatypeURIResolver resolver, Set<URI> supportedDataTypes) {
        ImmutableMap.Builder dataTypesBuilder = ImmutableMap.builder();
        for (URI uri : supportedDataTypes) {
            BigdataURI val = resolver.resolve(uri);
            dataTypesBuilder.put((Object)val.getIV(), (Object)val);
        }
        this.dataTypes = dataTypesBuilder.build();
        this.dataTypesSet = Collections.unmodifiableSet(new HashSet<BigdataURI>(this.dataTypes.values()));
    }

    public Set<BigdataURI> getDatatypes() {
        return this.dataTypesSet;
    }

    public LiteralExtensionIV createIV(Value value) {
        if (!(value instanceof Literal)) {
            throw new IllegalArgumentException("Expected a literal but got " + value);
        }
        Literal literal = (Literal)value;
        try {
            BigdataURI dt = this.resolveDataType(literal);
            return new LiteralExtensionIV(this.createDelegateIV(literal, dt), dt.getIV());
        }
        catch (Exception e) {
            log.warn("Couldn't create IV", (Throwable)e);
            throw e;
        }
    }

    public V asValue(LiteralExtensionIV iv, BigdataValueFactory vf) {
        BigdataURI dt = this.resolveDataType(iv);
        try {
            return (V)this.safeAsValue(iv, vf, dt);
        }
        catch (RuntimeException ex) {
            if (InnerCause.isInnerCause((Throwable)ex, InterruptedException.class)) {
                throw ex;
            }
            throw new IllegalArgumentException("bad iv: " + iv, ex);
        }
    }

    protected abstract AbstractLiteralIV createDelegateIV(Literal var1, BigdataURI var2);

    protected abstract BigdataLiteral safeAsValue(LiteralExtensionIV var1, BigdataValueFactory var2, BigdataURI var3);

    protected BigdataURI resolveDataType(LiteralExtensionIV literal) {
        IV extensionIV = literal.getExtensionIV();
        BigdataURI dt = this.dataTypes.get(extensionIV);
        if (dt == null) {
            throw new IllegalArgumentException("Unrecognized datatype:  " + extensionIV);
        }
        return dt;
    }

    protected BigdataURI resolveDataType(Literal literal) {
        URI dt = literal.getDatatype();
        if (dt == null) {
            throw new IllegalArgumentException("Literal doesn't have a data type:  " + literal);
        }
        for (BigdataURI val : this.dataTypes.values()) {
            if (!val.stringValue().equals(dt.stringValue())) continue;
            return val;
        }
        throw new IllegalArgumentException("Unrecognized data type:  " + dt);
    }
}

