/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.inline.uri;

import com.bigdata.rdf.internal.InlineSignedIntegerURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;

public class InlineFixedWidthHexIntegerURIHandler
extends InlineSignedIntegerURIHandler {
    private final int fixedWidth;
    private final String zeroPadding;

    public InlineFixedWidthHexIntegerURIHandler(String namespace, int fixedWidth) {
        super(namespace);
        this.fixedWidth = fixedWidth;
        this.zeroPadding = Strings.repeat((String)"0", (int)fixedWidth);
    }

    protected AbstractLiteralIV createInlineIV(String localName) {
        return InlineSignedIntegerURIHandler.createInlineIV((BigInteger)new BigInteger(localName, 16));
    }

    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        BigInteger bigintVal;
        if (delegate instanceof XSDIntegerIV) {
            bigintVal = ((XSDIntegerIV)delegate).getInlineValue();
        } else {
            String intStr = super.getLocalNameFromDelegate(delegate);
            bigintVal = new BigInteger(intStr, 10);
        }
        return this.toFixedWidthHexString(bigintVal);
    }

    @SuppressFBWarnings(value={"STT_STRING_PARSING_A_FIELD", "PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"}, justification="Using String in this manner is exactly what we want")
    private String toFixedWidthHexString(BigInteger bigintVal) {
        String localName = bigintVal.toString(16);
        if (localName.length() < this.fixedWidth) {
            localName = this.zeroPadding.substring(localName.length()) + localName;
        }
        return localName;
    }
}

