/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.label;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BD;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDFS;
import org.wikidata.query.rdf.blazegraph.BigdataValuesHelper;
import org.wikidata.query.rdf.common.uri.UrisScheme;
import org.wikidata.query.rdf.common.uri.UrisSchemeFactory;

public class LabelService
extends AbstractServiceFactory {
    private static final BigdataNativeServiceOptions SERVICE_OPTIONS = new BigdataNativeServiceOptions();
    public static final URI SERVICE_KEY = new URIImpl("http://wikiba.se/ontology#label");
    public static final URIImpl LANGUAGE_PARAM = new URIImpl("http://wikiba.se/ontology#language");
    static final String LABEL_SERVICE_IN_VARS = "LabelService.inVars";
    static final String LABEL_SERVICE_OUT_VARS = "LabelService.outVars";
    public static final URIImpl DISABLE_REORDERING = new URIImpl("http://wikiba.se/ontology#disableReordering");
    public static final String DISABLE_REORDERING_ANNOTATION = LabelService.class.getName() + ".disableReordering";
    private static final String AUTO_LANGUAGE = "[AUTO_LANGUAGE]";

    public static void register() {
        ServiceRegistry reg = ServiceRegistry.getInstance();
        reg.add(SERVICE_KEY, (ServiceFactory)new LabelService());
        reg.addWhitelistURL(SERVICE_KEY.toString());
    }

    public IServiceOptions getServiceOptions() {
        return SERVICE_OPTIONS;
    }

    public BigdataServiceCall create(ServiceCallCreateParams params, ServiceParams serviceParams) {
        return new LabelServiceCall(new ResolutionContext(params.getTripleStore(), this.findLanguageFallbacks(serviceParams)), LabelService.findResolutions(params));
    }

    private boolean isBadLanguage(String lang) {
        if (lang.isEmpty()) {
            return true;
        }
        return AUTO_LANGUAGE.equals(lang);
    }

    private Map<String, Integer> findLanguageFallbacks(ServiceParams params) {
        List paramNodes = params.get((URI)LANGUAGE_PARAM);
        Preconditions.checkArgument((!paramNodes.isEmpty() ? 1 : 0) != 0, (Object)"You must provide the label service a list of languages.");
        HashMap<String, Integer> fallbacksMap = new HashMap<String, Integer>();
        int cnt = 0;
        for (TermNode term : paramNodes) {
            Preconditions.checkArgument((!term.isVariable() ? 1 : 0) != 0, (Object)"not a constant");
            BigdataValue v = term.getValue();
            Preconditions.checkArgument((boolean)(v instanceof Literal), (Object)"not a literal");
            String s = v.stringValue().trim();
            if (s.contains(",")) {
                for (String ls : s.split(",")) {
                    String key = ls.trim();
                    if (this.isBadLanguage(key)) continue;
                    if (!fallbacksMap.containsKey(key)) {
                        fallbacksMap.put(key, cnt);
                    }
                    ++cnt;
                }
            } else if (!this.isBadLanguage(s) && !fallbacksMap.containsKey(s)) {
                fallbacksMap.put(s, cnt);
            }
            ++cnt;
        }
        return fallbacksMap;
    }

    private static List<Resolution> findResolutions(ServiceCallCreateParams params) {
        return LabelService.findResolutions(params.getServiceNode());
    }

    static List<Resolution> findResolutions(ServiceNode params) {
        JoinGroupNode g = (JoinGroupNode)params.getGraphPattern();
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>(g.args().size());
        for (BOp st : g.args()) {
            StatementPatternNode sn = (StatementPatternNode)st;
            if (sn.s().isConstant() && BD.SERVICE_PARAM.equals((Object)sn.s().getValue())) continue;
            resolutions.add(new Resolution(sn));
        }
        return resolutions;
    }

    public Set<IVariable<?>> getDesiredBound(ServiceNode serviceNode) {
        List<Resolution> res = LabelService.findResolutions(serviceNode);
        return (Set)res.stream().filter(resolution -> resolution.subject() instanceof IVariable).map(resolution -> (IVariable)resolution.subject()).collect(ImmutableSet.toImmutableSet());
    }

    private static class ResolutionContext {
        private final AbstractTripleStore tripleStore;
        private final LexiconRelation lexiconRelation;
        private final Map<String, Integer> languageFallbacks;
        private final List<IV> bestLabels = new ArrayList<IV>();
        private IBindingSet binding;
        private IV resolvedSubject;
        private IV resolvedLabelType;
        private IV rdfsLabelIv;
        private IV descriptionIv;

        ResolutionContext(AbstractTripleStore tripleStore, Map<String, Integer> languageFallbacks) {
            this.tripleStore = tripleStore;
            this.languageFallbacks = languageFallbacks;
            this.lexiconRelation = tripleStore.getLexiconRelation();
        }

        public void binding(IBindingSet binding) {
            this.binding = binding;
        }

        public void resolve(Resolution resolution) {
            this.resolvedSubject = this.resolveToIvOrError(resolution.subject(), "subject");
            this.resolvedLabelType = this.resolveToIvOrError(resolution.labelType(), "label type");
            if (this.resolvedSubject == null || this.resolvedLabelType == null) {
                return;
            }
            this.fillBestLabels();
            IV label = this.pickOrBuildBestLabel();
            if (label != null) {
                this.binding.set(resolution.target(), (IConstant)new Constant((Object)label));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillBestLabels() {
            this.bestLabels.clear();
            if (this.languageFallbacks.isEmpty()) {
                return;
            }
            try (IChunkedOrderedIterator lookup = this.tripleStore.getAccessPath(this.resolvedSubject, this.resolvedLabelType, null).iterator();){
                int bestLabelRank = Integer.MAX_VALUE;
                boolean uniqueType = this.uniqueLabelType(this.resolvedLabelType);
                while (lookup.hasNext()) {
                    Integer languageOrdinal;
                    Literal literal;
                    String language;
                    ISPO spo = (ISPO)lookup.next();
                    IV o = spo.o();
                    if (!o.isLiteral() || (language = (literal = (Literal)this.lexiconRelation.getTerm(o)).getLanguage()) == null || (languageOrdinal = this.languageFallbacks.get(language)) == null) continue;
                    if (languageOrdinal == bestLabelRank) {
                        this.bestLabels.add(o);
                    }
                    if (languageOrdinal < bestLabelRank) {
                        bestLabelRank = languageOrdinal;
                        this.bestLabels.clear();
                        this.bestLabels.add(o);
                    }
                    if (languageOrdinal != 0 || !uniqueType) continue;
                    break;
                }
            }
        }

        private boolean uniqueLabelType(IV labeltype) {
            return this.rdfsLabelIv().equals(labeltype) || this.descriptionIv().equals(labeltype);
        }

        private IV pickOrBuildBestLabel() {
            switch (this.bestLabels.size()) {
                case 1: {
                    return this.bestLabels.get(0);
                }
                case 0: {
                    return this.bestEffortLabel();
                }
            }
            return this.joinLabels();
        }

        private IV mock(Literal literal) {
            return BigdataValuesHelper.makeIV(this.lexiconRelation.getValueFactory(), literal);
        }

        private IV resolveToIvOrError(IValueExpression expression, String nameOfExpression) {
            Object resolved = expression.get(this.binding);
            if (resolved == null) {
                return null;
            }
            try {
                return (IV)resolved;
            }
            catch (ClassCastException e) {
                throw new RuntimeException(String.format(Locale.ROOT, "Expected %s (%s) to be bound to an IV but it wasn't.", nameOfExpression, expression), e);
            }
        }

        private IV rdfsLabelIv() {
            if (this.rdfsLabelIv == null) {
                this.rdfsLabelIv = this.tripleStore.getVocabulary().get((Value)RDFS.LABEL);
            }
            return this.rdfsLabelIv;
        }

        private IV descriptionIv() {
            if (this.descriptionIv == null) {
                this.descriptionIv = this.tripleStore.getVocabulary().get((Value)new URIImpl("http://schema.org/description"));
            }
            return this.descriptionIv;
        }

        private UrisScheme uris() {
            return UrisSchemeFactory.getURISystem();
        }

        private IV bestEffortLabel() {
            if (!this.rdfsLabelIv().equals(this.resolvedLabelType)) {
                return null;
            }
            BigdataValue value = this.resolvedSubject.asValue(this.lexiconRelation);
            String bestEffortLabel = value.stringValue();
            bestEffortLabel = this.uris().entityURItoId(bestEffortLabel);
            return this.mock((Literal)new LiteralImpl(bestEffortLabel));
        }

        private IV joinLabels() {
            StringBuilder b = new StringBuilder();
            String language = null;
            boolean first = true;
            for (IV label : this.bestLabels) {
                Literal literal = (Literal)this.lexiconRelation.getTerm(label);
                if (!first) {
                    b.append(", ");
                } else {
                    first = false;
                }
                b.append(literal.stringValue());
                if (language != null) continue;
                language = literal.getLanguage();
            }
            return this.mock((Literal)new LiteralImpl(b.toString(), language));
        }
    }

    static final class Resolution {
        private final IValueExpression subject;
        private final IValueExpression label;
        private final IVariable target;

        private Resolution(StatementPatternNode st) {
            this.subject = st.s().getValueExpression();
            this.label = st.p().getValueExpression();
            this.target = this.getVariableToBind(st);
        }

        public IValueExpression subject() {
            return this.subject;
        }

        public IValueExpression labelType() {
            return this.label;
        }

        public IVariable target() {
            return this.target;
        }

        private IVariable<IV> getVariableToBind(StatementPatternNode st) {
            try {
                return ((VarNode)st.o()).getValueExpression();
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Expected a variable in the object position to which to bind the language.", e);
            }
        }
    }

    private static class LabelServiceCall
    implements BigdataServiceCall {
        final ResolutionContext context;
        final List<Resolution> resolutions;

        LabelServiceCall(ResolutionContext context, List<Resolution> resolutions) {
            this.context = context;
            this.resolutions = resolutions;
        }

        public IServiceOptions getServiceOptions() {
            return SERVICE_OPTIONS;
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] bindingSets) throws Exception {
            return new Chunk(bindingSets);
        }

        private class Chunk
        implements ICloseableIterator<IBindingSet> {
            private final IBindingSet[] bindingSets;
            private boolean closed;
            private int i;

            Chunk(IBindingSet[] bindingSets) {
                this.bindingSets = bindingSets;
            }

            public boolean hasNext() {
                return !this.closed && this.i < this.bindingSets.length;
            }

            public IBindingSet next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IBindingSet binding = this.bindingSets[this.i++];
                LabelServiceCall.this.context.binding(binding);
                for (Resolution resolution : LabelServiceCall.this.resolutions) {
                    LabelServiceCall.this.context.resolve(resolution);
                }
                return binding;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void close() {
                this.closed = true;
            }
        }
    }
}

