/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.label;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.store.BD;
import java.util.ArrayList;
import org.wikidata.query.rdf.blazegraph.label.LabelService;
import org.wikidata.query.rdf.blazegraph.label.LabelServiceUtils;

public class LabelServiceExtractOptimizer
extends AbstractJoinGroupOptimizer {
    public static final String EXTRACTOR_ANNOTATION = LabelServiceExtractOptimizer.class.getName() + ".extractedStatements";

    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode op) {
        QueryRoot root = sa.getQueryRoot();
        if (root.getQueryType() == QueryType.ASK) {
            return;
        }
        LabelServiceUtils.getLabelServiceNodes(op).forEach(service -> {
            JoinGroupNode g = (JoinGroupNode)service.getGraphPattern();
            ArrayList<StatementPatternNode> extractedNodes = new ArrayList<StatementPatternNode>();
            for (BOp bOp : g.args()) {
                StatementPatternNode sn = (StatementPatternNode)bOp;
                if (sn.s().isConstant() && BD.SERVICE_PARAM.equals((Object)sn.s().getValue())) {
                    if (!LabelService.DISABLE_REORDERING.equals((Object)sn.p().getValue())) continue;
                    String flag = sn.o().getValue().stringValue();
                    service.annotations().put(LabelService.DISABLE_REORDERING_ANNOTATION, Boolean.valueOf(flag));
                    continue;
                }
                extractedNodes.add(sn);
            }
            for (BOp bOp : extractedNodes) {
                g.removeArg(bOp);
            }
            if (!extractedNodes.isEmpty()) {
                service.annotations().put(EXTRACTOR_ANNOTATION, extractedNodes);
            }
        });
    }
}

