/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.label;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryBase;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wikidata.query.rdf.blazegraph.label.LabelService;
import org.wikidata.query.rdf.blazegraph.label.LabelServiceUtils;

public class LabelServicePlacementOptimizer
extends AbstractJoinGroupOptimizer {
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode op) {
        LabelServiceUtils.getLabelServiceNodes(op).forEach(service -> {
            if (Boolean.TRUE.equals(service.annotations().get(LabelService.DISABLE_REORDERING_ANNOTATION))) {
                return;
            }
            this.processProjection((ServiceNode)service);
            op.removeChild((IGroupMemberNode)service);
            int lastJoinIndex = this.findLatestPossiblePositionForTheLabelServiceNode(sa, (BOp)service, op);
            op.addArg(lastJoinIndex + 1, (BOp)service);
        });
    }

    private int findLatestPossiblePositionForTheLabelServiceNode(StaticAnalysis sa, BOp serviceNode, JoinGroupNode joinGroup) {
        int lastJoinIndex = -1;
        Object inVarsObject = serviceNode.annotations().get("LabelService.inVars");
        Set inVars = inVarsObject instanceof Set ? (Set)inVarsObject : Collections.emptySet();
        for (int i = joinGroup.size() - 1; i >= 0; --i) {
            BOp child = joinGroup.get(i);
            if (child == serviceNode || !(child instanceof IBindingProducerNode) || !this.checkIfNodeProducesVars(sa, child, inVars)) continue;
            lastJoinIndex = i;
            break;
        }
        return lastJoinIndex;
    }

    private boolean checkIfNodeProducesVars(StaticAnalysis sa, BOp node, Set<IVariable<?>> projectedVars) {
        if (node == null) {
            return false;
        }
        if (node.args() != null) {
            for (BOp arg : node.args()) {
                if (!this.checkIfNodeProducesVars(sa, arg, projectedVars)) continue;
                return true;
            }
        }
        return this.checkIfSpecificNodeProducesVars(sa, node, projectedVars);
    }

    private boolean checkIfSpecificNodeProducesVars(StaticAnalysis sa, BOp node, Set<IVariable<?>> projectedVars) {
        if (node instanceof Var) {
            return projectedVars.contains(node);
        }
        if (node instanceof AssignmentNode) {
            return this.checkAssignmentNode((AssignmentNode)node, projectedVars);
        }
        if (node instanceof JoinGroupNode) {
            return this.checkJoinGroupNode(sa, (JoinGroupNode)node, projectedVars);
        }
        if (node instanceof ArbitraryLengthPathNode) {
            return this.checkArbitraryLengthPathNode(sa, (ArbitraryLengthPathNode)node, projectedVars);
        }
        if (node instanceof SubqueryBase) {
            return this.checkSubqueryBase(sa, (SubqueryBase)node, projectedVars);
        }
        if (node instanceof NamedSubqueryInclude) {
            return true;
        }
        if (node instanceof ServiceNode) {
            return this.checkServiceNode(sa, (ServiceNode)node, projectedVars);
        }
        return false;
    }

    private boolean checkServiceNode(StaticAnalysis sa, ServiceNode node, Set<IVariable<?>> projectedVars) {
        Set serviceVars = sa.getMaybeProducedBindings(node);
        for (IVariable serviceVar : serviceVars) {
            if (!this.checkIfNodeProducesVars(sa, (BOp)serviceVar, projectedVars)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSubqueryBase(StaticAnalysis sa, SubqueryBase node, Set<IVariable<?>> projectedVars) {
        return this.checkIfNodeProducesVars(sa, (BOp)node.getProjection(), projectedVars);
    }

    private boolean checkArbitraryLengthPathNode(StaticAnalysis sa, ArbitraryLengthPathNode node, Set<IVariable<?>> projectedVars) {
        TermNode left = node.left();
        TermNode right = node.right();
        return this.checkIfNodeProducesVars(sa, (BOp)left, projectedVars) || this.checkIfNodeProducesVars(sa, (BOp)right, projectedVars);
    }

    @SuppressFBWarnings(value={"OCP_OVERLY_CONCRETE_PARAMETER"}, justification="This function's purpose is to check JoinGroupNode instances only")
    private boolean checkJoinGroupNode(StaticAnalysis sa, JoinGroupNode node, Set<IVariable<?>> projectedVars) {
        for (BOp child : node) {
            if (!this.checkIfNodeProducesVars(sa, child, projectedVars)) continue;
            return true;
        }
        return false;
    }

    private boolean checkAssignmentNode(AssignmentNode node, Set<IVariable<?>> projectedVars) {
        if (projectedVars.contains(node.getVar())) {
            return true;
        }
        for (IVariable var : node.getConsumedVars()) {
            if (!projectedVars.contains(var)) continue;
            return true;
        }
        return false;
    }

    private void processProjection(ServiceNode serviceNode) {
        List<LabelService.Resolution> resolutions;
        if (serviceNode.getProjectedVars() == null && (resolutions = LabelService.findResolutions(serviceNode)).size() > 0) {
            HashSet<IVariable> inVars = new HashSet<IVariable>();
            HashSet<IVariable> outVars = new HashSet<IVariable>();
            for (LabelService.Resolution resolution : resolutions) {
                if (resolution.subject() instanceof IVariable) {
                    inVars.add((IVariable)resolution.subject());
                }
                outVars.add(resolution.target());
            }
            serviceNode.annotations().put("LabelService.inVars", inVars);
            serviceNode.annotations().put("LabelService.outVars", outVars);
            HashSet<IVariable> projectedVars = new HashSet<IVariable>(inVars);
            projectedVars.addAll(outVars);
            serviceNode.setProjectedVars(projectedVars);
        }
    }
}

