/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.mwapi;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import java.net.MalformedURLException;
import java.net.URL;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.wikidata.query.rdf.blazegraph.mwapi.ServiceConfig;

public abstract class Endpoint {
    public abstract String getEndpointURL(IBindingSet var1) throws MalformedURLException;

    public static Endpoint create(IVariableOrConstant term, ServiceConfig config) throws MalformedURLException {
        if (term.isConstant()) {
            return new ConstantEndpoint(Endpoint.getURLFromValue(config, (Value)((IV)term.get()).getValue()));
        }
        assert (term instanceof Var);
        return new VariableEndpoint(config, (Var)term);
    }

    private static String getURLFromValue(ServiceConfig config, Value v) throws MalformedURLException {
        String endpointHost = Endpoint.hostFromValue(v);
        if (!config.validEndpoint(endpointHost)) {
            throw new IllegalArgumentException("Host " + endpointHost + " is not allowed");
        }
        return new URL("https", endpointHost, "/w/api.php").toExternalForm();
    }

    private static String hostFromValue(Value v) throws MalformedURLException {
        if (v instanceof URI) {
            return new URL(v.stringValue()).getHost();
        }
        return v.stringValue();
    }

    private static class VariableEndpoint
    extends Endpoint {
        private final ServiceConfig config;
        private final Var endpoint;

        VariableEndpoint(ServiceConfig config, Var endpoint) {
            this.config = config;
            this.endpoint = endpoint;
        }

        @Override
        public String getEndpointURL(IBindingSet binding) throws MalformedURLException {
            IV boundValue = (IV)this.endpoint.get(binding);
            if (boundValue == null) {
                return null;
            }
            return Endpoint.getURLFromValue(this.config, (Value)boundValue.getValue());
        }
    }

    private static class ConstantEndpoint
    extends Endpoint {
        private final String endpoint;

        ConstantEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public String getEndpointURL(IBindingSet binding) {
            return this.endpoint;
        }
    }
}

