/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.mwapi;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MWApiLimits {
    @VisibleForTesting
    final int limitResults;
    @VisibleForTesting
    final int limitContinuations;
    @VisibleForTesting
    final int limitEmptyContinuations;
    private int results;
    private int continuations;
    private int emptyContinuations;

    public MWApiLimits(int limitResults, int limitContinuations, int limitEmptyContinuations) {
        this.limitResults = limitResults;
        this.limitContinuations = limitContinuations;
        this.limitEmptyContinuations = limitEmptyContinuations;
    }

    public boolean allowResult() {
        return this.results < this.limitResults;
    }

    public void haveResult() {
        this.emptyContinuations = 0;
        ++this.results;
    }

    public boolean allowContinuation() {
        return this.continuations < this.limitContinuations && this.emptyContinuations < this.limitEmptyContinuations;
    }

    public void haveContinuation() {
        ++this.continuations;
        ++this.emptyContinuations;
    }
}

