/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.mwapi;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.MockIVReturningServiceCall;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wikidata.query.rdf.blazegraph.BigdataValuesHelper;
import org.wikidata.query.rdf.blazegraph.mwapi.ApiTemplate;
import org.wikidata.query.rdf.blazegraph.mwapi.Endpoint;
import org.wikidata.query.rdf.blazegraph.mwapi.MWApiLimits;
import org.wikidata.query.rdf.blazegraph.mwapi.MWApiServiceFactory;
import org.xml.sax.SAXException;

@SuppressFBWarnings(value={"DMC_DUBIOUS_MAP_COLLECTION"}, justification="while inputVars could be implemented as a list, the maps makes semantic sense.")
public class MWApiServiceCall
implements MockIVReturningServiceCall,
BigdataServiceCall {
    private static final Logger log = LoggerFactory.getLogger(MWApiServiceCall.class);
    private static final String TIMEOUT_PROPERTY = MWApiServiceCall.class.getName() + ".timeout";
    private static final String TIMEOUT_MILLIS = "5000";
    private final ApiTemplate template;
    private final Map<String, IVariableOrConstant> inputVars;
    private final List<ApiTemplate.OutputVariable> outputVars;
    private final HttpClient client;
    private final LexiconRelation lexiconRelation;
    private final Endpoint endpoint;
    private final int requestTimeout;
    private final MWApiLimits limits;
    private final ThreadLocal<DocumentBuilder> docBuilder;
    private final ThreadLocal<XPath> xpath;
    private final Timer requestTimer;

    MWApiServiceCall(ApiTemplate template, Endpoint endpoint, Map<String, IVariableOrConstant> inputVars, List<ApiTemplate.OutputVariable> outputVars, HttpClient client, LexiconRelation lexiconRelation, Timer requestTimer, MWApiLimits limits) {
        this.template = template;
        this.endpoint = endpoint;
        this.inputVars = inputVars;
        this.outputVars = outputVars;
        this.client = client;
        this.lexiconRelation = lexiconRelation;
        this.requestTimer = requestTimer;
        this.requestTimeout = Integer.parseInt(System.getProperty(TIMEOUT_PROPERTY, TIMEOUT_MILLIS));
        this.limits = limits;
        this.docBuilder = ThreadLocal.withInitial(() -> {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                return dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                log.error("Could not configure parser", (Throwable)e);
                throw new IllegalStateException(e);
            }
        });
        this.xpath = ThreadLocal.withInitial(() -> XPathFactory.newInstance().newXPath());
    }

    public IServiceOptions getServiceOptions() {
        return MWApiServiceFactory.SERVICE_OPTIONS;
    }

    public ICloseableIterator<IBindingSet> call(IBindingSet[] bindingSets) {
        return new MultiSearchIterator(bindingSets);
    }

    public Map<String, String> getRequestParams(IBindingSet binding) {
        HashMap<String, String> params = new HashMap<String, String>(this.template.getFixedParams());
        for (Map.Entry<String, IVariableOrConstant> term : this.inputVars.entrySet()) {
            String value;
            IV boundValue = null;
            if (term.getValue() != null) {
                boundValue = (IV)term.getValue().get(binding);
            }
            if (boundValue == null) {
                value = this.template.getInputDefault(term.getKey());
                if (value != null && value.isEmpty()) {
                    continue;
                }
            } else {
                value = boundValue.stringValue();
            }
            if (value == null) {
                if (!this.template.isRequiredParameter(term.getKey())) continue;
                throw new IllegalArgumentException("Could not find binding for parameter " + term.getKey());
            }
            params.put(term.getKey(), value);
        }
        return params;
    }

    private Request getHttpRequest(IBindingSet binding) {
        String endpointURL;
        try {
            endpointURL = this.endpoint.getEndpointURL(binding);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Bad endpoint URL", e);
        }
        if (endpointURL == null) {
            return null;
        }
        Request request = this.client.newRequest(endpointURL);
        request.method(HttpMethod.GET);
        request.param("format", "xml");
        this.getRequestParams(binding).forEach((arg_0, arg_1) -> ((Request)request).param(arg_0, arg_1));
        return request;
    }

    public List<IVariable<IV>> getMockVariables() {
        LinkedList<IVariable<IV>> externalVars = new LinkedList<IVariable<IV>>();
        for (ApiTemplate.OutputVariable v : this.outputVars) {
            externalVars.add((IVariable<IV>)v.getVar());
        }
        return externalVars;
    }

    @Nullable
    private ImmutableMap<String, String> parseContinue(Document doc, XPath xpathObject) {
        try {
            XPathExpression itemsXPath = xpathObject.compile("//api/continue");
            Node continueNode = (Node)itemsXPath.evaluate(doc, XPathConstants.NODE);
            if (continueNode == null) {
                return null;
            }
            NamedNodeMap continueAttrs = continueNode.getAttributes();
            if (continueAttrs.getLength() == 0) {
                return null;
            }
            ImmutableMap.Builder continueVars = new ImmutableMap.Builder();
            for (int i = 0; i < continueAttrs.getLength(); ++i) {
                Node node = continueAttrs.item(i);
                continueVars = continueVars.put((Object)node.getNodeName(), (Object)node.getNodeValue());
            }
            return continueVars.build();
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    public ResultWithContinue parseResponse(InputStream responseStream, IBindingSet binding, int recordsCount) throws SAXException, IOException, XPathExpressionException {
        if (this.outputVars.isEmpty()) {
            return null;
        }
        Document doc = this.docBuilder.get().parse(responseStream);
        XPath path = this.xpath.get();
        ImmutableMap<String, String> searchContinue = this.parseContinue(doc, path);
        XPathExpression itemsXPath = path.compile(this.template.getItemsPath());
        NodeList nodes = (NodeList)itemsXPath.evaluate(doc, XPathConstants.NODESET);
        IBindingSet[] results = new IBindingSet[nodes.getLength()];
        if (results.length == 0) {
            return new ResultWithContinue(results, searchContinue);
        }
        HashMap<ApiTemplate.OutputVariable, XPathExpression> compiledVars = new HashMap<ApiTemplate.OutputVariable, XPathExpression>();
        for (ApiTemplate.OutputVariable var : this.outputVars) {
            compiledVars.put(var, this.xpath.get().compile(var.getPath()));
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            results[i] = binding.copy(null);
            for (Map.Entry var : compiledVars.entrySet()) {
                IConstant constant;
                if (((ApiTemplate.OutputVariable)var.getKey()).isOrdinal()) {
                    constant = BigdataValuesHelper.makeConstant(this.lexiconRelation.getValueFactory(), i + recordsCount);
                    results[i].set(((ApiTemplate.OutputVariable)var.getKey()).getVar(), constant);
                    continue;
                }
                Node value = (Node)((XPathExpression)var.getValue()).evaluate(node, XPathConstants.NODE);
                if (value == null || value.getNodeValue() == null) continue;
                constant = ((ApiTemplate.OutputVariable)var.getKey()).isURI() ? BigdataValuesHelper.makeConstant(this.lexiconRelation.getValueFactory(), ((ApiTemplate.OutputVariable)var.getKey()).getURI(value.getNodeValue())) : BigdataValuesHelper.makeConstant(this.lexiconRelation.getValueFactory(), value.getNodeValue());
                results[i].set(((ApiTemplate.OutputVariable)var.getKey()).getVar(), constant);
            }
        }
        return new ResultWithContinue(results, searchContinue);
    }

    public static class ResultWithContinue {
        private final ImmutableMap<String, String> searchContinue;
        private final UnmodifiableIterator<IBindingSet> resultIterator;

        ResultWithContinue(IBindingSet[] searchResult, ImmutableMap<String, String> searchContinue) {
            this.searchContinue = searchContinue;
            this.resultIterator = Iterators.forArray((Object[])searchResult);
        }

        public Iterator<IBindingSet> getResultIterator() {
            return this.resultIterator;
        }

        public Map<String, String> getContinue() {
            return this.searchContinue;
        }
    }

    private class ContinueIterator
    implements ICloseableIterator<IBindingSet> {
        private boolean closed;
        private ResultWithContinue lastResult;
        private IBindingSet bindings;
        private int recordsCount;

        ContinueIterator(IBindingSet binding) {
            this.bindings = binding;
            this.lastResult = this.doSearchRequest(0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ResultWithContinue doSearchRequest(int currentRecordsCount) {
            Request req = MWApiServiceCall.this.getHttpRequest(this.bindings);
            if (req == null) {
                return null;
            }
            if (this.lastResult != null && this.lastResult.getContinue() != null) {
                this.lastResult.getContinue().forEach((arg_0, arg_1) -> ((Request)req).param(arg_0, arg_1));
            }
            try (MDC.MDCCloseable mdc = MDC.putCloseable((String)"mw-api-request", (String)req.getQuery());){
                Response response;
                log.debug("MWAPI REQUEST: {}", (Object)req.getQuery());
                InputStreamResponseListener listener = new InputStreamResponseListener();
                try (Timer.Context context = MWApiServiceCall.this.requestTimer.time();){
                    req.send((Response.CompleteListener)listener);
                    response = listener.get((long)MWApiServiceCall.this.requestTimeout, TimeUnit.MILLISECONDS);
                }
                if (response.getStatus() != 200) {
                    throw new RuntimeException("Bad response status: " + response.getStatus());
                }
                ResultWithContinue resultWithContinue = MWApiServiceCall.this.parseResponse(listener.getInputStream(), this.bindings, currentRecordsCount);
                return resultWithContinue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("MWAPI request failed", e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new RuntimeException("MWAPI request failed", e);
            }
            catch (IOException | XPathExpressionException | SAXException e) {
                throw new RuntimeException("Failed to parse response", e);
            }
        }

        public boolean hasNext() {
            if (this.closed || this.lastResult == null) {
                return false;
            }
            if (!MWApiServiceCall.this.limits.allowResult()) {
                return false;
            }
            return this.lastResult.getResultIterator().hasNext() || MWApiServiceCall.this.limits.allowContinuation() && this.lastResult.searchContinue != null;
        }

        public IBindingSet next() {
            if (!MWApiServiceCall.this.limits.allowResult()) {
                this.close();
            }
            if (this.closed || this.lastResult == null) {
                return null;
            }
            if (this.lastResult.getResultIterator().hasNext()) {
                MWApiServiceCall.this.limits.haveResult();
                ++this.recordsCount;
                return this.lastResult.getResultIterator().next();
            }
            if (this.lastResult.getContinue() != null && MWApiServiceCall.this.limits.allowContinuation()) {
                this.lastResult = this.doSearchRequest(this.recordsCount);
                MWApiServiceCall.this.limits.haveContinuation();
            }
            if (this.closed || this.lastResult == null) {
                return null;
            }
            if (this.lastResult.getResultIterator().hasNext()) {
                MWApiServiceCall.this.limits.haveResult();
                ++this.recordsCount;
                return this.lastResult.getResultIterator().next();
            }
            return null;
        }

        public void close() {
            this.closed = true;
        }
    }

    private class MultiSearchIterator
    implements ICloseableIterator<IBindingSet> {
        private final IBindingSet[] bindingSets;
        private boolean closed;
        private int i;
        private Iterator<IBindingSet> searchResult;

        MultiSearchIterator(IBindingSet[] bindingSets) {
            this.bindingSets = bindingSets;
            this.searchResult = this.doNextSearch();
        }

        public boolean hasNext() {
            if (this.closed) {
                return false;
            }
            if (this.searchResult == null) {
                return false;
            }
            if (this.searchResult.hasNext()) {
                return true;
            }
            this.searchResult = this.doNextSearch();
            if (this.searchResult == null) {
                return false;
            }
            return this.searchResult.hasNext();
        }

        private Iterator<IBindingSet> doNextSearch() {
            IBindingSet binding;
            ContinueIterator result;
            if (this.closed || this.bindingSets == null || this.i >= this.bindingSets.length) {
                this.searchResult = null;
                return null;
            }
            while (!(result = new ContinueIterator(binding = this.bindingSets[this.i++])).hasNext() && this.i < this.bindingSets.length) {
            }
            if (result.hasNext()) {
                return result;
            }
            return null;
        }

        public IBindingSet next() {
            if (this.closed || this.searchResult == null) {
                return null;
            }
            if (this.searchResult.hasNext()) {
                return this.searchResult.next();
            }
            this.searchResult = this.doNextSearch();
            if (this.searchResult == null || !this.searchResult.hasNext()) {
                return null;
            }
            return this.searchResult.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.closed = true;
        }
    }
}

