/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.mwapi;

import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactory;
import com.bigdata.rdf.sparql.ast.eval.ServiceParams;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.store.BD;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.blazegraph.mwapi.ApiTemplate;
import org.wikidata.query.rdf.blazegraph.mwapi.Endpoint;
import org.wikidata.query.rdf.blazegraph.mwapi.MWApiLimits;
import org.wikidata.query.rdf.blazegraph.mwapi.MWApiServiceCall;
import org.wikidata.query.rdf.blazegraph.mwapi.ServiceConfig;

public class MWApiServiceFactory
extends AbstractServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(MWApiServiceFactory.class);
    public static final BigdataNativeServiceOptions SERVICE_OPTIONS = new BigdataNativeServiceOptions();
    public static final URI SERVICE_KEY = new URIImpl("http://wikiba.se/ontology#mwapi");
    public static final URI API_KEY = new URIImpl("http://wikiba.se/ontology#api");
    public static final URI ENDPOINT_KEY = new URIImpl("http://wikiba.se/ontology#endpoint");
    public static final URI LIMIT_RESULTS_KEY = new URIImpl("http://wikiba.se/ontology#limit");
    public static final URI LIMIT_CONTINUATIONS_KEY = new URIImpl("http://wikiba.se/ontology#limitContinuations");
    public static final URI LIMIT_EMPTY_CONTINUATIONS_KEY = new URIImpl("http://wikiba.se/ontology#limitEmptyContinuations");
    public static final String MWAPI_NAMESPACE = "https://www.mediawiki.org/ontology#API/";
    public static final String CONFIG_DEFAULT = "mwservices.json";
    public static final String CONFIG_NAME = MWApiServiceFactory.class.getName() + ".config";
    public static final String CONFIG_FILE = System.getProperty(CONFIG_NAME, "mwservices.json");
    public static final String CONFIG_MAX_RESULTS = MWApiServiceCall.class.getName() + ".maxContinue";
    public static final String CONFIG_MAX_CONTINUATIONS = MWApiServiceCall.class.getName() + ".maxContinuation";
    public static final String CONFIG_MAX_EMPTY_CONTINUATIONS = MWApiServiceCall.class.getName() + ".maxEmptyContinuation";
    private final ServiceConfig config;
    private final Timer requestTimer;
    private final int maxResults;
    private final int maxContinuations;
    private final int maxEmptyContinuations;

    public MWApiServiceFactory(ServiceConfig config, Timer requestTimer) {
        this.config = config;
        this.requestTimer = requestTimer;
        this.maxResults = Integer.parseInt(System.getProperty(CONFIG_MAX_RESULTS, "10000"));
        this.maxContinuations = Integer.parseInt(System.getProperty(CONFIG_MAX_CONTINUATIONS, "1000"));
        this.maxEmptyContinuations = Integer.parseInt(System.getProperty(CONFIG_MAX_EMPTY_CONTINUATIONS, "1000"));
    }

    public IServiceOptions getServiceOptions() {
        return SERVICE_OPTIONS;
    }

    public static void register(Timer requestTimer) {
        ServiceRegistry reg = ServiceRegistry.getInstance();
        try {
            log.info("Loading MWAPI service configuration from {}", (Object)CONFIG_FILE);
            BufferedReader configReader = Files.newBufferedReader(Paths.get(CONFIG_FILE, new String[0]), StandardCharsets.UTF_8);
            ServiceConfig config = new ServiceConfig(configReader);
            reg.add(SERVICE_KEY, (ServiceFactory)new MWApiServiceFactory(config, requestTimer));
            log.info("Registered {} services.", (Object)config.size());
        }
        catch (IOException e) {
            log.warn("MW Service registration failed.", (Throwable)e);
            return;
        }
        reg.addWhitelistURL(SERVICE_KEY.toString());
    }

    public BigdataServiceCall create(ServiceCallCreateParams params, ServiceParams serviceParams) {
        ServiceNode serviceNode = params.getServiceNode();
        Objects.requireNonNull(serviceNode, "Missing service node?");
        try {
            ApiTemplate template = this.getServiceTemplate(serviceParams);
            return new MWApiServiceCall(template, this.getServiceHost(serviceParams), template.getInputVars(serviceParams), template.getOutputVars(serviceNode), params.getClientConnectionManager(), params.getTripleStore().getLexiconRelation(), this.requestTimer, this.getLimitsFromParams(serviceParams));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Bad endpoint URL", e);
        }
    }

    private ApiTemplate getServiceTemplate(ServiceParams serviceParams) {
        String templateName = serviceParams.getAsString(API_KEY);
        Objects.requireNonNull(templateName, "Service name (wikibase:api) should be supplied");
        serviceParams.clear(API_KEY);
        return this.config.getService(templateName);
    }

    private Endpoint getServiceHost(ServiceParams serviceParams) throws MalformedURLException {
        TermNode hostNode = serviceParams.get(ENDPOINT_KEY, null);
        Objects.requireNonNull(hostNode, "Service name (wikibase:endpoint) should be supplied");
        serviceParams.clear(ENDPOINT_KEY);
        return Endpoint.create(hostNode.getValueExpression(), this.config);
    }

    MWApiLimits getLimitsFromParams(ServiceParams serviceParams) {
        int limitResults = 0;
        int limitContinuations = this.getSettingFromParams(serviceParams, LIMIT_CONTINUATIONS_KEY, 0);
        int limitEmptyContinuations = this.getSettingFromParams(serviceParams, LIMIT_EMPTY_CONTINUATIONS_KEY, 25);
        TermNode limitResultsNode = serviceParams.get(LIMIT_RESULTS_KEY, null);
        if (limitResultsNode != null) {
            serviceParams.clear(LIMIT_RESULTS_KEY);
            String s = limitResultsNode.getValue().stringValue();
            if (s.equals("once")) {
                limitContinuations = 1;
            } else {
                limitResults = Integer.parseInt(s);
            }
        }
        return this.clampLimitsByConfig(limitResults, limitContinuations, limitEmptyContinuations);
    }

    private int getSettingFromParams(ServiceParams serviceParams, URI name, int defaultValue) {
        TermNode paramNode = serviceParams.get(name, null);
        if (paramNode != null) {
            serviceParams.clear(name);
            return Integer.parseInt(paramNode.getValue().stringValue());
        }
        return defaultValue;
    }

    private MWApiLimits clampLimitsByConfig(int limitResults, int limitContinuations, int limitEmptyContinuations) {
        if (limitResults <= 0 || limitResults > this.maxResults) {
            limitResults = this.maxResults;
        }
        if (limitContinuations <= 0 || limitContinuations > this.maxContinuations) {
            limitContinuations = this.maxContinuations;
        }
        if (limitEmptyContinuations <= 0 || limitEmptyContinuations > this.maxEmptyContinuations) {
            limitEmptyContinuations = this.maxEmptyContinuations;
        }
        return new MWApiLimits(limitResults, limitContinuations, limitEmptyContinuations);
    }

    public Set<IVariable<?>> getRequiredBound(ServiceNode serviceNode) {
        ServiceParams params = this.serviceParamsFromNode(serviceNode);
        ApiTemplate api = this.getServiceTemplate(params);
        Map<String, IVariableOrConstant> potentialVars = api.getInputVars(params);
        return (Set)potentialVars.entrySet().stream().filter(entry -> entry.getValue() != null && ((IVariableOrConstant)entry.getValue()).isVar()).map(entry -> (IVariable)entry.getValue()).collect(ImmutableSet.toImmutableSet());
    }

    private ServiceParams serviceParamsFromNode(ServiceNode serviceNode) {
        Objects.requireNonNull(serviceNode, "Service node is null?");
        GraphPatternGroup group = serviceNode.getGraphPattern();
        Objects.requireNonNull(group, "Group node is null?");
        ServiceParams serviceParams = new ServiceParams();
        for (IGroupMemberNode node : group) {
            StatementPatternNode sp;
            TermNode s;
            if (!(node instanceof StatementPatternNode) || !(s = (sp = (StatementPatternNode)node).s()).isConstant() || !BD.SERVICE_PARAM.equals((Object)s.getValue())) continue;
            if (sp.p().isVariable()) {
                throw new RuntimeException("not a valid service param triple pattern, predicate must be constant: " + sp);
            }
            URI param = (URI)sp.p().getValue();
            serviceParams.add(param, sp.o());
        }
        return serviceParams;
    }

    public static URI paramNameToURI(String name) {
        return new URIImpl(MWAPI_NAMESPACE + name);
    }
}

