/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.mwapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.wikidata.query.rdf.blazegraph.mwapi.ApiTemplate;

public class ServiceConfig {
    private final Map<String, ApiTemplate> serviceMap;
    private final List<String> endpoints;

    public ServiceConfig(Reader configReader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode mainNode = mapper.readTree(configReader);
        this.serviceMap = ServiceConfig.loadJSONConfig(mainNode.get("services"));
        this.endpoints = ServiceConfig.loadEndpoints(mainNode.get("endpoints"));
    }

    @VisibleForTesting
    public ServiceConfig() {
        this.serviceMap = Collections.emptyMap();
        this.endpoints = Collections.emptyList();
    }

    private static Map<String, ApiTemplate> loadJSONConfig(JsonNode node) {
        Objects.requireNonNull(node, "Must have services node");
        return (Map)Streams.stream((Iterator)node.fieldNames()).collect(ImmutableMap.toImmutableMap(fieldName -> fieldName, fieldName -> ApiTemplate.fromJSON(node.get(fieldName))));
    }

    private static List<String> loadEndpoints(JsonNode node) {
        Objects.requireNonNull(node, "Must have endpoints node");
        Preconditions.checkArgument((boolean)node.isArray(), (Object)"Endpoints config should be an array");
        return (List)Streams.stream((Iterator)node.elements()).map(JsonNode::asText).collect(ImmutableList.toImmutableList());
    }

    public ApiTemplate getService(String templateName) {
        Preconditions.checkArgument((boolean)this.serviceMap.containsKey(templateName), (Object)("Service name " + templateName + " not found in configuration"));
        return this.serviceMap.get(templateName);
    }

    public boolean validEndpoint(String endpointHost) {
        for (String allowedEndpoint : this.endpoints) {
            if (!endpointHost.endsWith(allowedEndpoint)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.serviceMap.size();
    }
}

