/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.throttling;

import com.google.common.cache.Cache;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.blazegraph.throttling.Throttler;
import org.wikidata.query.rdf.blazegraph.throttling.TimeAndErrorsState;

public class TimeAndErrorsThrottler<S extends TimeAndErrorsState>
extends Throttler<S> {
    private static final Logger log = LoggerFactory.getLogger(TimeAndErrorsThrottler.class);
    private final Duration requestTimeThreshold;

    public TimeAndErrorsThrottler(Duration requestTimeThreshold, Callable<S> createThrottlingState, Cache<Object, S> stateStore, String enableThrottlingIfHeader, String alwaysThrottleParam, Clock clock) {
        super(createThrottlingState, stateStore, enableThrottlingIfHeader, alwaysThrottleParam, clock);
        this.requestTimeThreshold = requestTimeThreshold;
    }

    public void success(Object bucket, HttpServletRequest request, Duration elapsed) {
        if (this.shouldBypassThrottling(request)) {
            return;
        }
        try {
            TimeAndErrorsState state = elapsed.compareTo(this.requestTimeThreshold) > 0 ? (TimeAndErrorsState)this.getState(bucket) : (TimeAndErrorsState)this.getStateIfPresent(bucket);
            if (state != null) {
                state.consumeTime(elapsed);
            }
        }
        catch (ExecutionException ee) {
            log.warn("Could not create throttling state", (Throwable)ee);
        }
    }

    public void failure(Object bucket, HttpServletRequest request, Duration elapsed) {
        if (this.shouldBypassThrottling(request)) {
            return;
        }
        try {
            TimeAndErrorsState state = (TimeAndErrorsState)this.getState(bucket);
            state.consumeError();
            state.consumeTime(elapsed);
        }
        catch (ExecutionException ee) {
            log.warn("Could not create throttling state", (Throwable)ee);
        }
    }

    @Override
    protected Instant internalThrottledUntil(Object bucket, HttpServletRequest request) {
        TimeAndErrorsState state = (TimeAndErrorsState)this.getStateIfPresent(bucket);
        if (state == null) {
            return Instant.MIN;
        }
        return state.throttledUntil();
    }
}

