/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.blazegraph.vocabulary;

import com.bigdata.rdf.vocab.BaseVocabularyDecl;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.wikidata.query.rdf.common.uri.UrisScheme;

public class WikibaseUrisVocabularyDecl
extends BaseVocabularyDecl {
    private static List<String> getUriList(UrisScheme uris, Collection<String> prefixes) {
        ImmutableList.Builder uriList = ImmutableList.builder();
        uriList.addAll((Iterable)uris.entityURIs());
        uris.entityInitials().forEach(s -> uriList.add((Object)uris.entityIdToURI(s)));
        uriList.add((Object)uris.statement());
        uriList.add((Object)uris.reference());
        uriList.add((Object)uris.value());
        for (String p : prefixes) {
            uriList.add((Object)(uris.property(p) + "P"));
        }
        return uriList.build();
    }

    public WikibaseUrisVocabularyDecl(UrisScheme uris, Collection<String> prefixes) {
        super(WikibaseUrisVocabularyDecl.getUriList(uris, prefixes).toArray());
    }
}

