/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.common;

import java.util.Locale;

public class WikibasePoint {
    private final String longitude;
    private final String latitude;
    private final String globe;
    public static final CoordinateOrder DEFAULT_ORDER = CoordinateOrder.LONG_LAT;

    public String getLongitude() {
        return this.longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public String getGlobe() {
        return this.globe;
    }

    public WikibasePoint(String literalString, CoordinateOrder coordOrder) {
        if (literalString.charAt(0) == '<') {
            int endURI = literalString.indexOf(62);
            if (endURI <= 2) {
                throw new IllegalArgumentException("Invalid format for the WKT value");
            }
            this.globe = literalString.substring(1, endURI);
            literalString = literalString.substring(endURI + 2);
        } else {
            this.globe = null;
        }
        literalString = literalString.trim();
        if (!literalString.toLowerCase(Locale.ROOT).startsWith("point(") || !literalString.endsWith(")")) {
            throw new IllegalArgumentException("Invalid format for the WKT value");
        }
        String[] coords = literalString.substring(6, literalString.length() - 1).split("[\\s,]");
        if (coords.length != 2) {
            throw new IllegalArgumentException("Invalid format for the WKT value");
        }
        if (coordOrder == CoordinateOrder.LAT_LONG) {
            this.latitude = coords[0];
            this.longitude = coords[1];
        } else {
            this.longitude = coords[0];
            this.latitude = coords[1];
        }
    }

    public WikibasePoint(String literalString) {
        this(literalString, DEFAULT_ORDER);
    }

    public WikibasePoint(String[] components, String globe, CoordinateOrder order) {
        if (order == CoordinateOrder.LAT_LONG) {
            this.latitude = components[0];
            this.longitude = components[1];
        } else {
            this.longitude = components[0];
            this.latitude = components[1];
        }
        this.globe = globe;
    }

    public WikibasePoint(String[] components, String globe) {
        this(components, globe, DEFAULT_ORDER);
    }

    public WikibasePoint(String[] components) {
        this(components, null, DEFAULT_ORDER);
    }

    public WikibasePoint(String[] components, CoordinateOrder order) {
        this(components, null, order);
    }

    public String toString() {
        return this.toOrder(DEFAULT_ORDER);
    }

    public String toOrder(CoordinateOrder order) {
        StringBuffer buf = new StringBuffer();
        if (this.globe != null) {
            buf.append("<");
            buf.append(this.globe);
            buf.append("> ");
        }
        buf.append("Point(");
        if (order == CoordinateOrder.LAT_LONG) {
            buf.append(this.latitude);
            buf.append(" ");
            buf.append(this.longitude);
        } else {
            buf.append(this.longitude);
            buf.append(" ");
            buf.append(this.latitude);
        }
        buf.append(")");
        return buf.toString();
    }

    public static enum CoordinateOrder {
        LAT_LONG,
        LONG_LAT;

        private CoordinateOrder other;

        public CoordinateOrder getOther() {
            return this.other;
        }

        static {
            CoordinateOrder.LAT_LONG.other = LONG_LAT;
            CoordinateOrder.LONG_LAT.other = LAT_LONG;
        }
    }
}

