/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.common.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.isomorphism.util.TokenBucket;
import org.isomorphism.util.TokenBuckets;

public class RateLimitFilter
extends Filter<ILoggingEvent> {
    private TokenBucket bucket;
    private int bucketCapacity = 100;
    private Duration refillInterval = Duration.of(1L, ChronoUnit.SECONDS);

    public RateLimitFilter() {
        this.bucket = RateLimitFilter.createBucket(this.bucketCapacity, this.refillInterval);
    }

    public void setBucketCapacity(int bucketCapacity) {
        this.bucketCapacity = bucketCapacity;
        this.bucket = RateLimitFilter.createBucket(bucketCapacity, this.refillInterval);
    }

    public void setRefillIntervalInMillis(long refillIntervalInMillis) {
        this.refillInterval = Duration.ofMillis(refillIntervalInMillis);
        this.bucket = RateLimitFilter.createBucket(this.bucketCapacity, this.refillInterval);
    }

    private static TokenBucket createBucket(int bucketCapacity, Duration refillInterval) {
        return TokenBuckets.builder().withCapacity((long)bucketCapacity).withFixedIntervalRefillStrategy((long)bucketCapacity, refillInterval.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public FilterReply decide(ILoggingEvent event) {
        if (this.bucket.tryConsume()) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }
}

