/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.bitvector;

import cern.colt.PersistentObject;
import cern.colt.bitvector.BitVector;
import cern.colt.bitvector.QuickBitVector;
import cern.colt.function.IntIntProcedure;
import java.awt.Rectangle;

public class BitMatrix
extends PersistentObject {
    protected int columns;
    protected int rows;
    protected long[] bits;

    public BitMatrix(int columns, int rows) {
        this.elements(QuickBitVector.makeBitVector(columns * rows, 1), columns, rows);
    }

    public void and(BitMatrix other) {
        this.checkDimensionCompatibility(other);
        this.toBitVector().and(other.toBitVector());
    }

    public void andNot(BitMatrix other) {
        this.checkDimensionCompatibility(other);
        this.toBitVector().andNot(other.toBitVector());
    }

    public int cardinality() {
        return this.toBitVector().cardinality();
    }

    protected void checkDimensionCompatibility(BitMatrix other) {
        if (this.columns != other.columns() || this.rows != other.rows()) {
            throw new IllegalArgumentException("Incompatible dimensions: (columns,rows)=(" + this.columns + "," + this.rows + "), (other.columns,other.rows)=(" + other.columns() + "," + other.rows() + ")");
        }
    }

    public void clear() {
        this.toBitVector().clear();
    }

    public Object clone() {
        BitMatrix clone = (BitMatrix)super.clone();
        if (this.bits != null) {
            clone.bits = (long[])this.bits.clone();
        }
        return clone;
    }

    public int columns() {
        return this.columns;
    }

    protected void containsBox(int column, int row, int width, int height) {
        if (column < 0 || column + width > this.columns || row < 0 || row + height > this.rows) {
            throw new IndexOutOfBoundsException("column:" + column + ", row:" + row + " ,width:" + width + ", height:" + height);
        }
    }

    public BitMatrix copy() {
        return (BitMatrix)this.clone();
    }

    protected long[] elements() {
        return this.bits;
    }

    protected void elements(long[] bits, int columns, int rows) {
        if (columns < 0 || columns < 0 || columns * rows > bits.length * 64) {
            throw new IllegalArgumentException();
        }
        this.bits = bits;
        this.columns = columns;
        this.rows = rows;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BitMatrix)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BitMatrix other = (BitMatrix)obj;
        if (this.columns != other.columns() || this.rows != other.rows()) {
            return false;
        }
        return this.toBitVector().equals(other.toBitVector());
    }

    public boolean forEachCoordinateInState(boolean state, IntIntProcedure procedure) {
        if (this.size() == 0) {
            return true;
        }
        BitVector vector = new BitVector(this.bits, this.size());
        long[] theBits = this.bits;
        int column = this.columns - 1;
        int row = this.rows - 1;
        long val = theBits[this.bits.length - 1];
        int j = vector.numberOfBitsInPartialUnit();
        while (--j >= 0) {
            long mask = val & 1L << j;
            if ((state && mask != 0L || !state && mask == 0L) && !procedure.apply(column, row)) {
                return false;
            }
            if (--column >= 0) continue;
            column = this.columns - 1;
            --row;
        }
        int bitsPerUnit = 64;
        long comparator = state ? 0L : -1L;
        int i = vector.numberOfFullUnits();
        while (--i >= 0) {
            int j2;
            val = theBits[i];
            if (val != comparator) {
                if (state) {
                    j2 = 64;
                    while (--j2 >= 0) {
                        if ((val & 1L << j2) != 0L && !procedure.apply(column, row)) {
                            return false;
                        }
                        if (--column >= 0) continue;
                        column = this.columns - 1;
                        --row;
                    }
                    continue;
                }
                j2 = 64;
                while (--j2 >= 0) {
                    if ((val & 1L << j2) == 0L && !procedure.apply(column, row)) {
                        return false;
                    }
                    if (--column >= 0) continue;
                    column = this.columns - 1;
                    --row;
                }
                continue;
            }
            if ((column -= 64) >= 0) continue;
            column += 64;
            j2 = 64;
            while (--j2 >= 0) {
                if (--column >= 0) continue;
                column = this.columns - 1;
                --row;
            }
        }
        return true;
    }

    public boolean get(int column, int row) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("column:" + column + ", row:" + row);
        }
        return QuickBitVector.get(this.bits, row * this.columns + column);
    }

    public boolean getQuick(int column, int row) {
        return QuickBitVector.get(this.bits, row * this.columns + column);
    }

    public int hashCode() {
        return this.toBitVector().hashCode();
    }

    public void not() {
        this.toBitVector().not();
    }

    public void or(BitMatrix other) {
        this.checkDimensionCompatibility(other);
        this.toBitVector().or(other.toBitVector());
    }

    public BitMatrix part(int column, int row, int width, int height) {
        if (column < 0 || column + width > this.columns || row < 0 || row + height > this.rows) {
            throw new IndexOutOfBoundsException("column:" + column + ", row:" + row + " ,width:" + width + ", height:" + height);
        }
        if (width <= 0 || height <= 0) {
            return new BitMatrix(0, 0);
        }
        BitMatrix subMatrix = new BitMatrix(width, height);
        subMatrix.replaceBoxWith(0, 0, width, height, this, column, row);
        return subMatrix;
    }

    public void put(int column, int row, boolean value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("column:" + column + ", row:" + row);
        }
        QuickBitVector.put(this.bits, row * this.columns + column, value);
    }

    public void putQuick(int column, int row, boolean value) {
        QuickBitVector.put(this.bits, row * this.columns + column, value);
    }

    public void replaceBoxWith(int column, int row, int width, int height, BitMatrix source, int sourceColumn, int sourceRow) {
        Rectangle sourceRect;
        Rectangle destRect;
        this.containsBox(column, row, width, height);
        source.containsBox(sourceColumn, sourceRow, width, height);
        if (width <= 0 || height <= 0) {
            return;
        }
        if (source == this && (destRect = new Rectangle(column, row, width, height)).intersects(sourceRect = new Rectangle(sourceColumn, sourceRow, width, height))) {
            source = source.copy();
        }
        BitVector sourceVector = source.toBitVector();
        BitVector destVector = this.toBitVector();
        int sourceColumns = source.columns();
        while (--height >= 0) {
            int offset = row * this.columns + column;
            int sourceOffset = sourceRow * sourceColumns + sourceColumn;
            destVector.replaceFromToWith(offset, offset + width - 1, sourceVector, sourceOffset);
            ++row;
            ++sourceRow;
        }
    }

    public void replaceBoxWith(int column, int row, int width, int height, boolean value) {
        this.containsBox(column, row, width, height);
        if (width <= 0 || height <= 0) {
            return;
        }
        BitVector destVector = this.toBitVector();
        while (--height >= 0) {
            int offset = row * this.columns + column;
            destVector.replaceFromToWith(offset, offset + width - 1, value);
            ++row;
        }
    }

    public int rows() {
        return this.rows;
    }

    public int size() {
        return this.columns * this.rows;
    }

    public BitVector toBitVector() {
        return new BitVector(this.bits, this.size());
    }

    public String toString() {
        return this.toBitVector().toString();
    }

    public void xor(BitMatrix other) {
        this.checkDimensionCompatibility(other);
        this.toBitVector().xor(other.toBitVector());
    }
}

