/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.IntProcedure;
import cern.colt.list.AbstractIntList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class IntArrayList
extends AbstractIntList {
    protected int[] elements;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int[] elements) {
        this.elements(elements);
    }

    public IntArrayList(int initialCapacity) {
        this(new int[initialCapacity]);
        this.setSizeRaw(0);
    }

    public void add(int element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    public void beforeInsert(int index, int element) {
        if (this.size == index) {
            this.add(element);
            return;
        }
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    public int binarySearchFromTo(int key, int from, int to) {
        return Sorting.binarySearchFromTo(this.elements, key, from, to);
    }

    public Object clone() {
        IntArrayList clone = new IntArrayList((int[])this.elements.clone());
        clone.setSizeRaw(this.size);
        return clone;
    }

    public IntArrayList copy() {
        return (IntArrayList)this.clone();
    }

    protected void countSortFromTo(int from, int to, int min, int max) {
        if (this.size == 0) {
            return;
        }
        IntArrayList.checkRangeFromTo(from, to, this.size);
        int width = max - min + 1;
        int[] counts = new int[width];
        int[] theElements = this.elements;
        int i = from;
        while (i <= to) {
            int n = theElements[i++] - min;
            counts[n] = counts[n] + 1;
        }
        int fromIndex = from;
        int val = min;
        int i2 = 0;
        while (i2 < width) {
            int c = counts[i2];
            if (c > 0) {
                if (c == 1) {
                    theElements[fromIndex++] = val;
                } else {
                    int toIndex = fromIndex + c - 1;
                    this.fillFromToWith(fromIndex, toIndex, val);
                    fromIndex = toIndex + 1;
                }
            }
            ++i2;
            ++val;
        }
    }

    public int[] elements() {
        return this.elements;
    }

    public AbstractIntList elements(int[] elements) {
        this.elements = elements;
        this.size = elements.length;
        return this;
    }

    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof IntArrayList)) {
            return super.equals(otherObj);
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        IntArrayList other = (IntArrayList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        int[] theElements = this.elements();
        int[] otherElements = other.elements();
        int i = this.size();
        while (--i >= 0) {
            if (theElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(IntProcedure procedure) {
        int[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    public int get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    public int getQuick(int index) {
        return this.elements[index];
    }

    public int indexOfFromTo(int element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        IntArrayList.checkRangeFromTo(from, to, this.size);
        int[] theElements = this.elements;
        for (int i = from; i <= to; ++i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfFromTo(int element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        IntArrayList.checkRangeFromTo(from, to, this.size);
        int[] theElements = this.elements;
        for (int i = to; i >= from; --i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    public AbstractIntList partFromTo(int from, int to) {
        if (this.size == 0) {
            return new IntArrayList(0);
        }
        IntArrayList.checkRangeFromTo(from, to, this.size);
        int[] part = new int[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new IntArrayList(part);
    }

    public boolean removeAll(AbstractIntList other) {
        double M;
        if (!(other instanceof IntArrayList)) {
            return super.removeAll(other);
        }
        if (other.size() == 0) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        int[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            IntArrayList sortedList = (IntArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    public void replaceFromToWithFrom(int from, int to, AbstractIntList other, int otherFrom) {
        if (!(other instanceof IntArrayList)) {
            super.replaceFromToWithFrom(from, to, other, otherFrom);
            return;
        }
        int length = to - from + 1;
        if (length > 0) {
            IntArrayList.checkRangeFromTo(from, to, this.size());
            IntArrayList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            System.arraycopy(((IntArrayList)other).elements, otherFrom, this.elements, from, length);
        }
    }

    public boolean retainAll(AbstractIntList other) {
        double M;
        if (!(other instanceof IntArrayList)) {
            return super.retainAll(other);
        }
        int limit = other.size() - 1;
        int j = 0;
        int[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            IntArrayList sortedList = (IntArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        int[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            int tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    public void set(int index, int element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    public void setQuick(int index, int element) {
        this.elements[index] = element;
    }

    public void shuffleFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        IntArrayList.checkRangeFromTo(from, to, this.size);
        Uniform gen = new Uniform(new DRand(new Date()));
        int[] theElements = this.elements;
        for (int i = from; i < to; ++i) {
            int random = gen.nextIntFromTo(i, to);
            int tmpElement = theElements[random];
            theElements[random] = theElements[i];
            theElements[i] = tmpElement;
        }
    }

    public void sortFromTo(int from, int to) {
        int widthThreshold = 10000;
        if (this.size == 0) {
            return;
        }
        IntArrayList.checkRangeFromTo(from, to, this.size);
        int min = this.elements[from];
        int max = this.elements[from];
        int[] theElements = this.elements;
        int i = from + 1;
        while (i <= to) {
            int elem;
            if ((elem = theElements[i++]) > max) {
                max = elem;
                continue;
            }
            if (elem >= min) continue;
            min = elem;
        }
        double N = (double)to - (double)from + 1.0;
        double quickSortEstimate = N * Math.log(N) / 0.6931471805599453;
        double width = (double)max - (double)min + 1.0;
        double countSortEstimate = Math.max(width, N);
        if (width < 10000.0 && countSortEstimate < quickSortEstimate) {
            this.countSortFromTo(from, to, min, max);
        } else {
            this.quickSortFromTo(from, to);
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

