/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.LongProcedure;
import cern.colt.list.AbstractLongList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class LongArrayList
extends AbstractLongList {
    protected long[] elements;

    public LongArrayList() {
        this(10);
    }

    public LongArrayList(long[] elements) {
        this.elements(elements);
    }

    public LongArrayList(int initialCapacity) {
        this(new long[initialCapacity]);
        this.setSizeRaw(0);
    }

    public void add(long element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    public void beforeInsert(int index, long element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    public int binarySearchFromTo(long key, int from, int to) {
        return Sorting.binarySearchFromTo(this.elements, key, from, to);
    }

    public Object clone() {
        LongArrayList clone = new LongArrayList((long[])this.elements.clone());
        clone.setSizeRaw(this.size);
        return clone;
    }

    public LongArrayList copy() {
        return (LongArrayList)this.clone();
    }

    protected void countSortFromTo(int from, int to, long min, long max) {
        if (this.size == 0) {
            return;
        }
        LongArrayList.checkRangeFromTo(from, to, this.size);
        int width = (int)(max - min + 1L);
        int[] counts = new int[width];
        long[] theElements = this.elements;
        int i = from;
        while (i <= to) {
            int n = (int)(theElements[i++] - min);
            counts[n] = counts[n] + 1;
        }
        int fromIndex = from;
        long val = min;
        int i2 = 0;
        while (i2 < width) {
            int c = counts[i2];
            if (c > 0) {
                if (c == 1) {
                    theElements[fromIndex++] = val;
                } else {
                    int toIndex = fromIndex + c - 1;
                    this.fillFromToWith(fromIndex, toIndex, val);
                    fromIndex = toIndex + 1;
                }
            }
            ++i2;
            ++val;
        }
    }

    public long[] elements() {
        return this.elements;
    }

    public AbstractLongList elements(long[] elements) {
        this.elements = elements;
        this.size = elements.length;
        return this;
    }

    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof LongArrayList)) {
            return super.equals(otherObj);
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        LongArrayList other = (LongArrayList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        long[] theElements = this.elements();
        long[] otherElements = other.elements();
        int i = this.size();
        while (--i >= 0) {
            if (theElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(LongProcedure procedure) {
        long[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    public long get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    public long getQuick(int index) {
        return this.elements[index];
    }

    public int indexOfFromTo(long element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        LongArrayList.checkRangeFromTo(from, to, this.size);
        long[] theElements = this.elements;
        for (int i = from; i <= to; ++i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfFromTo(long element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        LongArrayList.checkRangeFromTo(from, to, this.size);
        long[] theElements = this.elements;
        for (int i = to; i >= from; --i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    public AbstractLongList partFromTo(int from, int to) {
        if (this.size == 0) {
            return new LongArrayList(0);
        }
        LongArrayList.checkRangeFromTo(from, to, this.size);
        long[] part = new long[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new LongArrayList(part);
    }

    public boolean removeAll(AbstractLongList other) {
        double M;
        if (!(other instanceof LongArrayList)) {
            return super.removeAll(other);
        }
        if (other.size() == 0) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        long[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            LongArrayList sortedList = (LongArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    public void replaceFromToWithFrom(int from, int to, AbstractLongList other, int otherFrom) {
        if (!(other instanceof LongArrayList)) {
            super.replaceFromToWithFrom(from, to, other, otherFrom);
            return;
        }
        int length = to - from + 1;
        if (length > 0) {
            LongArrayList.checkRangeFromTo(from, to, this.size());
            LongArrayList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            System.arraycopy(((LongArrayList)other).elements, otherFrom, this.elements, from, length);
        }
    }

    public boolean retainAll(AbstractLongList other) {
        double M;
        if (!(other instanceof LongArrayList)) {
            return super.retainAll(other);
        }
        int limit = other.size() - 1;
        int j = 0;
        long[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            LongArrayList sortedList = (LongArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        long[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            long tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    public void set(int index, long element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    public void setQuick(int index, long element) {
        this.elements[index] = element;
    }

    public void shuffleFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        LongArrayList.checkRangeFromTo(from, to, this.size);
        Uniform gen = new Uniform(new DRand(new Date()));
        long[] theElements = this.elements;
        for (int i = from; i < to; ++i) {
            int random = gen.nextIntFromTo(i, to);
            long tmpElement = theElements[random];
            theElements[random] = theElements[i];
            theElements[i] = tmpElement;
        }
    }

    public void sortFromTo(int from, int to) {
        int widthThreshold = 10000;
        if (this.size == 0) {
            return;
        }
        LongArrayList.checkRangeFromTo(from, to, this.size);
        long min = this.elements[from];
        long max = this.elements[from];
        long[] theElements = this.elements;
        int i = from + 1;
        while (i <= to) {
            long elem;
            if ((elem = theElements[i++]) > max) {
                max = elem;
                continue;
            }
            if (elem >= min) continue;
            min = elem;
        }
        double N = (double)to - (double)from + 1.0;
        double quickSortEstimate = N * Math.log(N) / 0.6931471805599453;
        double width = (double)max - (double)min + 1.0;
        double countSortEstimate = Math.max(width, N);
        if (width < 10000.0 && countSortEstimate < quickSortEstimate) {
            this.countSortFromTo(from, to, min, max);
        } else {
            this.quickSortFromTo(from, to);
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

