/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.bitvector.BitVector;
import cern.colt.bitvector.QuickBitVector;
import cern.colt.list.AbstractLongList;
import cern.jet.math.Arithmetic;

public class MinMaxNumberList
extends AbstractLongList {
    protected long minValue;
    protected int bitsPerElement;
    protected long[] bits;
    protected int capacity;

    public MinMaxNumberList(long minimum, long maximum, int initialCapacity) {
        this.setUp(minimum, maximum, initialCapacity);
    }

    public void add(long element) {
        if (this.size == this.capacity) {
            this.ensureCapacity(this.size + 1);
        }
        int i = this.size * this.bitsPerElement;
        QuickBitVector.putLongFromTo(this.bits, element - this.minValue, i, i + this.bitsPerElement - 1);
        ++this.size;
    }

    public void addAllOfFromTo(long[] elements, int from, int to) {
        int bitsPerElem = this.bitsPerElement;
        int bitsPerElemMinusOne = bitsPerElem - 1;
        long min = this.minValue;
        long[] theBits = this.bits;
        this.ensureCapacity(this.size + to - from + 1);
        int firstBit = this.size * bitsPerElem;
        int i = from;
        int times = to - from + 1;
        while (--times >= 0) {
            QuickBitVector.putLongFromTo(theBits, elements[i++] - min, firstBit, firstBit + bitsPerElemMinusOne);
            firstBit += bitsPerElem;
        }
        this.size += to - from + 1;
    }

    public int bitsPerElement() {
        return this.bitsPerElement;
    }

    public static int bitsPerElement(long minimum, long maximum) {
        int bits = 1L + maximum - minimum > 0L ? (int)Math.round(Math.ceil(Arithmetic.log(2.0, 1L + maximum - minimum))) : 64;
        return bits;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.capacity;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            BitVector vector = this.toBitVector();
            vector.setSize(newCapacity * this.bitsPerElement);
            this.bits = vector.elements();
            this.capacity = newCapacity;
        }
    }

    public long getQuick(int index) {
        int i = index * this.bitsPerElement;
        return this.minValue + QuickBitVector.getLongFromTo(this.bits, i, i + this.bitsPerElement - 1);
    }

    public void partFromTo(int from, int to, BitVector qualificants, int qualificantsFrom, long[] part, int partFrom) {
        int width = to - from + 1;
        if (from < 0 || from > to || to >= this.size || qualificantsFrom < 0 || qualificants != null && qualificantsFrom + width > qualificants.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (partFrom < 0 || partFrom + width > part.length) {
            throw new IndexOutOfBoundsException();
        }
        long minVal = this.minValue;
        int bitsPerElem = this.bitsPerElement;
        long[] theBits = this.bits;
        int q = qualificantsFrom;
        int p = partFrom;
        int j = from * bitsPerElem;
        int i = from;
        while (i <= to) {
            if (qualificants == null || qualificants.get(q)) {
                part[p] = minVal + QuickBitVector.getLongFromTo(theBits, j, j + bitsPerElem - 1);
            }
            ++i;
            ++q;
            ++p;
            j += bitsPerElem;
        }
    }

    public void setQuick(int index, long element) {
        int i = index * this.bitsPerElement;
        QuickBitVector.putLongFromTo(this.bits, element - this.minValue, i, i + this.bitsPerElement - 1);
    }

    protected void setSizeRaw(int newSize) {
        super.setSizeRaw(newSize);
    }

    protected void setUp(long minimum, long maximum, int initialCapacity) {
        this.setUpBitsPerEntry(minimum, maximum);
        this.bits = QuickBitVector.makeBitVector(initialCapacity, this.bitsPerElement);
        this.capacity = initialCapacity;
        this.size = 0;
    }

    protected void setUpBitsPerEntry(long minimum, long maximum) {
        this.bitsPerElement = MinMaxNumberList.bitsPerElement(minimum, maximum);
        this.minValue = this.bitsPerElement != 64 ? minimum : 0L;
    }

    public BitVector toBitVector() {
        return new BitVector(this.bits, this.capacity * this.bitsPerElement);
    }

    public void trimToSize() {
        int oldCapacity = this.capacity;
        if (this.size < oldCapacity) {
            BitVector vector = this.toBitVector();
            vector.setSize(this.size);
            this.bits = vector.elements();
            this.capacity = this.size;
        }
    }

    public long xminimum() {
        return this.minValue;
    }
}

