/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.DoubleIntProcedure;
import cern.colt.function.DoubleProcedure;
import cern.colt.function.IntComparator;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractDoubleIntMap
extends AbstractMap {
    protected AbstractDoubleIntMap() {
    }

    public boolean containsKey(final double key) {
        return !this.forEachKey(new DoubleProcedure(){

            public boolean apply(double iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final int value) {
        return !this.forEachPair(new DoubleIntProcedure(){

            public boolean apply(double iterKey, int iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractDoubleIntMap copy() {
        return (AbstractDoubleIntMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractDoubleIntMap)) {
            return false;
        }
        final AbstractDoubleIntMap other = (AbstractDoubleIntMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new DoubleIntProcedure(){

            public boolean apply(double key, int value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new DoubleIntProcedure(){

            public boolean apply(double key, int value) {
                return AbstractDoubleIntMap.this.containsKey(key) && AbstractDoubleIntMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(DoubleProcedure var1);

    public boolean forEachPair(final DoubleIntProcedure procedure) {
        return this.forEachKey(new DoubleProcedure(){

            public boolean apply(double key) {
                return procedure.apply(key, AbstractDoubleIntMap.this.get(key));
            }
        });
    }

    public abstract int get(double var1);

    public double keyOf(final int value) {
        final double[] foundKey = new double[1];
        boolean notFound = this.forEachPair(new DoubleIntProcedure(){

            public boolean apply(double iterKey, int iterValue) {
                boolean found;
                boolean bl = found = value == iterValue;
                if (found) {
                    foundKey[0] = iterKey;
                }
                return !found;
            }
        });
        if (notFound) {
            return Double.NaN;
        }
        return foundKey[0];
    }

    public DoubleArrayList keys() {
        DoubleArrayList list = new DoubleArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final DoubleArrayList list) {
        list.clear();
        this.forEachKey(new DoubleProcedure(){

            public boolean apply(double key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(DoubleArrayList keyList) {
        this.pairsSortedByValue(keyList, new IntArrayList(this.size()));
    }

    public void pairsMatching(final DoubleIntProcedure condition, final DoubleArrayList keyList, final IntArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new DoubleIntProcedure(){

            public boolean apply(double key, int value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(DoubleArrayList keyList, IntArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(DoubleArrayList keyList, IntArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final double[] k = keyList.elements();
        final int[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                int t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                double t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(double var1, int var3);

    public abstract boolean removeKey(double var1);

    public String toString() {
        DoubleArrayList theKeys = this.keys();
        theKeys.sort();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            double key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toStringByValue() {
        DoubleArrayList theKeys = new DoubleArrayList();
        this.keysSortedByValue(theKeys);
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            double key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public IntArrayList values() {
        IntArrayList list = new IntArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final IntArrayList list) {
        list.clear();
        this.forEachKey(new DoubleProcedure(){

            public boolean apply(double key) {
                list.add(AbstractDoubleIntMap.this.get(key));
                return true;
            }
        });
    }
}

