/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntObjectMap;
import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.SelectedSparseObjectMatrix1D;
import cern.colt.matrix.impl.SparseObjectMatrix2D;

public class SparseObjectMatrix1D
extends ObjectMatrix1D {
    protected AbstractIntObjectMap elements;

    public SparseObjectMatrix1D(Object[] values) {
        this(values.length);
        this.assign(values);
    }

    public SparseObjectMatrix1D(int size) {
        this(size, size / 1000, 0.2, 0.5);
    }

    public SparseObjectMatrix1D(int size, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(size);
        this.elements = new OpenIntObjectHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseObjectMatrix1D(int size, AbstractIntObjectMap elements, int offset, int stride) {
        this.setUp(size, offset, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    public Object getQuick(int index) {
        return this.elements.get(this.zero + index * this.stride);
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D other) {
        if (other instanceof SelectedSparseObjectMatrix1D) {
            SelectedSparseObjectMatrix1D otherMatrix = (SelectedSparseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseObjectMatrix1D) {
            SparseObjectMatrix1D otherMatrix = (SparseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected int index(int rank) {
        return this.zero + rank * this.stride;
    }

    public ObjectMatrix1D like(int size) {
        return new SparseObjectMatrix1D(size);
    }

    public ObjectMatrix2D like2D(int rows, int columns) {
        return new SparseObjectMatrix2D(rows, columns);
    }

    public void setQuick(int index, Object value) {
        int i = this.zero + index * this.stride;
        if (value == null) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected ObjectMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseObjectMatrix1D(this.elements, offsets);
    }
}

