/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.lang;

import it.unimi.dsi.fastutil.chars.Char2CharMap;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharList;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.util.TextPattern;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.io.Writer;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableString
implements Serializable,
CharSequence,
Appendable,
Comparable<MutableString>,
Cloneable {
    private static final MutableString NULL = new MutableString("null");
    protected transient char[] array;
    protected transient int hashLength;
    public static final long serialVersionUID = -518929984008928417L;

    public MutableString() {
        this(2);
    }

    public MutableString(int capacity) {
        this.array = capacity != 0 ? new char[capacity] : CharArrays.EMPTY_ARRAY;
    }

    private void makeCompactMutableString(int length) {
        this.array = length != 0 ? new char[length] : CharArrays.EMPTY_ARRAY;
        this.hashLength = -1;
    }

    public MutableString(MutableString s) {
        this.makeCompactMutableString(s.length());
        System.arraycopy(s.array, 0, this.array, 0, this.array.length);
    }

    public MutableString(String s) {
        this.makeCompactMutableString(s.length());
        s.getChars(0, this.array.length, this.array, 0);
    }

    public MutableString(CharSequence s) {
        this.makeCompactMutableString(s.length());
        MutableString.getChars(s, 0, this.array.length, this.array, 0);
    }

    public MutableString(char[] a) {
        this.makeCompactMutableString(a.length);
        System.arraycopy(a, 0, this.array, 0, this.array.length);
    }

    public MutableString(char[] a, int offset, int len) {
        this.makeCompactMutableString(len);
        System.arraycopy(a, offset, this.array, 0, len);
    }

    public MutableString copy() {
        return new MutableString(this);
    }

    public Object clone() {
        return new MutableString(this);
    }

    public static void getChars(CharSequence s, int start, int end, char[] dest, int destStart) {
        int j = destStart;
        int i = start;
        while (i < end) {
            dest[j++] = s.charAt(i++);
        }
    }

    @Override
    public final int length() {
        return this.hashLength >= 0 ? this.hashLength : this.array.length;
    }

    public final int capacity() {
        return this.array.length;
    }

    public final char[] array() {
        return this.array;
    }

    public final void getChars(int start, int end, char[] dest, int destStart) {
        if (end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.array, start, dest, destStart, end - start);
    }

    public final MutableString ensureCapacity(int minimumCapacity) {
        int length = this.length();
        this.expand(minimumCapacity);
        if (length < minimumCapacity) {
            this.hashLength = length;
        }
        return this;
    }

    private void expand(int minimumCapacity) {
        int c;
        int n = c = this.array == null ? 0 : this.array.length;
        if (minimumCapacity <= c && this.array != null) {
            return;
        }
        int length = this.hashLength >= 0 ? this.hashLength : c;
        char[] newArray = new char[this.hashLength >= 0 && c * 2 > minimumCapacity ? c * 2 : minimumCapacity];
        if (length != 0) {
            System.arraycopy(this.array, 0, newArray, 0, length);
        }
        this.array = newArray;
    }

    private void setCapacity(int capacity) {
        int c = this.array.length;
        if (capacity == c) {
            return;
        }
        int length = this.hashLength >= 0 ? this.hashLength : c;
        char[] newArray = capacity != 0 ? new char[capacity] : CharArrays.EMPTY_ARRAY;
        System.arraycopy(this.array, 0, newArray, 0, length < capacity ? length : capacity);
        this.array = newArray;
    }

    public final MutableString length(int newLength) {
        if (newLength < 0) {
            throw new IllegalArgumentException("Negative length (" + newLength + ")");
        }
        if (this.hashLength < 0) {
            if (this.array.length == newLength) {
                return this;
            }
            this.hashLength = -1;
            this.setCapacity(newLength);
        } else {
            int length = this.hashLength;
            if (newLength == length) {
                return this;
            }
            if (newLength > this.array.length) {
                this.expand(newLength);
            } else if (newLength > length) {
                Arrays.fill(this.array, length, newLength, '\u0000');
            }
            this.hashLength = newLength;
        }
        return this;
    }

    public final MutableString setLength(int newLength) {
        return this.length(newLength);
    }

    public final MutableString compact() {
        if (this.hashLength >= 0) {
            this.setCapacity(this.hashLength);
            this.hashLength = -1;
        }
        return this;
    }

    public final MutableString loose() {
        if (this.hashLength < 0) {
            this.hashLength = this.array.length;
        }
        return this;
    }

    public final boolean isCompact() {
        return this.hashLength < 0;
    }

    public final boolean isLoose() {
        return this.hashLength >= 0;
    }

    public final MutableString changed() {
        if (this.hashLength < 0) {
            this.hashLength = -1;
        }
        return this;
    }

    public static MutableString wrap(char[] a) {
        MutableString s = new MutableString(0);
        s.array = a;
        s.hashLength = -1;
        return s;
    }

    public static MutableString wrap(char[] a, int length) {
        MutableString s = new MutableString(0);
        s.array = a;
        s.hashLength = length;
        return s;
    }

    @Override
    public final char charAt(int index) {
        if (index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.array[index];
    }

    public final MutableString setCharAt(int index, char c) {
        this.charAt(index, c);
        return this;
    }

    public final MutableString charAt(int index, char c) {
        if (index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.array[index] = c;
        this.changed();
        return this;
    }

    public final char firstChar() {
        if (this.length() == 0) {
            throw new StringIndexOutOfBoundsException(0);
        }
        return this.array[0];
    }

    public final char lastChar() {
        return this.array[this.length() - 1];
    }

    public final char[] toCharArray() {
        return CharArrays.copy(this.array, 0, this.length());
    }

    public final MutableString substring(int start, int end) {
        if (end > this.length()) {
            throw new StringIndexOutOfBoundsException(end);
        }
        return new MutableString(this.array, start, end - start);
    }

    public final MutableString substring(int start) {
        return this.substring(start, this.length());
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        if (start > end || end > this.length()) {
            throw new StringIndexOutOfBoundsException();
        }
        return new SubSequence(start, end);
    }

    public final MutableString append(MutableString s) {
        int l;
        if (s == null) {
            s = NULL;
        }
        if ((l = s.length()) == 0) {
            return this;
        }
        int newLength = this.length() + l;
        this.expand(newLength);
        System.arraycopy(s.array, 0, this.array, newLength - l, l);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString append(String s) {
        if (s == null) {
            return this.append(NULL);
        }
        int l = s.length();
        if (l == 0) {
            return this;
        }
        int newLength = this.length() + l;
        this.expand(newLength);
        s.getChars(0, l, this.array, newLength - l);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    @Override
    public final MutableString append(CharSequence s) {
        if (s == null) {
            return this.append(NULL);
        }
        int l = s.length();
        if (l == 0) {
            return this;
        }
        int newLength = this.length() + l;
        this.expand(newLength);
        MutableString.getChars(s, 0, l, this.array, newLength - l);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    @Override
    public final MutableString append(CharSequence s, int start, int end) {
        if (s == null) {
            return this.append(NULL, start, end);
        }
        int len = end - start;
        if (len < 0 || start < 0 || end > s.length()) {
            throw new IndexOutOfBoundsException("start: " + start + " end: " + end + " length():" + s.length());
        }
        int newLength = this.length() + len;
        this.expand(newLength);
        try {
            MutableString.getChars(s, start, end, this.array, newLength - len);
        }
        catch (IndexOutOfBoundsException e) {
            if (this.hashLength < 0) {
                this.setCapacity(newLength - len);
            } else {
                this.hashLength = newLength - len;
            }
            throw e;
        }
        if (len != 0) {
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        }
        return this;
    }

    public final MutableString append(CharSequence[] a, int offset, int length, CharSequence separator) {
        ObjectArrays.ensureOffsetLength(a, offset, length);
        if (length == 0) {
            return this;
        }
        int m = 0;
        for (int i = 0; i < length; ++i) {
            m += a[offset + i].length();
        }
        int separatorLength = separator.length();
        int l = this.length();
        this.ensureCapacity(l + (m += (length - 1) * separatorLength));
        m = 0;
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                MutableString.getChars(separator, 0, separatorLength, this.array, l + m);
                m += separatorLength;
            }
            MutableString.getChars(a[i], 0, a[i + offset].length(), this.array, l + m);
            m += a[i].length();
        }
        this.hashLength = this.hashLength < 0 ? -1 : l + m;
        return this;
    }

    public final MutableString append(CharSequence[] a, CharSequence separator) {
        return this.append(a, 0, a.length, separator);
    }

    public final MutableString append(Object[] a, int offset, int length, CharSequence separator) {
        CharSequence[] s = new String[a.length];
        for (int i = 0; i < length; ++i) {
            s[i] = a[offset + i].toString();
        }
        return this.append(s, offset, length, separator);
    }

    public final MutableString append(Object[] a, CharSequence separator) {
        return this.append(a, 0, a.length, separator);
    }

    public final MutableString append(char[] a) {
        int l = a.length;
        if (l == 0) {
            return this;
        }
        int newLength = this.length() + l;
        this.expand(newLength);
        System.arraycopy(a, 0, this.array, newLength - l, l);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString append(char[] a, int offset, int len) {
        int newLength = this.length() + len;
        this.expand(newLength);
        try {
            System.arraycopy(a, offset, this.array, newLength - len, len);
        }
        catch (IndexOutOfBoundsException e) {
            if (this.hashLength < 0) {
                this.setCapacity(newLength - len);
            } else {
                this.hashLength = newLength - len;
            }
            throw e;
        }
        if (len != 0) {
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        }
        return this;
    }

    public final MutableString append(CharList list) {
        int l = list.size();
        if (l == 0) {
            return this;
        }
        int newLength = this.length() + l;
        this.expand(newLength);
        list.getElements(0, this.array, newLength - l, l);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString append(CharList list, int offset, int len) {
        int newLength = this.length() + len;
        this.expand(newLength);
        try {
            list.getElements(offset, this.array, newLength - len, len);
        }
        catch (IndexOutOfBoundsException e) {
            if (this.hashLength < 0) {
                this.setCapacity(newLength - len);
            } else {
                this.hashLength = newLength - len;
            }
            throw e;
        }
        if (len != 0) {
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        }
        return this;
    }

    public final MutableString append(boolean b) {
        return this.append(String.valueOf(b));
    }

    @Override
    public final MutableString append(char c) {
        int newLength = this.length() + 1;
        this.expand(newLength);
        this.array[newLength - 1] = c;
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString append(int i) {
        return this.append(String.valueOf(i));
    }

    public final MutableString append(long l) {
        return this.append(String.valueOf(l));
    }

    public final MutableString append(float f) {
        return this.append(String.valueOf(f));
    }

    public final MutableString append(double d) {
        return this.append(String.valueOf(d));
    }

    public final MutableString append(Object o) {
        return this.append(String.valueOf(o));
    }

    public final MutableString insert(int index, MutableString s) {
        int length = this.length();
        if (index > length) {
            throw new StringIndexOutOfBoundsException();
        }
        int l = s.length();
        if (l == 0) {
            return this;
        }
        int newLength = length + l;
        this.expand(newLength);
        System.arraycopy(this.array, index, this.array, index + l, length - index);
        System.arraycopy(s.array, 0, this.array, index, l);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString insert(int index, String s) {
        int length = this.length();
        if (index > length) {
            throw new StringIndexOutOfBoundsException();
        }
        int l = s.length();
        if (l == 0) {
            return this;
        }
        int newLength = length + l;
        this.expand(newLength);
        System.arraycopy(this.array, index, this.array, index + l, length - index);
        s.getChars(0, l, this.array, index);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString insert(int index, CharSequence s) {
        int length = this.length();
        if (index > length) {
            throw new StringIndexOutOfBoundsException();
        }
        int l = s.length();
        if (l == 0) {
            return this;
        }
        int newLength = length + l;
        if (newLength >= this.array.length) {
            this.expand(newLength);
        }
        System.arraycopy(this.array, index, this.array, index + l, length - index);
        MutableString.getChars(s, 0, l, this.array, index);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString insert(int index, char[] c) {
        int length = this.length();
        if (index > length) {
            throw new StringIndexOutOfBoundsException();
        }
        int l = c.length;
        if (l == 0) {
            return this;
        }
        int newLength = length + l;
        this.expand(newLength);
        System.arraycopy(this.array, index, this.array, index + l, length - index);
        System.arraycopy(c, 0, this.array, index, l);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString insert(int index, char[] c, int offset, int len) {
        int length = this.length();
        if (index > length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (offset < 0 || offset + len < 0 || offset + len > c.length) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (len == 0) {
            return this;
        }
        int newLength = length + len;
        this.expand(newLength);
        System.arraycopy(this.array, index, this.array, index + len, length - index);
        System.arraycopy(c, offset, this.array, index, len);
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString insert(int index, boolean b) {
        return this.insert(index, String.valueOf(b));
    }

    public final MutableString insert(int index, char c) {
        return this.insert(index, String.valueOf(c));
    }

    public final MutableString insert(int index, double d) {
        return this.insert(index, String.valueOf(d));
    }

    public final MutableString insert(int index, float f) {
        return this.insert(index, String.valueOf(f));
    }

    public final MutableString insert(int index, int x) {
        return this.insert(index, String.valueOf(x));
    }

    public final MutableString insert(int index, long l) {
        return this.insert(index, String.valueOf(l));
    }

    public final MutableString insert(int index, Object o) {
        return this.insert(index, String.valueOf(o));
    }

    public final MutableString delete(int start, int end) {
        int length = this.length();
        if (end > length) {
            end = length;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int l = end - start;
        if (l > 0) {
            System.arraycopy(this.array, start + l, this.array, start, length - end);
            if (this.hashLength < 0) {
                this.setCapacity(length - l);
                this.hashLength = -1;
            } else {
                this.hashLength -= l;
            }
        }
        return this;
    }

    public final MutableString deleteCharAt(int index) {
        int length = this.length();
        if (index >= length) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.array, index + 1, this.array, index, length - index - 1);
        if (this.hashLength < 0) {
            this.setCapacity(length - 1);
            this.hashLength = -1;
        } else {
            --this.hashLength;
        }
        return this;
    }

    public final MutableString delete(char c) {
        int length = this.length();
        char[] a = this.array;
        int l = 0;
        for (int i = 0; i < length; ++i) {
            if (a[i] == c) continue;
            a[l++] = a[i];
        }
        if (l != length) {
            if (this.hashLength < 0) {
                this.hashLength = -1;
                this.array = CharArrays.trim(this.array, l);
            } else {
                this.hashLength = l;
            }
        }
        return this;
    }

    public final MutableString delete(CharSet s) {
        int length = this.length();
        char[] a = this.array;
        int l = 0;
        for (int i = 0; i < length; ++i) {
            if (s.contains(a[i])) continue;
            a[l++] = a[i];
        }
        if (l != length) {
            if (this.hashLength < 0) {
                this.hashLength = -1;
                this.array = CharArrays.trim(this.array, l);
            } else {
                this.hashLength = l;
            }
        }
        return this;
    }

    public final MutableString delete(char[] c) {
        int length;
        int n = c.length;
        if (n == 0) {
            return this;
        }
        char[] a = this.array;
        int i = length = this.length();
        int bloomFilter = 0;
        int k = n;
        while (k-- != 0) {
            bloomFilter |= 1 << (c[k] & 0x1F);
        }
        int l = 0;
        for (i = 0; i < length; ++i) {
            if ((bloomFilter & 1 << (a[i] & 0x1F)) != 0) {
                k = n;
                while (k-- != 0 && a[i] != c[k]) {
                }
                if (k >= 0) continue;
            }
            a[l++] = a[i];
        }
        if (l != length) {
            if (this.hashLength < 0) {
                this.hashLength = -1;
                this.array = CharArrays.trim(this.array, l);
            } else {
                this.hashLength = l;
            }
        }
        return this;
    }

    public final MutableString replace(int start, int end, MutableString s) {
        int length = this.length();
        if (end > length) {
            end = length;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int l = s.length();
        int newLength = length + l - end + start;
        if (l == 0 && newLength == length) {
            return this;
        }
        if (newLength >= length) {
            this.expand(newLength);
            System.arraycopy(this.array, end, this.array, start + l, length - end);
            System.arraycopy(s.array, 0, this.array, start, l);
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        } else {
            System.arraycopy(this.array, end, this.array, start + l, length - end);
            System.arraycopy(s.array, 0, this.array, start, l);
            if (this.hashLength < 0) {
                this.setCapacity(newLength);
                this.hashLength = -1;
            } else {
                this.hashLength = newLength;
            }
        }
        return this;
    }

    public final MutableString replace(int start, int end, String s) {
        int length = this.length();
        if (end > length) {
            end = length;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int l = s.length();
        int newLength = length + l - end + start;
        if (l == 0 && newLength == length) {
            return this;
        }
        if (newLength >= length) {
            this.expand(newLength);
            System.arraycopy(this.array, end, this.array, start + l, length - end);
            s.getChars(0, l, this.array, start);
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        } else {
            System.arraycopy(this.array, end, this.array, start + l, length - end);
            s.getChars(0, l, this.array, start);
            if (this.hashLength < 0) {
                this.setCapacity(newLength);
                this.hashLength = -1;
            } else {
                this.hashLength = newLength;
            }
        }
        return this;
    }

    public final MutableString replace(int start, int end, CharSequence s) {
        int length = this.length();
        if (end > length) {
            end = length;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int l = s.length();
        int newLength = length + l - end + start;
        if (l == 0 && newLength == length) {
            return this;
        }
        if (newLength >= length) {
            this.expand(newLength);
            System.arraycopy(this.array, end, this.array, start + l, length - end);
            MutableString.getChars(s, 0, l, this.array, start);
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        } else {
            System.arraycopy(this.array, end, this.array, start + l, length - end);
            MutableString.getChars(s, 0, l, this.array, start);
            if (this.hashLength < 0) {
                this.setCapacity(newLength);
                this.hashLength = -1;
            } else {
                this.hashLength = newLength;
            }
        }
        return this;
    }

    public final MutableString replace(int start, int end, char c) {
        int length = this.length();
        if (end > length) {
            end = length;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int newLength = length + 1 - end + start;
        if (newLength >= length) {
            this.expand(newLength);
            System.arraycopy(this.array, end, this.array, start + 1, length - end);
            this.array[start] = c;
            this.hashLength = this.hashLength < 0 ? -1 : newLength;
        } else {
            System.arraycopy(this.array, end, this.array, start + 1, length - end);
            this.array[start] = c;
            if (this.hashLength < 0) {
                this.setCapacity(newLength);
                this.hashLength = -1;
            } else {
                this.hashLength = newLength;
            }
        }
        return this;
    }

    public final MutableString replace(MutableString s) {
        return this.replace(0, Integer.MAX_VALUE, s);
    }

    public final MutableString replace(String s) {
        return this.replace(0, Integer.MAX_VALUE, s);
    }

    public final MutableString replace(CharSequence s) {
        return this.replace(0, Integer.MAX_VALUE, s);
    }

    public final MutableString replace(char c) {
        return this.replace(0, Integer.MAX_VALUE, c);
    }

    public final MutableString replace(char[] c, MutableString[] s) {
        int n = c.length;
        if (n == 0) {
            return this;
        }
        int length = this.length();
        char[] a = this.array;
        int newLength = length;
        int bloomFilter = 0;
        int k = n;
        while (k-- != 0) {
            bloomFilter |= 1 << (c[k] & 0x1F);
            if (s[k].length() != 0) continue;
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i = length;
        boolean found = false;
        while (i-- != 0) {
            if ((bloomFilter & 1 << (a[i] & 0x1F)) == 0) continue;
            k = n;
            while (k-- != 0 && a[i] != c[k]) {
            }
            if (k < 0) continue;
            newLength += s[k].length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a = this.array;
        i = newLength;
        int j = length;
        while (j-- != 0) {
            if ((bloomFilter & 1 << (a[j] & 0x1F)) != 0) {
                k = n;
                while (k-- != 0 && a[j] != c[k]) {
                }
                if (k >= 0) {
                    int l = s[k].length();
                    System.arraycopy(s[k].array, 0, this.array, i -= l, l);
                    continue;
                }
            }
            a[--i] = a[j];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char[] c, String[] s) {
        int n = c.length;
        if (n == 0) {
            return this;
        }
        int length = this.length();
        char[] a = this.array;
        int newLength = length;
        int bloomFilter = 0;
        int k = n;
        while (k-- != 0) {
            bloomFilter |= 1 << (c[k] & 0x1F);
            if (s[k].length() != 0) continue;
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i = length;
        boolean found = false;
        while (i-- != 0) {
            if ((bloomFilter & 1 << (a[i] & 0x1F)) == 0) continue;
            k = n;
            while (k-- != 0 && a[i] != c[k]) {
            }
            if (k < 0) continue;
            newLength += s[k].length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a = this.array;
        i = newLength;
        int j = length;
        while (j-- != 0) {
            if ((bloomFilter & 1 << (a[j] & 0x1F)) != 0) {
                k = n;
                while (k-- != 0 && a[j] != c[k]) {
                }
                if (k >= 0) {
                    int l = s[k].length();
                    MutableString.getChars(s[k], 0, l, this.array, i -= l);
                    continue;
                }
            }
            a[--i] = a[j];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char[] c, CharSequence[] s) {
        int n = c.length;
        if (n == 0) {
            return this;
        }
        int length = this.length();
        char[] a = this.array;
        int newLength = length;
        int bloomFilter = 0;
        int k = n;
        while (k-- != 0) {
            bloomFilter |= 1 << (c[k] & 0x1F);
            if (s[k].length() != 0) continue;
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i = length;
        boolean found = false;
        while (i-- != 0) {
            if ((bloomFilter & 1 << (a[i] & 0x1F)) == 0) continue;
            k = n;
            while (k-- != 0 && a[i] != c[k]) {
            }
            if (k < 0) continue;
            newLength += s[k].length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a = this.array;
        i = newLength;
        int j = length;
        while (j-- != 0) {
            if ((bloomFilter & 1 << (a[j] & 0x1F)) != 0) {
                k = n;
                while (k-- != 0 && a[j] != c[k]) {
                }
                if (k >= 0) {
                    int l = s[k].length();
                    MutableString.getChars(s[k], 0, l, this.array, i -= l);
                    continue;
                }
            }
            a[--i] = a[j];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char[] c, char[] r) {
        int n = c.length;
        if (n == 0) {
            return this;
        }
        char[] a = this.array;
        int i = this.length();
        int bloomFilter = 0;
        int k = n;
        while (k-- != 0) {
            bloomFilter |= 1 << (c[k] & 0x1F);
        }
        while (i-- != 0) {
            if ((bloomFilter & 1 << (a[i] & 0x1F)) == 0) continue;
            k = n;
            while (k-- != 0 && a[i] != c[k]) {
            }
            if (k < 0) continue;
            a[i] = r[k];
        }
        if (this.hashLength < 0) {
            this.hashLength = -1;
        }
        return this;
    }

    public final MutableString replace(Char2CharMap m) {
        int length = this.length();
        char[] a = this.array;
        boolean found = false;
        for (int i = 0; i < length; ++i) {
            if (!m.containsKey(a[i])) continue;
            a[i] = m.get(a[i]);
            found = true;
        }
        if (found && this.hashLength < 0) {
            this.hashLength = -1;
        }
        return this;
    }

    public final MutableString replace(char c, MutableString s) {
        int length = this.length();
        char[] a = this.array;
        int newLength = length;
        if (s.length() == 0) {
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i = length;
        boolean found = false;
        while (i-- != 0) {
            if (a[i] != c) continue;
            newLength += s.length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a = this.array;
        i = newLength;
        int j = length;
        while (j-- != 0) {
            if (a[j] == c) {
                int l = s.length();
                System.arraycopy(s.array, 0, a, i -= l, l);
                continue;
            }
            a[--i] = a[j];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char c, String s) {
        int length = this.length();
        char[] a = this.array;
        int newLength = length;
        if (s.length() == 0) {
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i = length;
        boolean found = false;
        while (i-- != 0) {
            if (a[i] != c) continue;
            newLength += s.length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a = this.array;
        i = newLength;
        int j = length;
        while (j-- != 0) {
            if (a[j] == c) {
                int l = s.length();
                s.getChars(0, l, this.array, i -= l);
                continue;
            }
            a[--i] = a[j];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char c, CharSequence s) {
        int length = this.length();
        char[] a = this.array;
        int newLength = length;
        if (s.length() == 0) {
            throw new IllegalArgumentException("You cannot use the empty string as a replacement");
        }
        int i = length;
        boolean found = false;
        while (i-- != 0) {
            if (a[i] != c) continue;
            newLength += s.length() - 1;
            found = true;
        }
        if (!found) {
            return this;
        }
        this.expand(newLength);
        a = this.array;
        i = newLength;
        int j = length;
        while (j-- != 0) {
            if (a[j] == c) {
                int l = s.length();
                MutableString.getChars(s, 0, l, this.array, i -= l);
                continue;
            }
            a[--i] = a[j];
        }
        this.hashLength = this.hashLength < 0 ? -1 : newLength;
        return this;
    }

    public final MutableString replace(char c, char r) {
        int i = this.length();
        char[] a = this.array;
        while (i-- != 0) {
            if (a[i] != c) continue;
            a[i] = r;
        }
        this.changed();
        return this;
    }

    public final MutableString replace(MutableString s, MutableString r) {
        int length = this.length();
        int ns = s.length();
        int nr = r.length();
        if (ns == 0) {
            if (nr == 0) {
                return this;
            }
            throw new IllegalArgumentException("You cannot replace the empty string with a nonempty string");
        }
        char[] ar = r.array;
        char[] as = s.array;
        int bloomFilter = MutableString.buildFilter(s, ns);
        int diff = ns - nr;
        if (diff >= 0) {
            char[] a = this.array;
            int i = this.indexOf(as, ns, 0, bloomFilter);
            if (i != -1) {
                System.arraycopy(ar, 0, a, i, nr);
                int j = i + nr;
                int l = diff;
                while ((i = this.indexOf(as, ns, i + ns, bloomFilter)) != -1) {
                    if (diff != 0) {
                        System.arraycopy(a, j + l, a, j, i - j - l);
                    }
                    j = i + ns - (l += diff);
                    System.arraycopy(ar, 0, a, j - nr, nr);
                }
                if (diff != 0) {
                    System.arraycopy(a, j + l, a, j, length - l - j);
                }
                l = length - l;
                if (this.hashLength < 0) {
                    this.hashLength = -1;
                    if (diff != 0) {
                        char[] newArray = new char[l];
                        System.arraycopy(a, 0, newArray, 0, l);
                        this.array = newArray;
                    }
                } else {
                    this.hashLength = l;
                }
            }
        } else {
            int j = 0;
            int i = length;
            while ((i = this.lastIndexOf(as, ns, i - ns, bloomFilter)) != -1) {
                ++j;
            }
            if (j != 0) {
                int l;
                int m = l = length + j * -diff;
                this.expand(m);
                char[] a = this.array;
                i = j = length;
                while ((i = this.lastIndexOf(as, ns, i - ns, bloomFilter)) != -1) {
                    System.arraycopy(a, i + ns, a, l -= j - i - ns, j - i - ns);
                    System.arraycopy(ar, 0, a, l -= nr, nr);
                    j = i;
                }
                this.hashLength = this.hashLength < 0 ? -1 : m;
            }
        }
        return this;
    }

    public final MutableString replace(String s, String r) {
        int length = this.length();
        int ns = s.length();
        int nr = r.length();
        if (ns == 0) {
            if (nr == 0) {
                return this;
            }
            throw new IllegalArgumentException("You cannot replace the empty string with a nonempty string");
        }
        int bloomFilter = MutableString.buildFilter(s, ns);
        int diff = ns - nr;
        if (diff >= 0) {
            char[] a = this.array;
            int i = this.indexOf(s, ns, 0, bloomFilter);
            if (i != -1) {
                r.getChars(0, nr, a, i);
                int j = i + nr;
                int l = diff;
                while ((i = this.indexOf(s, ns, i + ns, bloomFilter)) != -1) {
                    if (diff != 0) {
                        System.arraycopy(a, j + l, a, j, i - j - l);
                    }
                    j = i + ns - (l += diff);
                    r.getChars(0, nr, a, j - nr);
                }
                if (diff != 0) {
                    System.arraycopy(a, j + l, a, j, length - l - j);
                }
                l = length - l;
                if (this.hashLength < 0) {
                    this.hashLength = -1;
                    if (diff != 0) {
                        char[] newArray = new char[l];
                        System.arraycopy(a, 0, newArray, 0, l);
                        this.array = newArray;
                    }
                } else {
                    this.hashLength = l;
                }
            }
        } else {
            int j = 0;
            int i = length;
            while ((i = this.lastIndexOf(s, ns, i - ns, bloomFilter)) != -1) {
                ++j;
            }
            if (j != 0) {
                int l;
                int m = l = length + j * -diff;
                this.expand(m);
                char[] a = this.array;
                i = j = length;
                while ((i = this.lastIndexOf(s, ns, i - ns, bloomFilter)) != -1) {
                    System.arraycopy(a, i + ns, a, l -= j - i - ns, j - i - ns);
                    r.getChars(0, nr, a, l -= nr);
                    j = i;
                }
                this.hashLength = this.hashLength < 0 ? -1 : m;
            }
        }
        return this;
    }

    public final MutableString replace(CharSequence s, CharSequence r) {
        int length = this.length();
        int ns = s.length();
        int nr = r.length();
        if (ns == 0) {
            if (nr == 0) {
                return this;
            }
            throw new IllegalArgumentException("You cannot replace the empty string with a nonempty string");
        }
        int bloomFilter = MutableString.buildFilter(s, ns);
        int diff = ns - nr;
        if (diff >= 0) {
            char[] a = this.array;
            int i = this.indexOf(s, ns, 0, bloomFilter);
            if (i != -1) {
                MutableString.getChars(r, 0, nr, a, i);
                int j = i + nr;
                int l = diff;
                while ((i = this.indexOf(s, ns, i + ns, bloomFilter)) != -1) {
                    if (diff != 0) {
                        System.arraycopy(a, j + l, a, j, i - j - l);
                    }
                    j = i + ns - (l += diff);
                    MutableString.getChars(r, 0, nr, a, j - nr);
                }
                if (diff != 0) {
                    System.arraycopy(a, j + l, a, j, length - l - j);
                }
                l = length - l;
                if (this.hashLength < 0) {
                    this.hashLength = -1;
                    if (diff != 0) {
                        char[] newArray = new char[l];
                        System.arraycopy(a, 0, newArray, 0, l);
                        this.array = newArray;
                    }
                } else {
                    this.hashLength = l;
                }
            }
        } else {
            int j = 0;
            int i = length;
            while ((i = this.lastIndexOf(s, ns, i - ns, bloomFilter)) != -1) {
                ++j;
            }
            if (j != 0) {
                int l;
                int m = l = length + j * -diff;
                this.expand(m);
                char[] a = this.array;
                i = j = length;
                while ((i = this.lastIndexOf(s, ns, i - ns, bloomFilter)) != -1) {
                    System.arraycopy(a, i + ns, a, l -= j - i - ns, j - i - ns);
                    MutableString.getChars(r, 0, nr, a, l -= nr);
                    j = i;
                }
                this.hashLength = this.hashLength < 0 ? -1 : m;
            }
        }
        return this;
    }

    public final int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public final int indexOf(char c, int from) {
        int i;
        int length = this.length();
        char[] a = this.array;
        int n = i = from < 0 ? -1 : from - 1;
        while (++i < length) {
            if (a[i] != c) continue;
            return i;
        }
        return -1;
    }

    private static int buildFilter(char[] s, int n) {
        int i = n;
        int bloomFilter = 0;
        while (i-- != 0) {
            bloomFilter |= 1 << (s[i] & 0x1F);
        }
        return bloomFilter;
    }

    private int indexOf(char[] pattern, int n, int from, int bloomFilter) {
        int j;
        int m1 = this.length() - 1;
        char[] a = this.array;
        char[] p = pattern;
        char last = p[n - 1];
        int i = (from < 0 ? 0 : from) + n - 1;
        while (i < m1) {
            if (a[i] == last) {
                j = n - 1;
                int k = i;
                while (j-- != 0 && a[--k] == p[j]) {
                }
                if (j < 0) {
                    return k;
                }
            }
            if ((bloomFilter & 1 << (a[++i] & 0x1F)) != 0) continue;
            i += n;
        }
        if (i == m1) {
            j = n;
            while (j-- != 0) {
                if (a[i--] == p[j]) continue;
                return -1;
            }
            return i + 1;
        }
        return -1;
    }

    public final int indexOf(MutableString pattern, int from) {
        int n = pattern.length();
        if (n == 0) {
            return from > this.length() ? this.length() : (from < 0 ? 0 : from);
        }
        if (n == 1) {
            return this.indexOf(pattern.array[n - 1], from);
        }
        return this.indexOf(pattern.array, n, from, MutableString.buildFilter(pattern.array, n));
    }

    public final int indexOf(MutableString pattern) {
        return this.indexOf(pattern, 0);
    }

    private static int buildFilter(CharSequence s, int n) {
        int i = n;
        int bloomFilter = 0;
        while (i-- != 0) {
            bloomFilter |= 1 << (s.charAt(i) & 0x1F);
        }
        return bloomFilter;
    }

    private int indexOf(CharSequence pattern, int n, int from, int bloomFilter) {
        int j;
        int m1 = this.length() - 1;
        char[] a = this.array;
        char last = pattern.charAt(n - 1);
        int i = (from < 0 ? 0 : from) + n - 1;
        while (i < m1) {
            if (a[i] == last) {
                j = n - 1;
                int k = i;
                while (j-- != 0 && a[--k] == pattern.charAt(j)) {
                }
                if (j < 0) {
                    return k;
                }
            }
            if ((bloomFilter & 1 << (a[++i] & 0x1F)) != 0) continue;
            i += n;
        }
        if (i == m1) {
            j = n;
            while (j-- != 0) {
                if (a[i--] == pattern.charAt(j)) continue;
                return -1;
            }
            return i + 1;
        }
        return -1;
    }

    public final int indexOf(CharSequence pattern, int from) {
        int n = pattern.length();
        if (n == 0) {
            return from > this.length() ? this.length() : (from < 0 ? 0 : from);
        }
        if (n == 1) {
            return this.indexOf(pattern.charAt(n - 1), from);
        }
        return this.indexOf(pattern, n, from, MutableString.buildFilter(pattern, n));
    }

    public final int indexOf(CharSequence pattern) {
        return this.indexOf(pattern, 0);
    }

    public int indexOf(TextPattern pattern, int from) {
        return pattern.search(this.array(), from);
    }

    public int indexOf(TextPattern pattern) {
        return this.indexOf(pattern, 0);
    }

    public int indexOfAnyOf(CharSet s, int from) {
        int n = s.size();
        if (n == 0) {
            return -1;
        }
        if (n == 1) {
            return this.indexOf(s.iterator().nextChar(), from);
        }
        char[] a = this.array;
        int length = this.length();
        int i = (from < 0 ? 0 : from) - 1;
        while (++i < length) {
            if (!s.contains(a[i])) continue;
            return i;
        }
        return -1;
    }

    public int indexOfAnyOf(CharSet s) {
        return this.indexOfAnyOf(s, 0);
    }

    private int indexOfAnyOf(char[] c, int n, int from, int bloomFilter) {
        int m = this.length();
        if (n == 0) {
            return -1;
        }
        char[] a = this.array;
        int i = (from < 0 ? 0 : from) - 1;
        while (++i < m) {
            if ((bloomFilter & 1 << (a[i] & 0x1F)) == 0) continue;
            int k = n;
            while (k-- != 0) {
                if (a[i] != c[k]) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfAnyOf(char[] c, int from) {
        int n = c.length;
        if (n == 0) {
            return -1;
        }
        if (n == 1) {
            return this.indexOf(c[0], from);
        }
        return this.indexOfAnyOf(c, n, from, MutableString.buildFilter(c, n));
    }

    public int indexOfAnyOf(char[] c) {
        return this.indexOfAnyOf(c, 0);
    }

    public int indexOfAnyBut(CharSet s, int from) {
        char[] a = this.array;
        int length = this.length();
        int i = (from < 0 ? 0 : from) - 1;
        while (++i < length) {
            if (s.contains(a[i])) continue;
            return i;
        }
        return -1;
    }

    public int indexOfAnyBut(CharSet s) {
        return this.indexOfAnyOf(s, 0);
    }

    private int indexOfAnyBut(char[] c, int n, int from, int bloomFilter) {
        int m = this.length();
        if (n == 0) {
            return from < m ? from : -1;
        }
        char[] a = this.array;
        int i = (from < 0 ? 0 : from) - 1;
        while (++i < m) {
            if ((bloomFilter & 1 << (a[i] & 0x1F)) != 0) {
                int k = n;
                while (k-- != 0 && a[i] != c[k]) {
                }
                if (k != -1) continue;
                return i;
            }
            return i;
        }
        return -1;
    }

    public int indexOfAnyBut(char[] c, int from) {
        int n = c.length;
        return this.indexOfAnyBut(c, n, from < 0 ? 0 : from, MutableString.buildFilter(c, n));
    }

    public int indexOfAnyBut(char[] c) {
        return this.indexOfAnyOf(c, 0);
    }

    public final int lastIndexOf(char c) {
        char[] a = this.array;
        int i = this.length();
        while (i-- != 0) {
            if (a[i] != c) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(char c, int from) {
        char[] a = this.array;
        if (from < 0) {
            return -1;
        }
        int i = this.length();
        if (from < i) {
            i = from + 1;
        }
        if (i < 0) {
            return -1;
        }
        while (i-- != 0) {
            if (a[i] != c) continue;
            return i;
        }
        return -1;
    }

    private int lastIndexOf(char[] pattern, int n, int from, int bloomFilter) {
        int j;
        char[] a = this.array;
        char[] p = pattern;
        char first = p[0];
        int i = this.length() - n;
        if (from < i) {
            i = from;
        }
        while (i > 0) {
            if (a[i] == first) {
                j = n - 1;
                int k = 0;
                while (j-- != 0 && a[++i] == p[++k]) {
                }
                if (j < 0) {
                    return i - k;
                }
                i -= k;
            }
            if ((bloomFilter & 1 << (a[--i] & 0x1F)) != 0) continue;
            i -= n;
        }
        if (i == 0) {
            j = n;
            while (j-- != 0) {
                if (a[j] == p[j]) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public final int lastIndexOf(MutableString pattern, int from) {
        int n = pattern.length();
        if (from < 0) {
            return -1;
        }
        if (n == 0) {
            return from > this.length() ? this.length() : from;
        }
        if (n == 1) {
            return this.lastIndexOf(pattern.array[0], from);
        }
        return this.lastIndexOf(pattern.array, n, from, MutableString.buildFilter(pattern.array, n));
    }

    public final int lastIndexOf(MutableString pattern) {
        return this.lastIndexOf(pattern, this.length());
    }

    private int lastIndexOf(CharSequence pattern, int n, int from, int bloomFilter) {
        int j;
        char[] a = this.array;
        char first = pattern.charAt(0);
        int i = this.length() - n;
        if (from < i) {
            i = from;
        }
        while (i > 0) {
            if (a[i] == first) {
                j = n - 1;
                int k = 0;
                while (j-- != 0 && a[++i] == pattern.charAt(++k)) {
                }
                if (j < 0) {
                    return i - k;
                }
                i -= k;
            }
            if ((bloomFilter & 1 << (a[--i] & 0x1F)) != 0) continue;
            i -= n;
        }
        if (i == 0) {
            j = n;
            while (j-- != 0) {
                if (a[j] == pattern.charAt(j)) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public final int lastIndexOf(CharSequence pattern, int from) {
        int n = pattern.length();
        if (from < 0) {
            return -1;
        }
        if (n == 0) {
            return from > this.length() ? this.length() : from;
        }
        if (n == 1) {
            return this.lastIndexOf(pattern.charAt(0), from);
        }
        return this.lastIndexOf(pattern, n, from, MutableString.buildFilter(pattern, n));
    }

    public final int lastIndexOf(CharSequence pattern) {
        return this.lastIndexOf(pattern, this.length());
    }

    public int lastIndexOfAnyOf(CharSet s, int from) {
        if (from < 0) {
            return -1;
        }
        int n = s.size();
        if (n == 0) {
            return -1;
        }
        if (n == 1) {
            return this.lastIndexOf(s.iterator().nextChar(), from);
        }
        char[] a = this.array;
        int i = this.length();
        if (from < i) {
            i = from + 1;
        }
        while (i-- > 0) {
            if (!s.contains(a[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfAnyOf(CharSet s) {
        return this.lastIndexOfAnyOf(s, this.length());
    }

    private int lastIndexOfAnyOf(char[] c, int n, int from, int bloomFilter) {
        if (n == 0) {
            return -1;
        }
        char[] a = this.array;
        int i = this.length();
        if (from < i) {
            i = from + 1;
        }
        while (i-- > 0) {
            if ((bloomFilter & 1 << (a[i] & 0x1F)) == 0) continue;
            int k = n;
            while (k-- != 0) {
                if (a[i] != c[k]) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOfAnyOf(char[] c, int from) {
        int n = c.length;
        if (from < 0) {
            return -1;
        }
        if (n == 0) {
            return -1;
        }
        if (n == 1) {
            return this.lastIndexOf(c[0], from);
        }
        return this.lastIndexOfAnyOf(c, n, from, MutableString.buildFilter(c, n));
    }

    public int lastIndexOfAnyOf(char[] c) {
        return this.lastIndexOfAnyOf(c, this.length());
    }

    public int lastIndexOfAnyBut(CharSet s, int from) {
        if (from < 0) {
            return -1;
        }
        char[] a = this.array;
        int i = this.length();
        if (s.size() == 0) {
            return from < i ? from : i - 1;
        }
        if (from < i) {
            i = from + 1;
        }
        while (i-- > 0) {
            if (s.contains(a[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfAnyBut(CharSet s) {
        return this.lastIndexOfAnyBut(s, this.length());
    }

    private int lastIndexOfAnyBut(char[] c, int n, int from, int bloomFilter) {
        char[] a = this.array;
        int i = this.length();
        if (i == 0) {
            return -1;
        }
        if (n == 0) {
            return from < i ? from : i - 1;
        }
        if (from < i) {
            i = from + 1;
        }
        while (i-- != 0) {
            if ((bloomFilter & 1 << (a[i] & 0x1F)) != 0) {
                int k = n;
                while (k-- != 0 && a[i] != c[k]) {
                }
                if (k != -1) continue;
                return i;
            }
            return i;
        }
        return -1;
    }

    public int lastIndexOfAnyBut(char[] c, int from) {
        if (from < 0) {
            return -1;
        }
        int n = c.length;
        return this.lastIndexOfAnyBut(c, n, from, MutableString.buildFilter(c, n));
    }

    public int lastIndexOfAnyBut(char[] c) {
        return this.lastIndexOfAnyBut(c, 0);
    }

    public int span(CharSet s, int from) {
        int length = this.length();
        if (s.size() == 0) {
            return 0;
        }
        char[] a = this.array;
        if (from < 0) {
            from = 0;
        }
        int i = from - 1;
        while (++i < length && s.contains(a[i])) {
        }
        return i - from;
    }

    public int span(CharSet s) {
        return this.span(s, 0);
    }

    public int span(char[] c, int from) {
        int length = this.length();
        int n = c.length;
        if (n == 0) {
            return 0;
        }
        int bloomFilter = MutableString.buildFilter(c, n);
        char[] a = this.array;
        if (from < 0) {
            from = 0;
        }
        int i = from - 1;
        while (++i < length) {
            if ((bloomFilter & 1 << (a[i] & 0x1F)) != 0) {
                int k = n;
                while (k-- != 0 && a[i] != c[k]) {
                }
                if (k != -1) continue;
                return i - from;
            }
            return i - from;
        }
        return i - from;
    }

    public int span(char[] c) {
        return this.span(c, 0);
    }

    public int cospan(CharSet s, int from) {
        int length = this.length();
        if (s.size() == 0) {
            return from < 0 ? length : (from < length ? length - from : 0);
        }
        char[] a = this.array;
        if (from < 0) {
            from = 0;
        }
        int i = from - 1;
        while (++i < length && !s.contains(a[i])) {
        }
        return i - from;
    }

    public int cospan(CharSet s) {
        return this.cospan(s, 0);
    }

    public int cospan(char[] c, int from) {
        int length = this.length();
        int n = c.length;
        if (n == 0) {
            return from < 0 ? length : (from < length ? length - from : 0);
        }
        int bloomFilter = MutableString.buildFilter(c, n);
        char[] a = this.array;
        if (from < 0) {
            from = 0;
        }
        int i = from - 1;
        while (++i < length) {
            if ((bloomFilter & 1 << (a[i] & 0x1F)) == 0) continue;
            int k = n;
            while (k-- != 0 && a[i] != c[k]) {
            }
            if (k == -1) continue;
            return i - from;
        }
        return i - from;
    }

    public int cospan(char[] c) {
        return this.cospan(c, 0);
    }

    public final boolean startsWith(MutableString prefix) {
        int l = prefix.length();
        if (l > this.length()) {
            return false;
        }
        int i = l;
        char[] a1 = prefix.array;
        char[] a2 = this.array;
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWith(String prefix) {
        int l = prefix.length();
        if (l > this.length()) {
            return false;
        }
        int i = l;
        char[] a = this.array;
        while (i-- != 0) {
            if (prefix.charAt(i) == a[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWith(CharSequence prefix) {
        int l = prefix.length();
        if (l > this.length()) {
            return false;
        }
        int i = l;
        char[] a = this.array;
        while (i-- != 0) {
            if (prefix.charAt(i) == a[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWithIgnoreCase(MutableString prefix) {
        int l = prefix.length();
        if (l > this.length()) {
            return false;
        }
        int i = l;
        char[] a1 = prefix.array;
        char[] a2 = this.array;
        while (i-- != 0) {
            char d;
            char c = Character.toLowerCase(Character.toUpperCase(a1[i]));
            if (c == (d = Character.toLowerCase(Character.toUpperCase(a2[i])))) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWithIgnoreCase(String prefix) {
        int l = prefix.length();
        if (l > this.length()) {
            return false;
        }
        int i = l;
        char[] a = this.array;
        while (i-- != 0) {
            char d;
            char c = Character.toLowerCase(Character.toUpperCase(a[i]));
            if (c == (d = Character.toLowerCase(Character.toUpperCase(prefix.charAt(i))))) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWithIgnoreCase(CharSequence prefix) {
        int l = prefix.length();
        if (l > this.length()) {
            return false;
        }
        int i = l;
        char[] a = this.array;
        while (i-- != 0) {
            char d;
            char c = Character.toLowerCase(Character.toUpperCase(a[i]));
            if (c == (d = Character.toLowerCase(Character.toUpperCase(prefix.charAt(i))))) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWith(MutableString suffix) {
        int length;
        int l = suffix.length();
        if (l > (length = this.length())) {
            return false;
        }
        int i = l;
        char[] a1 = suffix.array;
        char[] a2 = this.array;
        while (i-- != 0) {
            if (a1[i] == a2[--length]) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWith(String suffix) {
        int length;
        int l = suffix.length();
        if (l > (length = this.length())) {
            return false;
        }
        int i = l;
        char[] a = this.array;
        while (i-- != 0) {
            if (suffix.charAt(i) == a[--length]) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWith(CharSequence suffix) {
        int length;
        int l = suffix.length();
        if (l > (length = this.length())) {
            return false;
        }
        int i = l;
        char[] a = this.array;
        while (i-- != 0) {
            if (suffix.charAt(i) == a[--length]) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWithIgnoreCase(MutableString suffix) {
        int length;
        int l = suffix.length();
        if (l > (length = this.length())) {
            return false;
        }
        int i = l;
        char[] a1 = suffix.array;
        char[] a2 = this.array;
        while (i-- != 0) {
            char d;
            char c = Character.toLowerCase(Character.toUpperCase(a1[i]));
            if (c == (d = Character.toLowerCase(Character.toUpperCase(a2[--length])))) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWithIgnoreCase(String suffix) {
        int length;
        int l = suffix.length();
        if (l > (length = this.length())) {
            return false;
        }
        int i = l;
        char[] a = this.array;
        while (i-- != 0) {
            char d;
            char c = Character.toLowerCase(Character.toUpperCase(suffix.charAt(i)));
            if (c == (d = Character.toLowerCase(Character.toUpperCase(a[--length])))) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWithIgnoreCase(CharSequence suffix) {
        int length;
        int l = suffix.length();
        if (l > (length = this.length())) {
            return false;
        }
        int i = l;
        char[] a = this.array;
        while (i-- != 0) {
            char d;
            char c = Character.toLowerCase(Character.toUpperCase(suffix.charAt(i)));
            if (c == (d = Character.toLowerCase(Character.toUpperCase(a[--length])))) continue;
            return false;
        }
        return true;
    }

    public final MutableString toLowerCase() {
        int n = this.length();
        char[] a = this.array;
        while (n-- != 0) {
            a[n] = Character.toLowerCase(a[n]);
        }
        this.changed();
        return this;
    }

    public final MutableString toUpperCase() {
        int n = this.length();
        char[] a = this.array;
        while (n-- != 0) {
            a[n] = Character.toUpperCase(a[n]);
        }
        this.changed();
        return this;
    }

    public final MutableString trim() {
        int i;
        int length = this.length();
        char[] a = this.array;
        if (length == 0) {
            return this;
        }
        for (i = 0; i < length && a[i] <= ' '; ++i) {
        }
        if (i == length) {
            if (this.hashLength < 0) {
                this.hashLength = -1;
                this.array = CharArrays.EMPTY_ARRAY;
                return this;
            }
            this.hashLength = 0;
            return this;
        }
        int j = length;
        while (a[--j] <= ' ') {
        }
        int newLength = j - i + 1;
        if (length == newLength) {
            return this;
        }
        System.arraycopy(this.array, i, this.array, 0, newLength);
        if (this.hashLength < 0) {
            this.setCapacity(newLength);
            this.hashLength = -1;
        } else {
            this.hashLength = newLength;
        }
        return this;
    }

    public final MutableString trimLeft() {
        int newLength;
        int i;
        int length = this.length();
        char[] a = this.array;
        if (length == 0) {
            return this;
        }
        for (i = 0; i < length && a[i] <= ' '; ++i) {
        }
        if (i == length) {
            if (this.hashLength < 0) {
                this.hashLength = -1;
                this.array = CharArrays.EMPTY_ARRAY;
                return this;
            }
            this.hashLength = 0;
        }
        if (length == (newLength = length - i)) {
            return this;
        }
        System.arraycopy(this.array, i, this.array, 0, newLength);
        if (this.hashLength < 0) {
            this.setCapacity(newLength);
            this.hashLength = -1;
        } else {
            this.hashLength = newLength;
        }
        return this;
    }

    public final MutableString trimRight() {
        int length = this.length();
        char[] a = this.array;
        if (length == 0) {
            return this;
        }
        int j = length;
        while (j-- != 0 && a[j] <= ' ') {
        }
        int newLength = j + 1;
        if (length == newLength) {
            return this;
        }
        if (this.hashLength < 0) {
            this.setCapacity(newLength);
            this.hashLength = -1;
        } else {
            this.hashLength = newLength;
        }
        return this;
    }

    public final MutableString squeezeSpaces(boolean squeezeOnlyWhitespace) {
        int length = this.length();
        char[] a = this.array;
        int i = 0;
        int j = 0;
        while (i < length) {
            if (!(!squeezeOnlyWhitespace ? Character.isSpaceChar(a[i]) : Character.isWhitespace(a[i]))) {
                a[j++] = a[i++];
                continue;
            }
            a[j++] = 32;
            while (i < length && (squeezeOnlyWhitespace ? Character.isWhitespace(a[i]) : Character.isSpaceChar(a[i]))) {
                ++i;
            }
        }
        if (length == j) {
            return this;
        }
        if (this.hashLength < 0) {
            this.setCapacity(j);
            this.hashLength = -1;
        } else {
            this.hashLength = j;
        }
        return this;
    }

    public final MutableString squeezeWhitespace() {
        return this.squeezeSpaces(true);
    }

    public final MutableString squeezeSpace() {
        return this.squeezeSpaces(false);
    }

    public final MutableString reverse() {
        int k = this.length() - 1;
        char[] a = this.array;
        int i = (k - 1) / 2 + 1;
        while (i-- != 0) {
            char c = a[i];
            a[i] = a[k - i];
            a[k - i] = c;
        }
        this.changed();
        return this;
    }

    public final void write(Writer w) throws IOException {
        if (this.hashLength < 0) {
            w.write(this.array);
        } else {
            w.write(this.array, 0, this.hashLength);
        }
    }

    public final int read(Reader r, int length) throws IOException {
        boolean compact = this.hashLength < 0;
        this.expand(length);
        this.hashLength = 0;
        int result = r.read(this.array, 0, length);
        this.hashLength = result < length ? (result == -1 ? 0 : result) : (compact && length == this.array.length ? -1 : length);
        return result;
    }

    public final void print(PrintWriter w) {
        if (this.hashLength < 0) {
            w.write(this.array);
        } else {
            w.write(this.array, 0, this.hashLength);
        }
    }

    public final void println(PrintWriter w) {
        this.print(w);
        w.println();
    }

    public final void print(PrintStream s) {
        if (this.hashLength < 0) {
            s.print(this.array);
        } else {
            s.print(this.toString());
        }
    }

    public final void println(PrintStream s) {
        this.print(s);
        s.println();
    }

    public final void writeUTF8(DataOutput s) throws IOException {
        this.writeUTF8(s, this.length());
    }

    private void writeUTF8(DataOutput s, int length) throws IOException {
        char[] a = this.array;
        for (int i = 0; i < length; ++i) {
            char c = a[i];
            if (c <= '\u007f') {
                s.write(c);
                continue;
            }
            if (c >= '\u0800') {
                s.write((byte)(0xE0 | c >> 12 & 0xF));
                s.write((byte)(0x80 | c >> 6 & 0x3F));
                s.write((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            s.write((byte)(0xC0 | c >> 6 & 0x1F));
            s.write((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    public final MutableString readUTF8(DataInput s, int length) throws IOException {
        boolean compact = this.hashLength < 0;
        this.expand(length);
        char[] a = this.array;
        block5: for (int i = 0; i < length; ++i) {
            int b = s.readByte() & 0xFF;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    a[i] = (char)b;
                    continue block5;
                }
                case 12: 
                case 13: {
                    int c = s.readByte() & 0xFF;
                    if ((c & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    a[i] = (char)((b & 0x1F) << 6 | c & 0x3F);
                    continue block5;
                }
                case 14: {
                    int c = s.readByte() & 0xFF;
                    int d = s.readByte() & 0xFF;
                    if ((c & 0xC0) != 128 || (d & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    a[i] = (char)((b & 0xF) << 12 | (c & 0x3F) << 6 | (d & 0x3F) << 0);
                    continue block5;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        this.hashLength = compact && length == a.length ? -1 : length;
        return this;
    }

    public final void writeSelfDelimUTF8(DataOutput s) throws IOException {
        int length = this.length();
        if (length < 128) {
            s.writeByte(length);
        } else if (length < 16384) {
            s.writeByte(length >>> 7 & 0x7F | 0x80);
            s.writeByte(length & 0x7F);
        } else if (length < 0x200000) {
            s.writeByte(length >>> 14 & 0x7F | 0x80);
            s.writeByte(length >>> 7 & 0x7F | 0x80);
            s.writeByte(length & 0x7F);
        } else if (length < 0x10000000) {
            s.writeByte(length >>> 21 & 0x7F | 0x80);
            s.writeByte(length >>> 14 & 0x7F | 0x80);
            s.writeByte(length >>> 7 & 0x7F | 0x80);
            s.writeByte(length & 0x7F);
        } else {
            s.writeByte(length >>> 28 & 0x7F | 0x80);
            s.writeByte(length >>> 21 & 0x7F | 0x80);
            s.writeByte(length >>> 14 & 0x7F | 0x80);
            s.writeByte(length >>> 7 & 0x7F | 0x80);
            s.writeByte(length & 0x7F);
        }
        this.writeUTF8(s, length);
    }

    public final MutableString readSelfDelimUTF8(DataInput s) throws IOException {
        byte b;
        int length = 0;
        while ((b = s.readByte()) < 0) {
            length |= b & 0x7F;
            length <<= 7;
        }
        this.readUTF8(s, length |= b);
        return this;
    }

    public final void writeUTF8(OutputStream s) throws IOException {
        this.writeUTF8(s, this.length());
    }

    private void writeUTF8(OutputStream s, int length) throws IOException {
        char[] a = this.array;
        for (int i = 0; i < length; ++i) {
            char c = a[i];
            if (c <= '\u007f') {
                s.write(c);
                continue;
            }
            if (c >= '\u0800') {
                s.write((byte)(0xE0 | c >> 12 & 0xF));
                s.write((byte)(0x80 | c >> 6 & 0x3F));
                s.write((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            s.write((byte)(0xC0 | c >> 6 & 0x1F));
            s.write((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    public static int skipSelfDelimUTF8(InputStream s) throws IOException {
        int b;
        int length = 0;
        while (true) {
            if ((b = s.read()) < 0) {
                throw new EOFException();
            }
            if ((b & 0x80) == 0) break;
            length |= b & 0x7F;
            length <<= 7;
        }
        length |= b;
        block6: for (int i = 0; i < length; ++i) {
            b = s.read();
            if (b == -1) {
                throw new EOFException();
            }
            switch ((b &= 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    continue block6;
                }
                case 12: 
                case 13: {
                    int c = s.read();
                    if (c == -1) {
                        throw new EOFException();
                    }
                    if (((c &= 0xFF) & 0xC0) == 128) continue block6;
                    throw new UTFDataFormatException();
                }
                case 14: {
                    int c = s.read();
                    if (c == -1) {
                        throw new EOFException();
                    }
                    c &= 0xFF;
                    int d = s.read();
                    if (d == -1) {
                        throw new EOFException();
                    }
                    if ((c & 0xC0) == 128 && ((d &= 0xFF) & 0xC0) == 128) continue block6;
                    throw new UTFDataFormatException();
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return length;
    }

    public final MutableString readUTF8(InputStream s, int length) throws IOException {
        boolean compact = this.hashLength < 0;
        this.expand(length);
        char[] a = this.array;
        block5: for (int i = 0; i < length; ++i) {
            int b = s.read();
            if (b == -1) {
                throw new EOFException();
            }
            switch ((b &= 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    a[i] = (char)b;
                    continue block5;
                }
                case 12: 
                case 13: {
                    int c = s.read();
                    if (c == -1) {
                        throw new EOFException();
                    }
                    if (((c &= 0xFF) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    a[i] = (char)((b & 0x1F) << 6 | c & 0x3F);
                    continue block5;
                }
                case 14: {
                    int c = s.read();
                    if (c == -1) {
                        throw new EOFException();
                    }
                    c &= 0xFF;
                    int d = s.read();
                    if (d == -1) {
                        throw new EOFException();
                    }
                    if ((c & 0xC0) != 128 || ((d &= 0xFF) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    a[i] = (char)((b & 0xF) << 12 | (c & 0x3F) << 6 | (d & 0x3F) << 0);
                    continue block5;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        this.hashLength = compact && length == a.length ? -1 : length;
        return this;
    }

    public final void writeSelfDelimUTF8(OutputStream s) throws IOException {
        int length = this.length();
        if (length < 128) {
            s.write(length);
        } else if (length < 16384) {
            s.write(length >>> 7 & 0x7F | 0x80);
            s.write(length & 0x7F);
        } else if (length < 0x200000) {
            s.write(length >>> 14 & 0x7F | 0x80);
            s.write(length >>> 7 & 0x7F | 0x80);
            s.write(length & 0x7F);
        } else if (length < 0x10000000) {
            s.write(length >>> 21 & 0x7F | 0x80);
            s.write(length >>> 14 & 0x7F | 0x80);
            s.write(length >>> 7 & 0x7F | 0x80);
            s.write(length & 0x7F);
        } else {
            s.write(length >>> 28 & 0x7F | 0x80);
            s.write(length >>> 21 & 0x7F | 0x80);
            s.write(length >>> 14 & 0x7F | 0x80);
            s.write(length >>> 7 & 0x7F | 0x80);
            s.write(length & 0x7F);
        }
        this.writeUTF8(s, length);
    }

    public final MutableString readSelfDelimUTF8(InputStream s) throws IOException {
        int b;
        int length = 0;
        while (true) {
            if ((b = s.read()) < 0) {
                throw new EOFException();
            }
            if ((b & 0x80) == 0) break;
            length |= b & 0x7F;
            length <<= 7;
        }
        this.readUTF8(s, length |= b);
        return this;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof MutableString) {
            return this.equals((MutableString)o);
        }
        if (o instanceof String) {
            return this.equals((String)o);
        }
        if (o instanceof CharSequence) {
            return this.equals((CharSequence)o);
        }
        return false;
    }

    public final boolean equals(MutableString s) {
        if (s == this) {
            return true;
        }
        int n = this.length();
        if (n == s.length()) {
            char[] a1 = this.array;
            char[] a2 = s.array;
            while (n-- != 0) {
                if (a1[n] == a2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equals(String s) {
        int n = this.length();
        if (n == s.length()) {
            char[] a = this.array;
            while (n-- != 0) {
                if (a[n] == s.charAt(n)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equals(CharSequence s) {
        int n = this.length();
        if (n == s.length()) {
            char[] a = this.array;
            while (n-- != 0) {
                if (a[n] == s.charAt(n)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equalsIgnoreCase(MutableString s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        int n = this.length();
        if (n == s.length()) {
            char[] a1 = this.array;
            char[] a2 = s.array;
            for (int i = 0; i < n; ++i) {
                if (a1[i] == a2[i] || Character.toLowerCase(a1[i]) == Character.toLowerCase(a2[i]) || Character.toUpperCase(a1[i]) == Character.toUpperCase(a2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equalsIgnoreCase(String s) {
        if (s == null) {
            return false;
        }
        int n = this.length();
        if (n == s.length()) {
            char[] a = this.array;
            for (int i = 0; i < n; ++i) {
                char c = s.charAt(i);
                if (a[i] == c || Character.toLowerCase(a[i]) == Character.toLowerCase(c) || Character.toUpperCase(a[i]) == Character.toUpperCase(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equalsIgnoreCase(CharSequence s) {
        if (s == null) {
            return false;
        }
        int n = this.length();
        if (n == s.length()) {
            char[] a = this.array;
            for (int i = 0; i < n; ++i) {
                char c = s.charAt(i);
                if (a[i] == c || Character.toLowerCase(a[i]) == Character.toLowerCase(c) || Character.toUpperCase(a[i]) == Character.toUpperCase(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final int compareTo(MutableString s) {
        int l2;
        int l1 = this.length();
        int n = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a1 = this.array;
        char[] a2 = s.array;
        for (int i = 0; i < n; ++i) {
            if (a1[i] == a2[i]) continue;
            return a1[i] - a2[i];
        }
        return l1 - l2;
    }

    @Override
    public final int compareTo(String s) {
        int l2;
        int l1 = this.length();
        int n = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a = this.array;
        for (int i = 0; i < n; ++i) {
            if (a[i] == s.charAt(i)) continue;
            return a[i] - s.charAt(i);
        }
        return l1 - l2;
    }

    @Override
    public final int compareTo(CharSequence s) {
        int l2;
        int l1 = this.length();
        int n = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a = this.array;
        for (int i = 0; i < n; ++i) {
            if (a[i] == s.charAt(i)) continue;
            return a[i] - s.charAt(i);
        }
        return l1 - l2;
    }

    public final int compareToIgnoreCase(MutableString s) {
        int l2;
        int l1 = this.length();
        int n = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a1 = this.array;
        char[] a2 = s.array;
        for (int i = 0; i < n; ++i) {
            char d;
            char c = Character.toLowerCase(Character.toUpperCase(a1[i]));
            if (c == (d = Character.toLowerCase(Character.toUpperCase(a2[i])))) continue;
            return c - d;
        }
        return l1 - l2;
    }

    public final int compareToIgnoreCase(String s) {
        int l2;
        int l1 = this.length();
        int n = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a = this.array;
        for (int i = 0; i < n; ++i) {
            char d;
            char c = Character.toLowerCase(Character.toUpperCase(a[i]));
            if (c == (d = Character.toLowerCase(Character.toUpperCase(s.charAt(i))))) continue;
            return c - d;
        }
        return l1 - l2;
    }

    public final int compareToIgnoreCase(CharSequence s) {
        int l2;
        int l1 = this.length();
        int n = l1 < (l2 = s.length()) ? l1 : l2;
        char[] a = this.array;
        for (int i = 0; i < n; ++i) {
            char d;
            char c = Character.toLowerCase(Character.toUpperCase(a[i]));
            if (c == (d = Character.toLowerCase(Character.toUpperCase(s.charAt(i))))) continue;
            return c - d;
        }
        return l1 - l2;
    }

    public final int hashCode() {
        int h = this.hashLength;
        if (h >= -1) {
            char[] a = this.array;
            int l = this.length();
            h = 0;
            for (int i = 0; i < l; ++i) {
                h = 31 * h + a[i];
            }
            h |= Integer.MIN_VALUE;
            if (this.hashLength == -1) {
                this.hashLength = h;
            }
        }
        return h;
    }

    @Override
    public final String toString() {
        return new String(this.array, 0, this.length());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int length = this.length();
        char[] a = this.array;
        s.writeInt(length);
        for (int i = 0; i < length; ++i) {
            s.writeChar(a[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int length = s.readInt();
        this.hashLength = -1;
        this.expand(length);
        char[] a = this.array;
        for (int i = 0; i < length; ++i) {
            a[i] = s.readChar();
        }
    }

    private class SubSequence
    implements CharSequence {
        final int from;
        final int to;

        private SubSequence(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public char charAt(int index) {
            return MutableString.this.array[this.from + index];
        }

        public int length() {
            return this.to - this.from;
        }

        public CharSequence subSequence(int start, int end) {
            if (start < 0) {
                throw new StringIndexOutOfBoundsException(start);
            }
            if (end < start || end > this.length()) {
                throw new StringIndexOutOfBoundsException(end);
            }
            return new SubSequence(this.from + start, this.from + end);
        }

        public int hashCode() {
            int h = 0;
            char[] a = MutableString.this.array;
            for (int i = this.from; i < this.to; ++i) {
                h = 31 * h + a[i];
            }
            return h | Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            if (o instanceof CharSequence) {
                CharSequence s = (CharSequence)o;
                int n = this.length();
                if (n == s.length()) {
                    while (n-- != 0) {
                        if (this.charAt(n) == s.charAt(n)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return new String(MutableString.this.array, this.from, this.to - this.from);
        }
    }
}

